/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.height;

import de.wideportal.maprender.config.xml.RenderConfigurationDatasources;
import de.wideportal.maprender.config.xml.RenderConfigurationGebco;
import de.wideportal.maprender.config.xml.RenderConfigurationJaxa;
import de.wideportal.maprender.config.xml.RenderConfigurationSrtm;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.gebco.GebcoTileAccessor;
import de.wideportal.maprender.resources.gebco.GebcoTileCache;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileAccessor;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.jaxa.JaxaTileAccessor;
import de.wideportal.maprender.resources.jaxa.JaxaTileCache;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmTileAccessor;
import de.wideportal.maprender.resources.srtm.SrtmTileCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightTileAccessor
implements ITileAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    ITileAccessor accessorImpl;

    public HeightTileAccessor(RenderConfigurationDatasources renderConfigurationDatasources) {
        if (renderConfigurationDatasources.getSrtm() != null) {
            RenderConfigurationSrtm srtmConfig = renderConfigurationDatasources.getSrtm();
            SrtmTileCache srtmTileCache = new SrtmTileCache(srtmConfig);
            this.accessorImpl = new SrtmTileAccessor(srtmTileCache);
            return;
        }
        if (renderConfigurationDatasources.getJaxa() != null) {
            RenderConfigurationJaxa jaxaConfig = renderConfigurationDatasources.getJaxa();
            JaxaTileCache jaxaTileCache = new JaxaTileCache(jaxaConfig);
            this.accessorImpl = new JaxaTileAccessor(jaxaTileCache);
            return;
        }
        if (renderConfigurationDatasources.getGebco() != null) {
            RenderConfigurationGebco gebcoConfig = renderConfigurationDatasources.getGebco();
            GebcoTileCache gebcoTileCache = new GebcoTileCache(gebcoConfig);
            this.accessorImpl = new GebcoTileAccessor(gebcoTileCache);
            return;
        }
    }

    @Override
    public List<ITile> getCachedTiles() {
        return this.accessorImpl.getTileCache().getTiles();
    }

    @Override
    public ITileCache getTileCache() {
        return this.accessorImpl.getTileCache();
    }

    @Override
    public boolean isAvailable() {
        return this.accessorImpl != null && this.accessorImpl.isAvailable();
    }

    @Override
    public List<ITile> getUnloadedTiles(BoundingBox latLonBBox, int heightDiffThreshold, int heightPointDiffThreshold) {
        return this.accessorImpl.getTileCache().getUnloadedTiles(latLonBBox, heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public ITile loadTile(ITile unloadedTile, int heightDiffThreshold) {
        return this.accessorImpl.getTileCache().loadTile(unloadedTile, heightDiffThreshold);
    }

    @Override
    public void saveCollectedValuesToCache(int zoom, int xTileIndex, int yTileIndex, HeightCollectorTile heightCollectorTile, int heightDiffThreshold, int heightPointDiffThreshold) {
        this.accessorImpl.saveCollectedValuesToCache(zoom, xTileIndex, yTileIndex, heightCollectorTile, heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public HeightCollectorTile collectValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        return this.accessorImpl.collectValues(zoom, xTileIndex, yTileIndex, latLonBBox, renderRequest, tileSize, renderMockTiles, heightDiffThreshold, heightPointDiffThreshold, tileOutputter);
    }

    @Override
    public HeightCollectorTile[] collectSurroundingValues(int zoom, int xTileIndex, int yTileIndex, BoundingBox latLonBoundingBox, RenderRequest renderRequest, long tileSize, boolean renderMockTiles, int heightDiffThreshold, int heightPointDiffThreshold, AbstractMapTileOutput tileOutputter) {
        return this.accessorImpl.collectSurroundingValues(zoom, xTileIndex, yTileIndex, latLonBoundingBox, renderRequest, tileSize, renderMockTiles, heightDiffThreshold, heightPointDiffThreshold, tileOutputter);
    }
}

