/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.height;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.resources.height.buffer.MultiValueCollectorBuffer;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.io.Serializable;

public class HeightCollectorTile_Old
implements Serializable {
    private static final long serialVersionUID = -5217612422043428618L;
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    public static final int TILE_BORDER_BUFFER_PIXELS_BASE = 50;
    private BoundingBox latLonBBox;
    private BoundingBox latLonCollectFromBox;
    private int pixelTileSize;
    private int bufferedTileSize;
    private MultiValueCollectorBuffer multipleValueBuffer;
    private boolean needsExpensiveSmoothing = false;
    private float minValue = Float.MAX_VALUE;
    private float maxValue = -3.4028235E38f;
    public int subTileSizeX = -1;
    public int subTileSizeY = -1;

    public HeightCollectorTile_Old(BoundingBox latLonBBox, BoundingBox latLonCollectFromBox, int pixelTileSize) {
        this.latLonBBox = latLonBBox;
        this.latLonCollectFromBox = latLonCollectFromBox;
        this.pixelTileSize = pixelTileSize;
        this.bufferedTileSize = pixelTileSize + 100;
        this.multipleValueBuffer = new MultiValueCollectorBuffer(this.bufferedTileSize, this.bufferedTileSize);
    }

    public HeightCollectorTile_Old(BoundingBox latLonBBox, BoundingBox latLonCollectFromBox, int pixelTileSize, int bufferedTileSize, MultiValueCollectorBuffer multipleValueBuffer, boolean needsExpensiveSmoothing, float minValue, float maxValue) {
        this.latLonBBox = latLonBBox;
        this.latLonCollectFromBox = latLonCollectFromBox;
        this.pixelTileSize = pixelTileSize;
        this.bufferedTileSize = bufferedTileSize;
        this.multipleValueBuffer = multipleValueBuffer;
        this.needsExpensiveSmoothing = needsExpensiveSmoothing;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public BoundingBox getLatLonBBox() {
        return this.latLonBBox;
    }

    public int getPixelTileSize() {
        return this.pixelTileSize;
    }

    public int getBufferedTileSize() {
        return this.bufferedTileSize;
    }

    public BoundingBox getLatLonCollectFromBox() {
        return this.latLonCollectFromBox;
    }

    public int getSubTileSizeX() {
        return this.subTileSizeX;
    }

    public int getSubTileSizeY() {
        return this.subTileSizeY;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public MultiValueCollectorBuffer getMultipleValueBuffer() {
        return this.multipleValueBuffer;
    }

    public boolean performNeedsExpensiveSmoothingCheck(double inputCellWidth, double inputCellHeight, long tileSize) {
        double collectorTileLonLeft = this.latLonBBox.getLeft();
        double collectorTileLonRight = this.latLonBBox.getRight();
        double collectorTileLatBottom = this.latLonBBox.getBottom();
        double collectorTileLatTop = this.latLonBBox.getTop();
        double collectorCellWidth = Math.abs(collectorTileLonRight - collectorTileLonLeft) / (double)tileSize;
        double collectorCellHeight = Math.abs(collectorTileLatTop - collectorTileLatBottom) / (double)tileSize;
        if (collectorCellWidth >= inputCellWidth / 3.0 || collectorCellHeight >= inputCellHeight / 3.0) {
            this.needsExpensiveSmoothing = true;
        }
        return this.needsExpensiveSmoothing;
    }

    public boolean needsExpensiveSmoothing() {
        return this.needsExpensiveSmoothing;
    }

    public void addValueSimple(double leftLon, double topLat, double rightLon, double bottomLat, double zoom, float value, AbstractMapTileOutput tileOutputter) {
        int bottomCellIndex;
        int topCellIndex;
        int rightCellIndex;
        Point leftTopXYPixel = tileOutputter.getLonLatToPixel(leftLon, topLat, zoom);
        Point rightBottomXYPixel = tileOutputter.getLonLatToPixel(rightLon, bottomLat, zoom);
        double leftX = leftTopXYPixel.getX();
        double rightX = rightBottomXYPixel.getX();
        double topY = leftTopXYPixel.getY();
        double bottomY = rightBottomXYPixel.getY();
        Point collectorTileLeftTopXYPixel = tileOutputter.getLonLatToPixel(this.getLatLonBBox().getLeft(), this.getLatLonBBox().getTop(), zoom);
        double collectorTileXLeft = collectorTileLeftTopXYPixel.getX();
        double collectorTileYTop = collectorTileLeftTopXYPixel.getY();
        double topPixel = topY - collectorTileYTop;
        double bottomPixel = bottomY - collectorTileYTop;
        double leftPixel = leftX - collectorTileXLeft;
        double rightPixel = rightX - collectorTileXLeft;
        int leftCellIndex = (int)Math.floor(leftPixel);
        if (leftCellIndex < -50) {
            leftCellIndex = -50;
        }
        if ((rightCellIndex = (int)Math.ceil(rightPixel)) == leftCellIndex) {
            rightCellIndex = leftCellIndex + 1;
        }
        if (rightCellIndex < -50) {
            rightCellIndex = -50;
        }
        if (rightCellIndex > this.pixelTileSize + 50) {
            rightCellIndex = this.pixelTileSize + 50;
        }
        if ((topCellIndex = (int)Math.floor(topPixel)) < -50) {
            topCellIndex = -50;
        }
        if ((bottomCellIndex = (int)Math.ceil(bottomPixel)) == topCellIndex) {
            bottomCellIndex = topCellIndex + 1;
        }
        if (bottomCellIndex < -50) {
            bottomCellIndex = -50;
        }
        if (bottomCellIndex > this.pixelTileSize + 50) {
            bottomCellIndex = this.pixelTileSize + 50;
        }
        int currentCellSizeX = rightCellIndex - leftCellIndex;
        this.subTileSizeX = Math.max(this.subTileSizeX, currentCellSizeX);
        this.subTileSizeX = Math.max(this.subTileSizeX, 1);
        int currentCellSizeY = bottomCellIndex - topCellIndex;
        this.subTileSizeY = Math.max(this.subTileSizeY, currentCellSizeY);
        this.subTileSizeY = Math.max(this.subTileSizeY, 1);
        for (int yPixelCell = topCellIndex; yPixelCell < bottomCellIndex; ++yPixelCell) {
            for (int xPixelCell = leftCellIndex; xPixelCell < rightCellIndex; ++xPixelCell) {
                this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, value);
                this.minValue = Math.min(this.minValue, value);
                this.maxValue = Math.max(this.maxValue, value);
            }
        }
    }

    public void addValue(double leftLon, double topLat, double rightLon, double bottomLat, double zoom, float value, float[] surroundingCellHeights, AbstractMapTileOutput tileOutputter) {
        int bottomCellIndex;
        int topCellIndex;
        int rightCellIndex;
        int leftCellIndex;
        Point leftTopXYPixel = tileOutputter.getLonLatToPixel(leftLon, topLat, zoom);
        Point rightBottomXYPixel = tileOutputter.getLonLatToPixel(rightLon, bottomLat, zoom);
        double leftX = leftTopXYPixel.getX();
        double rightX = rightBottomXYPixel.getX();
        double topY = leftTopXYPixel.getY();
        double bottomY = rightBottomXYPixel.getY();
        Point collectorTileLeftTopXYPixel = tileOutputter.getLonLatToPixel(this.getLatLonBBox().getLeft(), this.getLatLonBBox().getTop(), zoom);
        double collectorTileXLeft = collectorTileLeftTopXYPixel.getX();
        double collectorTileYTop = collectorTileLeftTopXYPixel.getY();
        double topPixel = topY - collectorTileYTop;
        double bottomPixel = bottomY - collectorTileYTop;
        double leftPixel = leftX - collectorTileXLeft;
        double rightPixel = rightX - collectorTileXLeft;
        int oversizing = 0;
        int leftCellIndexWithoutBorders = leftCellIndex = (int)Math.floor(leftPixel) - oversizing;
        if (leftCellIndex < -50) {
            leftCellIndex = -50;
        }
        int rightCellIndexWithoutBorders = rightCellIndex = (int)Math.floor(rightPixel) + oversizing;
        if (rightCellIndex == leftCellIndex) {
            rightCellIndex = leftCellIndex + 1;
        }
        if (rightCellIndex < -50) {
            rightCellIndex = -50;
        }
        if (rightCellIndex > this.pixelTileSize + 50) {
            rightCellIndex = this.pixelTileSize + 50;
        }
        int topCellIndexWithoutBorders = topCellIndex = (int)Math.floor(topPixel) - oversizing;
        if (topCellIndex < -50) {
            topCellIndex = -50;
        }
        int bottomCellIndexWithoutBorders = bottomCellIndex = (int)Math.floor(bottomPixel) + oversizing;
        if (bottomCellIndex == topCellIndex) {
            bottomCellIndex = topCellIndex + 1;
        }
        if (bottomCellIndex < -50) {
            bottomCellIndex = -50;
        }
        if (bottomCellIndex > this.pixelTileSize + 50) {
            bottomCellIndex = this.pixelTileSize + 50;
        }
        int cellPixelsWidth = Math.abs(rightCellIndexWithoutBorders - leftCellIndexWithoutBorders);
        int cellPixelsHeight = Math.abs(topCellIndexWithoutBorders - bottomCellIndexWithoutBorders);
        int currentCellSizeX = rightCellIndex - leftCellIndex;
        this.subTileSizeX = Math.max(this.subTileSizeX, currentCellSizeX);
        this.subTileSizeX = Math.max(this.subTileSizeX, 1);
        int currentCellSizeY = bottomCellIndex - topCellIndex;
        this.subTileSizeY = Math.max(this.subTileSizeY, currentCellSizeY);
        this.subTileSizeY = Math.max(this.subTileSizeY, 1);
        for (int yPixelCell = topCellIndex; yPixelCell < bottomCellIndex; ++yPixelCell) {
            for (int xPixelCell = leftCellIndex; xPixelCell < rightCellIndex; ++xPixelCell) {
                float newValue;
                float newValue2;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                float cellPositionX = xPixelCell - leftCellIndexWithoutBorders;
                float cellPositionY = yPixelCell - topCellIndexWithoutBorders;
                int xWithBorder = xPixelCell + 50;
                int yWithBorder = yPixelCell + 50;
                int leftSmoothIndex = xWithBorder - this.subTileSizeX / 2 - 1;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = xWithBorder + this.subTileSizeX / 2 + 1) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex > this.bufferedTileSize) {
                    rightSmoothIndex = this.bufferedTileSize;
                }
                if ((topSmoothIndex = yWithBorder - this.subTileSizeY / 2 - 1) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = yWithBorder + this.subTileSizeY / 2 + 1) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex > this.bufferedTileSize) {
                    bottomSmoothIndex = this.bufferedTileSize;
                }
                float[] surroundingHeights = surroundingCellHeights;
                float halfCellWidth = (float)cellPixelsWidth / 2.0f;
                float halfCellHeight = (float)cellPixelsHeight / 2.0f;
                float ratioX = 1.0f;
                ratioX = cellPositionX < halfCellWidth ? 0.5f + 0.5f * (cellPositionX / halfCellWidth) : 0.5f + 0.5f * (((float)cellPixelsWidth - cellPositionX) / halfCellWidth);
                float ratioY = 1.0f;
                ratioY = cellPositionY < halfCellHeight ? 0.5f + 0.5f * (cellPositionY / halfCellHeight) : 0.5f + 0.5f * (((float)cellPixelsHeight - cellPositionY) / halfCellHeight);
                if (cellPositionX == halfCellWidth && cellPositionY == halfCellHeight) {
                    newValue2 = surroundingHeights[4];
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                if (cellPositionX == halfCellWidth) {
                    if (cellPositionY < halfCellHeight) {
                        newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[1] * (1.0f - ratioY);
                        this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                        this.minValue = Math.min(this.minValue, newValue2);
                        this.maxValue = Math.max(this.maxValue, newValue2);
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioY + surroundingHeights[7] * (1.0f - ratioY);
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                if (cellPositionY == halfCellHeight) {
                    if (cellPositionX < halfCellWidth) {
                        newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[3] * (1.0f - ratioX);
                        this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                        this.minValue = Math.min(this.minValue, newValue2);
                        this.maxValue = Math.max(this.maxValue, newValue2);
                        continue;
                    }
                    newValue2 = surroundingHeights[4] * ratioX + surroundingHeights[5] * (1.0f - ratioX);
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue2);
                    this.minValue = Math.min(this.minValue, newValue2);
                    this.maxValue = Math.max(this.maxValue, newValue2);
                    continue;
                }
                float ratioC = ratioX * ratioY;
                float ratioN = (1.0f - ratioY) * ratioX;
                float ratioE = (1.0f - ratioX) * ratioY;
                float ratioS = (1.0f - ratioY) * ratioX;
                float ratioW = (1.0f - ratioX) * ratioY;
                float ratioNE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSE = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioSW = (1.0f - ratioX) * (1.0f - ratioY);
                float ratioNW = (1.0f - ratioX) * (1.0f - ratioY);
                float partC = surroundingHeights[4] * ratioC;
                float partN = surroundingHeights[1] * ratioN;
                float partE = surroundingHeights[5] * ratioE;
                float partS = surroundingHeights[7] * ratioS;
                float partW = surroundingHeights[3] * ratioW;
                float partNE = surroundingHeights[2] * ratioNE;
                float partSE = surroundingHeights[8] * ratioSE;
                float partSW = surroundingHeights[6] * ratioSW;
                float partNW = surroundingHeights[0] * ratioNW;
                if (cellPositionY < halfCellHeight && cellPositionX < halfCellWidth) {
                    newValue = partC + partN + partW + partNW;
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (cellPositionY < halfCellHeight && cellPositionX > halfCellWidth) {
                    newValue = partC + partN + partE + partNE;
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (cellPositionY > halfCellHeight && cellPositionX > halfCellWidth) {
                    newValue = partC + partS + partE + partSE;
                    this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                    this.minValue = Math.min(this.minValue, newValue);
                    this.maxValue = Math.max(this.maxValue, newValue);
                    continue;
                }
                if (!(cellPositionY > halfCellHeight) || !(cellPositionX < halfCellWidth)) continue;
                newValue = partC + partS + partW + partSW;
                this.multipleValueBuffer.addValue(xPixelCell + 50, yPixelCell + 50, newValue);
                this.minValue = Math.min(this.minValue, newValue);
                this.maxValue = Math.max(this.maxValue, newValue);
            }
        }
    }

    public float getValue(int xPixel, int yPixel) {
        return this.multipleValueBuffer.getAveragedValue(xPixel + 50, yPixel + 50);
    }

    public float getMaxValue(int xPixel, int yPixel) {
        return this.multipleValueBuffer.getMaxValue(xPixel + 50, yPixel + 50);
    }

    public void setValue(int xPixel, int yPixel, float value) {
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 0, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 3, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 2, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 4, value);
        this.multipleValueBuffer.setValue(xPixel + 50, yPixel + 50, 1, 1.0f);
    }

    public float getValueFromBuffer(int xPixel, int yPixel) {
        return this.multipleValueBuffer.getAveragedValue(xPixel, yPixel);
    }

    public void setValueToBuffer(int xPixel, int yPixel, float value) {
        this.multipleValueBuffer.setValue(xPixel, yPixel, 0, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 3, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 2, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 4, value);
        this.multipleValueBuffer.setValue(xPixel, yPixel, 1, 1.0f);
    }

    public boolean isInCollectorBounds(Line line) {
        Point start = line.getStart();
        Point stop = line.getStop();
        return start.getX() > -50.0 && start.getX() < (double)(this.bufferedTileSize - 50) && start.getY() > -50.0 && start.getY() < (double)(this.bufferedTileSize - 50) && stop.getX() > -50.0 && stop.getX() < (double)(this.bufferedTileSize - 50) && stop.getY() > -50.0 && stop.getY() < (double)(this.bufferedTileSize - 50);
    }

    public HeightCollectorTile_Old blur(int blurRadius) {
        MultiValueCollectorBuffer newMultipleValueBuffer = new MultiValueCollectorBuffer(this.bufferedTileSize, this.bufferedTileSize);
        for (int y = 0; y < this.bufferedTileSize; ++y) {
            for (int x = 0; x < this.bufferedTileSize; ++x) {
                float smoothedValue;
                int bottomSmoothIndex;
                int topSmoothIndex;
                int rightSmoothIndex;
                int leftSmoothIndex = x - blurRadius;
                if (leftSmoothIndex < 0) {
                    leftSmoothIndex = 0;
                }
                if ((rightSmoothIndex = x + blurRadius) == leftSmoothIndex) {
                    rightSmoothIndex = leftSmoothIndex + 1;
                }
                if (rightSmoothIndex >= this.bufferedTileSize) {
                    rightSmoothIndex = this.bufferedTileSize - 1;
                }
                if ((topSmoothIndex = y - blurRadius) < 0) {
                    topSmoothIndex = 0;
                }
                if ((bottomSmoothIndex = y + blurRadius) == topSmoothIndex) {
                    bottomSmoothIndex = topSmoothIndex + 1;
                }
                if (bottomSmoothIndex >= this.bufferedTileSize) {
                    bottomSmoothIndex = this.bufferedTileSize - 1;
                }
                int sampleSizeX = 1;
                int sampleSizeY = 1;
                float totalValues = 0.0f;
                float counter = 0.0f;
                for (int i = leftSmoothIndex; i < rightSmoothIndex; i += sampleSizeX) {
                    for (int j = topSmoothIndex; j < bottomSmoothIndex; j += sampleSizeY) {
                        totalValues += this.multipleValueBuffer.getAveragedValue(i, j);
                        counter += 1.0f;
                    }
                }
                if (counter != 0.0f) {
                    smoothedValue = totalValues / counter;
                    newMultipleValueBuffer.addValue(x, y, smoothedValue);
                    continue;
                }
                smoothedValue = this.multipleValueBuffer.getAveragedValue(x, y);
                newMultipleValueBuffer.addValue(x, y, smoothedValue);
            }
        }
        this.multipleValueBuffer = newMultipleValueBuffer;
        return this;
    }

    public void logBuffer() {
        this.logBuffer(0, 0, this.multipleValueBuffer.getXSize(), 0, this.multipleValueBuffer.getYSize());
    }

    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer HeightCollectTile");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.multipleValueBuffer.getValue(x, y, z);
                String lengthFilledValue = String.format("%.5f", Float.valueOf(value));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }

    public void logBufferAveraged() {
        this.logBufferAveraged(0, this.multipleValueBuffer.getXSize(), 0, this.multipleValueBuffer.getYSize());
    }

    public void logBufferAveraged(int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer HeightCollectTile");
        StringBuffer rowBuffy = new StringBuffer();
        for (int x = xMin; x < xMax; ++x) {
            String column = String.format("%10s", "" + x);
            rowBuffy.append(column);
            rowBuffy.append(", ");
        }
        System.out.println("#########################  : " + rowBuffy.toString());
        for (int y = yMin; y < yMax; ++y) {
            rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                float value = this.multipleValueBuffer.getAveragedValue(x, y);
                String lengthFilledValue = String.format("%10s", String.format("%.5f", Float.valueOf(value)));
                rowBuffy.append(lengthFilledValue);
                rowBuffy.append(", ");
            }
            System.out.println("######################### " + y + ": " + rowBuffy.toString());
        }
    }
}

