/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.file;

import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.request.RenderImage;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileAccessor;
import de.wideportal.maprender.resources.output.IRenderOutputPersister;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesAsImagePersister
extends FileAccessor
implements IRenderOutputPersister {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static LinkedHashMap<Integer, BufferedImage> bigImagesForZoom = new LinkedHashMap();

    @Override
    public synchronized void persistTile(RenderRequest renderRequestToSave) {
        String baseFolder = renderRequestToSave.getOsmMap().getJob().getOutput().getImage().getFolder();
        int zoom = (int)renderRequestToSave.getZoomInfo().getZoom();
        RenderConfigurationJob currentJob = renderRequestToSave.getOsmMap().getJob();
        String configuredImageType = currentJob.getOutput().getImageType();
        String configuredImageQuality = currentJob.getOutput().getQuality();
        String fileType = "png";
        if (configuredImageType != null) {
            fileType = configuredImageType;
        }
        float quality = 100.0f;
        if (configuredImageQuality != null) {
            try {
                quality = Integer.parseInt(configuredImageQuality);
            }
            catch (NumberFormatException e) {
                this.log.error("persistTile: could not parse the image file quality setting from the output configuration: " + configuredImageQuality + ". Using default: " + quality);
            }
        }
        Optional<File> optionalZoomLevelFile = this.getFile(baseFolder, zoom, fileType, true);
        File zoomLevelFile = null;
        if (optionalZoomLevelFile.isPresent()) {
            zoomLevelFile = optionalZoomLevelFile.get();
        } else {
            this.log.error("persistTile: file is not accessible. Cannot save tile. Base folder is: " + baseFolder);
        }
        if (zoomLevelFile.exists()) {
            zoomLevelFile.delete();
            this.log.debug("persistTile: deleted old file: " + zoomLevelFile.getAbsolutePath());
        }
        AbstractMapTileOutput tileOutputter = renderRequestToSave.getTileOutputter();
        BoundingBox zoomBounds = new BoundingBox(renderRequestToSave.getRenderConfiguration().getMaprenderConfiguration().getBounds().getBoundingbox());
        BoundingBox minMaxTileIndexBoundingBox = tileOutputter.getMinMaxTileBoundingBox(zoomBounds, zoom);
        int tileIndexLeft = (int)minMaxTileIndexBoundingBox.getLeft();
        int tileIndexRight = (int)minMaxTileIndexBoundingBox.getRight();
        int tileIndexTop = (int)minMaxTileIndexBoundingBox.getTop();
        int tileIndexBottom = (int)minMaxTileIndexBoundingBox.getBottom();
        BufferedImage bigImage = null;
        if (bigImagesForZoom.containsKey(zoom)) {
            bigImage = bigImagesForZoom.get(zoom);
        } else if (zoomLevelFile.exists()) {
            try {
                bigImage = ImageIO.read(zoomLevelFile);
                bigImagesForZoom.put(zoom, bigImage);
            }
            catch (IOException e) {
                this.log.error("persistTile: could not read the bigimage file: " + zoomLevelFile.getAbsolutePath(), (Throwable)e);
                return;
            }
        } else {
            int tileCountWidth = tileIndexRight - tileIndexLeft + 1;
            int tileCountHeight = tileIndexBottom - tileIndexTop + 1;
            int pixelWidth = tileCountWidth * tileOutputter.getTileSize();
            int pixelHeight = tileCountHeight * tileOutputter.getTileSize();
            bigImage = new BufferedImage(pixelWidth, pixelHeight, 2);
            bigImagesForZoom.put(zoom, bigImage);
        }
        RenderImage renderImage = renderRequestToSave.getRenderImage();
        renderImage.mergeLayers();
        BufferedImage tileImage = renderImage.getBaseLayer().getImage();
        this.copyIntoBigImage(bigImage, tileImage, renderRequestToSave, tileIndexLeft, tileIndexTop);
        try {
            if ("png".equalsIgnoreCase(fileType)) {
                ImageIO.write((RenderedImage)bigImage, "png", zoomLevelFile);
            } else if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType)) {
                BufferedImage alphaLessImage = this.removeAlphaChannel(bigImage);
                JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality(quality / 100.0f);
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                FileImageOutputStream fos = new FileImageOutputStream(zoomLevelFile);
                writer.setOutput(fos);
                writer.write(null, new IIOImage(alphaLessImage, null, null), jpegParams);
                fos.close();
            } else if ("bmp".equalsIgnoreCase(fileType)) {
                BufferedImage alphaLessImage = this.removeAlphaChannel(bigImage);
                ImageIO.write((RenderedImage)alphaLessImage, "bmp", zoomLevelFile);
            }
            this.log.debug("persistTile: saved tile file: " + zoomLevelFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.error("persistTile: could not write tile file: " + zoomLevelFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void copyIntoBigImage(BufferedImage bigImage, BufferedImage tileImage, RenderRequest renderRequestToSave, int tileIndexLeft, int tileIndexTop) {
        Point tileIndex = renderRequestToSave.getTileIndex();
        int tilePaddingX = (int)tileIndex.getX() - tileIndexLeft;
        int tilePaddingY = (int)tileIndex.getY() - tileIndexTop;
        int pixelPaddingX = tilePaddingX * renderRequestToSave.getTileOutputter().getTileSize();
        int pixelPaddingY = tilePaddingY * renderRequestToSave.getTileOutputter().getTileSize();
        Graphics2D canvas = bigImage.createGraphics();
        canvas.drawImage((Image)tileImage, pixelPaddingX, pixelPaddingY, null);
        canvas.dispose();
    }

    private BufferedImage removeAlphaChannel(BufferedImage alphaImage) {
        BufferedImage copy = new BufferedImage(alphaImage.getWidth(), alphaImage.getHeight(), 1);
        Graphics2D g2d = copy.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, copy.getWidth(), copy.getHeight());
        g2d.drawImage((Image)alphaImage, 0, 0, null);
        g2d.dispose();
        return copy;
    }
}

