/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources;

import de.wideportal.maprender.config.xml.RenderConfiguration;
import de.wideportal.maprender.config.xml.RenderConfigurationDataTargets;
import de.wideportal.maprender.config.xml.RenderConfigurationDatasources;
import de.wideportal.maprender.config.xml.RenderConfigurationFtp;
import de.wideportal.maprender.config.xml.RenderConfigurationSqlitedb;
import de.wideportal.maprender.datasource.osm.PostgresCache;
import de.wideportal.maprender.resources.AbstractConnectableResource;
import de.wideportal.maprender.resources.ftp.FtpConnector;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbConnector;
import java.util.ArrayList;

public class ConnectableResourceManager {
    private ArrayList<AbstractConnectableResource> connectableResources = new ArrayList();

    public void registerConnectableResources(RenderConfiguration configuration) {
        RenderConfigurationDatasources datasources;
        SqLiteDbConnector sqlitedbConnector;
        RenderConfigurationSqlitedb sqlitedbConfig;
        PostgresCache postgresEhCache = new PostgresCache();
        this.connectableResources.add(postgresEhCache);
        RenderConfigurationDataTargets dataTargets = configuration.getMaprenderConfiguration().getDatatargets();
        if (dataTargets != null) {
            RenderConfigurationFtp ftpConfig = dataTargets.getFtp();
            if (ftpConfig != null) {
                FtpConnector ftpConnector = new FtpConnector(configuration);
                this.connectableResources.add(ftpConnector);
            }
            if ((sqlitedbConfig = dataTargets.getSqLiteDb()) != null) {
                sqlitedbConnector = new SqLiteDbConnector(configuration);
                this.connectableResources.add(sqlitedbConnector);
            }
        }
        if ((datasources = configuration.getMaprenderConfiguration().getDatasources()) != null && (sqlitedbConfig = datasources.getSqLiteDb()) != null) {
            sqlitedbConnector = new SqLiteDbConnector(configuration);
            this.connectableResources.add(sqlitedbConnector);
        }
    }

    public void connectAllConnectableResources() throws Exception {
        for (AbstractConnectableResource connector : this.connectableResources) {
            connector.connect();
        }
    }

    public void disconnectAllConnectableResources() {
        for (AbstractConnectableResource connector : this.connectableResources) {
            connector.disconnect();
        }
    }

    public AbstractConnectableResource getConnectableResource(Class<? extends AbstractConnectableResource> connectorClass) {
        String typeName = connectorClass.getTypeName();
        for (AbstractConnectableResource connector : this.connectableResources) {
            String currentTypeName = connector.getClass().getTypeName();
            if (!currentTypeName.equals(typeName)) continue;
            return connector;
        }
        return null;
    }
}

