/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import de.wideportal.maprender.renderer.progress.RenderProgressTracking;
import de.wideportal.maprender.request.RenderRequestAllJobsProgress;
import de.wideportal.maprender.request.RenderRequestZoomLevelProgress;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderRequestJobProgress {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private RenderRequestAllJobsProgress progressMonitor;
    private long tilesCount = 0L;
    private long tilesDone = 0L;
    private long tilesFailed = 0L;
    private long tilesDoneAtStart = 0L;
    private String jobName;
    private boolean skipJob;
    private ArrayList<RenderRequestZoomLevelProgress> zoomLevelProgresses = new ArrayList();
    private Optional<RenderProgressTracking> renderProgressTracking = Optional.empty();

    public RenderRequestJobProgress(String jobName, boolean skipJob, RenderRequestAllJobsProgress progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.jobName = jobName;
        this.skipJob = skipJob;
    }

    public long getTilesCount() {
        return this.tilesCount;
    }

    public void setTilesCount(long tilesCount) {
        this.tilesCount = tilesCount;
    }

    public long getTilesDone() {
        return this.tilesDone;
    }

    public void setTilesDone(long tilesDone) {
        this.tilesDone = tilesDone;
    }

    public long getTilesFailed() {
        return this.tilesFailed;
    }

    public void setTilesFailed(long tilesFailed) {
        this.tilesFailed = tilesFailed;
    }

    public long getTilesDoneAtStart() {
        return this.tilesDoneAtStart;
    }

    public void setTilesDoneAtStart(long tilesDoneAtStart) {
        this.tilesDoneAtStart = tilesDoneAtStart;
    }

    public boolean isDone() {
        return this.tilesCount <= this.tilesDone;
    }

    public ArrayList<RenderRequestZoomLevelProgress> getZoomLevelProgresses() {
        return this.zoomLevelProgresses;
    }

    public RenderRequestZoomLevelProgress getZoomLevelProgress(double zoom) {
        for (RenderRequestZoomLevelProgress zoomProgress : this.zoomLevelProgresses) {
            if ((double)zoomProgress.getZoom() != zoom) continue;
            return zoomProgress;
        }
        return null;
    }

    public void addZoomLevel(int zoomLevel, long totalTilesCountOfZoomLevel, long totalTilesDoneOfZoomLevel) {
        RenderRequestZoomLevelProgress zoomLevelProgress = new RenderRequestZoomLevelProgress(zoomLevel, totalTilesCountOfZoomLevel);
        zoomLevelProgress.addTilesDone(totalTilesDoneOfZoomLevel);
        zoomLevelProgress.setTilesDoneAtStart(totalTilesDoneOfZoomLevel);
        this.zoomLevelProgresses.add(zoomLevelProgress);
    }

    public synchronized void addTileDone(long zoom) {
        ++this.tilesDone;
        for (RenderRequestZoomLevelProgress zoomLevelProgress : this.zoomLevelProgresses) {
            if ((long)zoomLevelProgress.getZoom() != zoom) continue;
            zoomLevelProgress.addTileDone();
            break;
        }
        this.checkIfAllTilesOfJobDone();
    }

    public synchronized void addTileFailed(long zoom) {
        ++this.tilesFailed;
        for (RenderRequestZoomLevelProgress zoomLevelProgress : this.zoomLevelProgresses) {
            if ((long)zoomLevelProgress.getZoom() != zoom) continue;
            zoomLevelProgress.addTileFailed();
            break;
        }
        this.checkIfAllTilesOfJobDone();
    }

    public synchronized void addTilesDone(long zoom, long tilesCount) {
        this.tilesDone += tilesCount;
        for (RenderRequestZoomLevelProgress zoomLevelProgress : this.zoomLevelProgresses) {
            if ((long)zoomLevelProgress.getZoom() != zoom) continue;
            zoomLevelProgress.addTilesDone(tilesCount);
            break;
        }
        this.checkIfAllTilesOfJobDone();
    }

    public synchronized void addTilesFailed(long zoom, long tilesFailed) {
        this.tilesFailed += tilesFailed;
        for (RenderRequestZoomLevelProgress zoomLevelProgress : this.zoomLevelProgresses) {
            if ((long)zoomLevelProgress.getZoom() != zoom) continue;
            zoomLevelProgress.addTilesFailed(tilesFailed);
            break;
        }
        this.checkIfAllTilesOfJobDone();
    }

    private void checkIfAllTilesOfJobDone() {
        if (this.tilesDone == this.tilesCount && this.renderProgressTracking.isPresent()) {
            this.log.info("checkIfAllTilesOfJobDone: closing sqlite db connection for render process tracking");
            this.renderProgressTracking.get().stopTracking();
        }
    }

    public RenderRequestAllJobsProgress getProgressMonitor() {
        return this.progressMonitor;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public boolean isSkipJob() {
        return this.skipJob;
    }

    public void setSkipJob(boolean skipJob) {
        this.skipJob = skipJob;
    }

    public void setRenderProgressTracking(RenderProgressTracking renderProgressTracking) {
        this.renderProgressTracking = Optional.of(renderProgressTracking);
    }

    public String toString() {
        return "RenderRequestJobProgress[jobName=" + this.jobName + ", skipJob=" + this.skipJob + ", tilesCount=" + this.tilesCount + ", tilesDone=" + this.tilesDone + ", tilesDoneAtStart=" + this.tilesDoneAtStart + "]";
    }
}

