/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.text;

import de.wideportal.maprender.resources.fonts.FontContext;
import de.wideportal.maprender.resources.fonts.FontsUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextRowEntry {
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_FORMAT = 1;
    private int type;
    private String text;
    private int stringWidth = -1;
    private int stringHeight = -1;
    private int maxDescent = -1;

    public TextRowEntry(int type, String text) {
        this.text = text;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getFullText() {
        return this.text;
    }

    public String getParsedText(String wrapCharacter) {
        return this.text.replaceAll(wrapCharacter, " ");
    }

    public int getFaceStyle() {
        if (this.type == 1) {
            if ("<b>".equals(this.text)) {
                return 1;
            }
            if ("<i>".equals(this.text)) {
                return 2;
            }
            return 0;
        }
        return -1;
    }

    public void calculateStringDimension(FontContext fontContext, Graphics dummyCanvas) {
        if (this.type == 0) {
            int length = 0;
            int height = 0;
            int maxDescent = 0;
            for (int i = 0; i < this.text.length(); ++i) {
                String letter = String.valueOf(this.text.charAt(i));
                Font font = FontsUtil.getBestFittingFont(fontContext, letter);
                dummyCanvas.setFont(font);
                FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
                length += fontMetrics.stringWidth(letter);
                height = Math.max(height, fontMetrics.getHeight());
                maxDescent = Math.max(maxDescent, fontMetrics.getMaxDescent());
            }
            this.stringWidth = length;
            this.stringHeight = height;
            this.maxDescent = maxDescent;
        } else {
            this.stringWidth = 0;
            this.stringHeight = 0;
            this.maxDescent = 0;
        }
    }

    public int getStringWidth() {
        return this.stringWidth;
    }

    public int getStringHeight() {
        return this.stringHeight;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int getLongestUnbreakableTextPart(FontContext fontContext, Graphics dummyCanvas, String wrapCharacter) {
        int longestUnbreakableWord = 0;
        if (this.type == 0) {
            String[] words;
            for (String word : words = this.text.split(wrapCharacter)) {
                Font font = FontsUtil.getBestFittingFont(fontContext, word);
                dummyCanvas.setFont(font);
                FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
                longestUnbreakableWord = Math.max(longestUnbreakableWord, fontMetrics.stringWidth(word));
            }
        }
        return longestUnbreakableWord;
    }

    public String toString() {
        return "TextRowEntry[type=" + (this.type == 1 ? "TYPE_FORMAT" : "TYPE_TEXT") + ", text='" + this.text + "']";
    }
}

