/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.buffer;

import de.wideportal.maprender.renderer.buffer.AbstractArrayBuffer;

public class BooleanArrayBuffer
extends AbstractArrayBuffer {
    private boolean[][][] buffer;
    private boolean[] hasTrueValuesInZ;

    public BooleanArrayBuffer(int xSize, int ySize, int zSize) {
        this.buffer = new boolean[ySize][xSize][zSize];
        this.hasTrueValuesInZ = new boolean[zSize];
    }

    public boolean getValue(int x, int y, int z) {
        return this.buffer[y][x][z];
    }

    public void setValue(int x, int y, int z, boolean value) {
        this.buffer[y][x][z] = value;
        if (value) {
            this.setHasTrueValuesInZ(z);
        }
    }

    public void setValues(int x, int y, boolean[] values) {
        this.buffer[y][x] = values;
        for (int z = 0; z < values.length; ++z) {
            if (!values[z]) continue;
            this.setHasTrueValuesInZ(z);
        }
    }

    public boolean hasTrueValuesInZ(int z) {
        return this.hasTrueValuesInZ[z];
    }

    public void setHasTrueValuesInZ(int z) {
        this.hasTrueValuesInZ[z] = true;
    }

    public void releaseResources() {
        this.buffer = null;
    }

    @Override
    public int getXSize() {
        return this.buffer[0].length;
    }

    @Override
    public int getYSize() {
        return this.buffer.length;
    }

    @Override
    public int getZSize() {
        return this.buffer[0][0].length;
    }

    public void logTrueValues(int filterZ) {
        for (int y = 0; y < this.buffer.length; ++y) {
            for (int x = 0; x < this.buffer[y].length; ++x) {
                for (int z = 0; z < this.buffer[y][x].length; ++z) {
                    if (z != filterZ || !this.buffer[y][x][z]) continue;
                    System.out.println("############################# buffer==true: x=" + x + ", y=" + y + ", z=" + z);
                }
            }
        }
    }

    public void logBuffer() {
        this.logBuffer(-1, 0, this.buffer.length, 0, this.buffer.length);
    }

    @Override
    public void logBuffer(int z, int xMin, int xMax, int yMin, int yMax) {
        System.out.println("################################################# logBuffer BooleanArrayBuffer");
        Object zHasValues = "";
        for (int i = 0; i < this.hasTrueValuesInZ.length; ++i) {
            zHasValues = (String)zHasValues + this.hasTrueValuesInZ[i] + ",";
        }
        System.out.println("######################### hasZValues: " + (String)zHasValues);
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                boolean value = false;
                if (z == -1) {
                    for (int zb = 0; zb < this.buffer[y][x].length; ++zb) {
                        value = value || this.buffer[y][x][zb];
                    }
                } else {
                    value = this.buffer[y][x][z];
                }
                String lengthFilledValue = value ? "x" : " ";
                rowBuffy.append(lengthFilledValue);
            }
            String yIndex = String.format("%4s", "" + y);
            System.out.println("######################### " + yIndex + ": " + rowBuffy.toString());
        }
    }
}

