/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmTextSymbolizerAccessor;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Circle;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmTextPointRenderHints;
import de.wideportal.maprender.renderer.blocking.RenderOverlapManager;
import de.wideportal.maprender.renderer.blocking.RenderSrtmTextItem;
import de.wideportal.maprender.renderer.blocking.RenderTextItem;
import de.wideportal.maprender.renderer.blocking.RenderTextLineItem;
import de.wideportal.maprender.renderer.text.TextRow;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import de.wideportal.maprender.renderer.text.TextRowEntry;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.fonts.FontContext;
import de.wideportal.maprender.resources.fonts.FontsUtil;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTextSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderTextSymbolizer(OsmTextSymbolizerAccessor textSymbolizer, RenderImageLayer renderLayer, Point xyTilePixel, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        Graphics2D canvas = renderLayer.getCanvas();
        Graphics dummyCanvas = canvas.create();
        FontContext fontContext = new FontContext(renderRequest, textSymbolizer);
        int minimumLineLength = 4;
        String textValue = this.extractText(textSymbolizer.getValue(), resultSetCache);
        if (textValue != null && !textValue.isBlank()) {
            boolean forgetPlacement = textSymbolizer.getAllowOverlap();
            Color colorHalo = textSymbolizer.getHaloFill();
            Color color = textSymbolizer.getFill();
            Optional<BasicStroke> textHaloStroke = this.getTextHaloStroke(textSymbolizer.getHaloRadius().floatValue());
            if (textHaloStroke.isPresent()) {
                canvas.setStroke(textHaloStroke.get());
            }
            OsmTextPointRenderHints textPointRenderHints = new OsmTextPointRenderHints(textSymbolizer);
            TextRowContainer textRows = textPointRenderHints.getTextRowContainer(textValue, fontContext, dummyCanvas, minimumLineLength);
            BoundingBox textBBox = textPointRenderHints.getTextBoundingBox(xyTilePixel, textRows, null, fontContext, dummyCanvas);
            RenderTextItem renderTextItem = new RenderTextItem(textBBox, xyTilePixel, textRows, zoom, renderRequest.getTileIndex(), textRows, textSymbolizer.toString());
            RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
            if (allOverlapManager.hasOverlappingItems(renderTextItem, true, true, true, true)) {
                return;
            }
            if (!forgetPlacement) {
                allOverlapManager.addRenderTextItem(renderTextItem);
            }
            int fontType = textSymbolizer.getFaceStyle();
            for (int i = 0; i < textRows.getTextRows().size(); ++i) {
                int letterWidth;
                Shape textShape;
                float getDescend;
                GlyphVector glyphVector;
                FontMetrics fontMetrics;
                Font font;
                FontContext dummyFontContext;
                String currentLetter;
                int t;
                String entryText;
                TextRowEntry entry;
                int k;
                double leftX;
                TextRow textRow = textRows.getTextRows().get(i);
                BoundingBox rowBBox = textPointRenderHints.getTextRowBoundingBox(textRow, i, textBBox);
                if (textHaloStroke.isPresent()) {
                    canvas.setColor(colorHalo);
                    leftX = rowBBox.getLeft();
                    for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                        entry = textRow.getTextRowEntries().get(k);
                        if (entry.getType() == 1) {
                            fontType = entry.getFaceStyle();
                            continue;
                        }
                        entryText = entry.getParsedText(textRow.getWrapCharacter());
                        for (t = 0; t < entryText.length(); ++t) {
                            currentLetter = "" + entryText.charAt(t);
                            dummyFontContext = fontContext.clone();
                            dummyFontContext.setFaceStyle(fontType);
                            font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                            canvas.setFont(font);
                            fontMetrics = canvas.getFontMetrics();
                            glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                            getDescend = fontMetrics.getMaxDescent();
                            textShape = glyphVector.getOutline((float)leftX, (float)rowBBox.getBottom() - getDescend);
                            canvas.draw(textShape);
                            letterWidth = fontMetrics.stringWidth(currentLetter);
                            leftX += (double)letterWidth;
                        }
                    }
                }
                canvas.setColor(color);
                leftX = rowBBox.getLeft();
                for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                    entry = textRow.getTextRowEntries().get(k);
                    if (entry.getType() == 1) {
                        fontType = entry.getFaceStyle();
                        continue;
                    }
                    entryText = entry.getParsedText(textRow.getWrapCharacter());
                    for (t = 0; t < entryText.length(); ++t) {
                        currentLetter = "" + entryText.charAt(t);
                        dummyFontContext = fontContext.clone();
                        dummyFontContext.setFaceStyle(fontType);
                        font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                        canvas.setFont(font);
                        fontMetrics = canvas.getFontMetrics();
                        glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                        getDescend = fontMetrics.getMaxDescent();
                        textShape = glyphVector.getOutline((float)leftX, (float)rowBBox.getBottom() - getDescend);
                        canvas.fill(textShape);
                        letterWidth = fontMetrics.stringWidth(currentLetter);
                        leftX += (double)letterWidth;
                    }
                }
            }
        }
        dummyCanvas.dispose();
    }

    public void renderTextSymbolizer(OsmTextSymbolizerAccessor textSymbolizer, RenderImageLayer renderLayer, PostgresPolygon mercatorPolygon, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        boolean isisPolygonLineInBoundingBox = this.isPolygonLineInBoundingBox(renderRequest.getBoundingBoxMercator(), mercatorPolygon);
        if (!isisPolygonLineInBoundingBox) {
            return;
        }
        PostgresPolygonElement basePolygon = mercatorPolygon.getPolygonElements()[0];
        PostgresLineString mercatorLineString = basePolygon.getAsLineString();
        this.renderTextSymbolizer(textSymbolizer, renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule);
    }

    public void renderTextSymbolizer(OsmTextSymbolizerAccessor textSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        boolean isLineStringInBoundingBox = this.isLineStringInBoundingBox(renderRequest.getBoundingBoxMercator(), mercatorLineString);
        if (!isLineStringInBoundingBox) {
            return;
        }
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        double maxSingleCharRotation = 20.0;
        boolean isSrtmText = false;
        this.renderTextSymbolizer(textSymbolizer, renderLayer, xyTilePoints, xOffset, yOffset, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule, maxSingleCharRotation, isSrtmText);
    }

    public void renderTextSymbolizer(OsmTextSymbolizerAccessor textSymbolizer, RenderImageLayer renderLayer, Point[] xyTilePoints, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule, double maxSingleCharRotation, boolean isHeightText) {
        Graphics2D canvas = renderLayer.getCanvas();
        FontContext fontContext = new FontContext(renderRequest, textSymbolizer);
        String textValue = null;
        textValue = isHeightText ? textSymbolizer.getValue().get() : this.extractText(textSymbolizer.getValue(), resultSetCache);
        if (textValue != null && !textValue.isBlank()) {
            double repeatDistance = textSymbolizer.getRepeatDistance();
            double spacing = textSymbolizer.getSpacing();
            float haloRadius = textSymbolizer.getHaloRadius().floatValue();
            Color colorHalo = textSymbolizer.getHaloFill();
            double dy = textSymbolizer.getDy();
            double zoomScaleMultiplicator = this.getZoomScaleMultiplicatorTextLine(zoom);
            double pixelSpacing = spacing * zoomScaleMultiplicator;
            double pixelRepeating = repeatDistance;
            Optional<BasicStroke> textHaloStroke = this.getTextHaloStroke(haloRadius);
            Color color = textSymbolizer.getFill();
            Font font = FontsUtil.getBestFittingFont(fontContext, textValue);
            double borderDistance = textSymbolizer.getBorderDistance();
            boolean skipTextDirectionAdjustment = textSymbolizer.getSkipTextDirectionAdjustment();
            Graphics dummyCanvas = canvas.create();
            TextRowContainer textRowContainer = TextRowContainer.parse(textValue, textSymbolizer, fontContext, dummyCanvas, 0);
            textRowContainer.mergeToSingleLine(fontContext, dummyCanvas);
            dummyCanvas.dispose();
            double textLength = textRowContainer.getMaxRowWidth();
            if (borderDistance == 0.0) {
                borderDistance = font.getSize();
            }
            canvas.setFont(font);
            RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
            BoundingBox clipBBox = renderRequest.getBoundingBoxPixel();
            clipBBox.increaseBBox(tileOutputter.getTileSize());
            LineSequence baseLineSequence = new LineSequence(xyTilePoints);
            LineSequence lineSequence = baseLineSequence.shiftLines(dy, false);
            double lineLength = lineSequence.getLength();
            double initialCenterTextOffset = lineLength / 2.0 - textLength / 2.0;
            if (initialCenterTextOffset < 0.0 || initialCenterTextOffset >= lineLength) {
                initialCenterTextOffset = 0.0;
            }
            LineSequence.NextPointOnLineIterator<Point> nextRenderPointIterator = lineSequence.getIterator(pixelRepeating > 0.0 ? pixelRepeating : textLength / 4.0, initialCenterTextOffset);
            while (nextRenderPointIterator.hasNext()) {
                Point xyTilePixel = nextRenderPointIterator.next();
                if (!clipBBox.contains(xyTilePixel)) continue;
                this.renderTextOnLine(renderRequest, canvas, nextRenderPointIterator, xyTilePixel, textRowContainer, zoom, font, color, colorHalo, textHaloStroke, geoCalculator, pixelSpacing, borderDistance, allOverlapManager, renderLayer, maxSingleCharRotation, isHeightText, fontContext, skipTextDirectionAdjustment);
            }
            double secondaryOffset = canvas.getFontMetrics().stringWidth("" + textValue.charAt(0));
            nextRenderPointIterator = lineSequence.getIterator(pixelRepeating > 0.0 ? pixelRepeating : textLength / 4.0, secondaryOffset);
            while (nextRenderPointIterator.hasNext()) {
                Point xyTilePixel = nextRenderPointIterator.next();
                if (!clipBBox.contains(xyTilePixel)) continue;
                this.renderTextOnLine(renderRequest, canvas, nextRenderPointIterator, xyTilePixel, textRowContainer, zoom, font, color, colorHalo, textHaloStroke, geoCalculator, pixelSpacing, borderDistance, allOverlapManager, renderLayer, maxSingleCharRotation, isHeightText, fontContext, skipTextDirectionAdjustment);
            }
        }
    }

    private void renderTextOnLine(RenderRequest renderRequest, Graphics2D canvas, LineSequence.NextPointOnLineIterator<Point> nextRenderPointIterator, Point xyTilePixel, TextRowContainer textRowContainer, double zoom, Font font, Color color, Color colorHalo, Optional<BasicStroke> textHaloStroke, GeoCalculator geoCalculator, double pixelSpacing, double borderDistance, RenderOverlapManager allOverlapManager, RenderImageLayer renderLayer, double maxSingleCharRotation, boolean isHeightText, FontContext fontContext, boolean skipTextDirectionAdjustment) {
        RenderTextLineItem renderTextItem = new RenderTextLineItem(textRowContainer, xyTilePixel, zoom, renderRequest.getTileIndex(), textRowContainer.getFullText());
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        double charShiftRotationThreshold = 5.0;
        double charShiftDistance = 0.0;
        TextLinePositioningHints positioningHints = this.calculatePositioningHints(renderRequest, canvas, nextRenderPointIterator, textRowContainer, pixelSpacing, charShiftRotationThreshold, charShiftDistance, maxSingleCharRotation, borderDistance, fontContext);
        if (positioningHints.needsInversion) {
            Object invertedNextRenderPointIterator = nextRenderPointIterator.clone();
            ((LineSequence.NextPointOnLineIterator)invertedNextRenderPointIterator).setStartLineIndex(positioningHints.lastLetterNextLineIndex);
            ((LineSequence.NextPointOnLineIterator)invertedNextRenderPointIterator).setDirection(Line.Direction.BACKWARD);
            ((LineSequence.NextPointOnLineIterator)invertedNextRenderPointIterator).setStartPoint(positioningHints.lastLetterNextPoint);
            TextLinePositioningHints invertedPositioningHints = this.calculatePositioningHints(renderRequest, canvas, (LineSequence.NextPointOnLineIterator<Point>)invertedNextRenderPointIterator, textRowContainer, pixelSpacing, charShiftRotationThreshold, charShiftDistance, maxSingleCharRotation, borderDistance, fontContext);
            if (!invertedPositioningHints.canPlaceOnLine || invertedPositioningHints.hasCollision || invertedPositioningHints.toMuchSingleRotation || invertedPositioningHints.toMuchTotalRotation || invertedPositioningHints.hasTileCrossing) {
                return;
            }
        }
        if (isHeightText && positioningHints.hasSrtmCollision) {
            return;
        }
        if (!(!positioningHints.canPlaceOnLine || positioningHints.hasCollision || positioningHints.toMuchSingleRotation || positioningHints.toMuchTotalRotation || positioningHints.hasTileCrossing)) {
            RenderImageLayer tempLayer = renderRequest.getRenderImage().createLayer("render-text-line-canvas", tileOutputter.getTileSize());
            Graphics2D tempCanvas = tempLayer.getCanvas();
            tempCanvas.setFont(font);
            tempCanvas.setColor(color);
            if (textHaloStroke.isPresent()) {
                tempCanvas.setStroke(textHaloStroke.get());
            }
            this.renderWordOnLine(renderRequest, tempCanvas, nextRenderPointIterator, textRowContainer, color, colorHalo, textHaloStroke, geoCalculator, positioningHints, renderTextItem, charShiftRotationThreshold, charShiftDistance, false, fontContext, skipTextDirectionAdjustment);
            this.renderWordOnLine(renderRequest, tempCanvas, nextRenderPointIterator, textRowContainer, color, colorHalo, textHaloStroke, geoCalculator, positioningHints, renderTextItem, charShiftRotationThreshold, charShiftDistance, true, fontContext, skipTextDirectionAdjustment);
            if (isHeightText) {
                allOverlapManager.addRenderSrtmTextItem(new RenderSrtmTextItem(renderTextItem));
            } else {
                allOverlapManager.addRenderTextLineItem(renderTextItem);
            }
            renderRequest.getRenderImage().mergeToLayer(tempLayer, renderLayer);
        }
    }

    private void renderWordOnLine(RenderRequest renderRequest, Graphics2D canvas, LineSequence.NextPointOnLineIterator<Point> nextRenderPointIterator, TextRowContainer textRowContainer, Color color, Color colorHalo, Optional<BasicStroke> textHaloStroke, GeoCalculator geoCalculator, TextLinePositioningHints positioningHints, RenderTextLineItem renderTextItem, double charShiftRotationThreshold, double charShiftDistance, boolean isSecondPlainRenderRun, FontContext fontContext, boolean skipTextDirectionAdjustment) {
        LineSequence.NextPointOnLineIterator<Point> letterPointIterator = nextRenderPointIterator.createLetterIterator();
        if (positioningHints.needsInversion && !skipTextDirectionAdjustment) {
            letterPointIterator.setStartLineIndex(positioningHints.lastLetterNextLineIndex);
            letterPointIterator.setDirection(Line.Direction.BACKWARD);
            letterPointIterator.setStartPoint(positioningHints.lastLetterNextPoint);
        }
        letterPointIterator.next(0.0);
        double currentLetterWidth = 0.0;
        int fontType = fontContext.getFaceStyle();
        TextRow textRow = textRowContainer.getTextRows().get(0);
        canvas.setColor(colorHalo);
        for (int k = 0; k < textRow.getTextRowEntries().size(); ++k) {
            TextRowEntry entry = textRow.getTextRowEntries().get(k);
            if (entry.getType() == 1) {
                fontType = entry.getFaceStyle();
                continue;
            }
            String entryText = entry.getParsedText(textRow.getWrapCharacter());
            for (int t = 0; t < entryText.length(); ++t) {
                String currentLetter = "" + entryText.charAt(t);
                FontContext dummyFontContext = fontContext.clone();
                dummyFontContext.setFaceStyle(fontType);
                Font font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                canvas.setFont(font);
                FontMetrics fontMetrics = canvas.getFontMetrics();
                double letterWidth = (double)canvas.getFontMetrics().stringWidth(currentLetter) + 0.0;
                double letterHeight = canvas.getFontMetrics().getAscent() + canvas.getFontMetrics().getDescent();
                currentLetterWidth = letterWidth;
                Point currentLetterStartPoint = letterPointIterator.getCurrentPoint();
                int currentLetterStartLineIndex = letterPointIterator.getCurrentLineIndex();
                Point nextLetterStartPoint = letterPointIterator.next(currentLetterWidth);
                if (nextLetterStartPoint == null) continue;
                Line currentLine = letterPointIterator.getIteratorLines().get(currentLetterStartLineIndex);
                double rotation = geoCalculator.getRotation(currentLine.getStart().getX(), currentLine.getStart().getY(), currentLine.getStop().getX(), currentLine.getStop().getY());
                canvas.translate(currentLetterStartPoint.getX(), currentLetterStartPoint.getY());
                canvas.rotate(Math.toRadians(rotation));
                GlyphVector glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                float getDescend = fontMetrics.getMaxDescent();
                Shape textShape = glyphVector.getOutline(0.0f, getDescend);
                if (!isSecondPlainRenderRun) {
                    if (textHaloStroke.isPresent()) {
                        canvas.setColor(colorHalo);
                        canvas.draw(textShape);
                    }
                    canvas.setColor(colorHalo);
                    canvas.fill(textShape);
                } else {
                    canvas.setColor(color);
                    canvas.fill(textShape);
                }
                canvas.rotate(Math.toRadians(-rotation));
                canvas.translate(-currentLetterStartPoint.getX(), -currentLetterStartPoint.getY());
                if (!isSecondPlainRenderRun) continue;
                Circle letterCircle = new Circle(currentLetterStartPoint.getX() + letterWidth / 2.0, currentLetterStartPoint.getY(), Math.max(letterWidth, letterHeight) / 2.0);
                renderTextItem.addBoundingCircle(letterCircle);
            }
        }
    }

    private boolean isRotationReadable(double rotation) {
        if (rotation > 360.0) {
            rotation -= 360.0;
        }
        if (rotation >= 0.0) {
            return !(rotation > 90.0) || !(rotation < 270.0);
        }
        return !(rotation < -90.0) || !(rotation > -270.0);
    }

    private TextLinePositioningHints calculatePositioningHints(RenderRequest renderRequest, Graphics2D baseCanvas, LineSequence.NextPointOnLineIterator<Point> basePointIterator, TextRowContainer textRowContainer, double pixelSpacing, double charShiftRotationThreshold, double charShiftDistance, double maxSingleCharRotation, double borderDistance, FontContext fontContext) {
        TextLinePositioningHints hints = new TextLinePositioningHints(this);
        RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        GeoCalculator geoCalculator = renderRequest.getGeoCalculator();
        Point xyTilePixel = basePointIterator.getCurrentPoint();
        Point tileIndex = renderRequest.getTileIndex();
        double zoom = renderRequest.getZoomInfo().getZoom();
        Graphics dummyCanvas = baseCanvas.create();
        LineSequence.NextPointOnLineIterator<Point> letterPointIterator = basePointIterator.createLetterIterator();
        RenderTextLineItem tempRenderTextItem = new RenderTextLineItem(textRowContainer, xyTilePixel, zoom, tileIndex, "");
        int orientationOk = 0;
        int orientationNotOk = 0;
        double maxSingleRotationDiff = 0.0;
        double maxTotalRotationDiff = 0.0;
        double lastRotation = 0.0;
        double maxLetterWidth = 0.0;
        ArrayList<Point> xyPoints = new ArrayList<Point>();
        xyPoints.add(letterPointIterator.next(0.0));
        TextRow textRow = textRowContainer.getTextRows().get(0);
        int fontType = fontContext.getFaceStyle();
        block0: for (int k = 0; k < textRow.getTextRowEntries().size(); ++k) {
            TextRowEntry entry = textRow.getTextRowEntries().get(k);
            if (entry.getType() == 1) {
                fontType = entry.getFaceStyle();
                continue;
            }
            String entryText = entry.getParsedText(textRow.getWrapCharacter());
            for (int t = 0; t < entryText.length(); ++t) {
                String currentLetter = "" + entryText.charAt(t);
                FontContext dummyFontContext = fontContext.clone();
                dummyFontContext.setFaceStyle(fontType);
                Font font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                dummyCanvas.setFont(font);
                FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
                double letterWidth = fontMetrics.stringWidth(currentLetter);
                double letterHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
                maxLetterWidth = Math.max(maxLetterWidth, letterWidth);
                Point currentLetterStartPoint = letterPointIterator.getCurrentPoint();
                int currentLetterStartLineIndex = letterPointIterator.getCurrentLineIndex();
                Point nextLetterStartPoint = letterPointIterator.next(letterWidth);
                int nextLetterStartLineIndex = letterPointIterator.getCurrentLineIndex();
                if (nextLetterStartPoint != null) {
                    xyPoints.add(nextLetterStartPoint);
                }
                if (nextLetterStartPoint == null) {
                    hints.canPlaceOnLine = false;
                    continue block0;
                }
                hints.lastLetterNextPoint = nextLetterStartPoint;
                hints.lastLetterNextLineIndex = nextLetterStartLineIndex;
                hints.lastLetterPoint = currentLetterStartPoint;
                hints.lastLetterLineIndex = currentLetterStartLineIndex;
                Circle letterCircle = new Circle(currentLetterStartPoint.getX() + letterWidth / 2.0, currentLetterStartPoint.getY(), Math.max(letterWidth, letterHeight) / 2.0);
                tempRenderTextItem.addBoundingCircle(letterCircle);
                Line currentLine = letterPointIterator.getIteratorLines().get(currentLetterStartLineIndex);
                double rotation = geoCalculator.getRotation(currentLine.getStart().getX(), currentLine.getStart().getY(), currentLine.getStop().getX(), currentLine.getStop().getY());
                if (t == 0) {
                    lastRotation = rotation;
                    hints.firstLetterLineIndex = currentLetterStartLineIndex;
                    hints.firstLetterPoint = currentLetterStartPoint;
                } else {
                    double normalizedLastRotation = this.getNormalizedRotation(lastRotation);
                    double normalizedRotation = this.getNormalizedRotation(rotation);
                    double rotationDiff = Math.abs(normalizedLastRotation - normalizedRotation);
                    maxTotalRotationDiff += rotationDiff;
                    maxSingleRotationDiff = Math.max(maxSingleRotationDiff, rotationDiff);
                    lastRotation = rotation;
                }
                if (this.isRotationReadable(rotation)) {
                    ++orientationOk;
                    continue;
                }
                ++orientationNotOk;
            }
        }
        double normalizedLastRotation = -2.147483648E9;
        for (int i = 1; i < xyPoints.size(); ++i) {
            Point startPoint = (Point)xyPoints.get(i - 1);
            Point endPoint = xyPoints.get(i);
            double rotation = geoCalculator.getRotation(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
            if (normalizedLastRotation == -2.147483648E9) {
                normalizedLastRotation = this.getNormalizedRotation(rotation);
                continue;
            }
            double normalizedRotation = this.getNormalizedRotation(rotation);
            double rotationDiff = Math.abs(normalizedLastRotation - normalizedRotation);
            normalizedLastRotation = normalizedRotation;
            maxSingleRotationDiff = Math.max(maxSingleRotationDiff, rotationDiff);
        }
        if (renderRequest.getBoundingBoxPixel().hasBorderCrossing(xyPoints, tileOutputter.getTileSize())) {
            hints.hasTileCrossing = true;
        }
        if (renderRequest.getBoundingBoxPixel().isCloseToBorder(xyPoints, tileOutputter.getTileSize(), borderDistance)) {
            hints.isCloseToBorder = true;
        }
        if (orientationNotOk > orientationOk) {
            hints.needsInversion = true;
        }
        if (allOverlapManager.hasOverlappingTextLineItemsWithSameName(tempRenderTextItem, pixelSpacing)) {
            hints.hasCollision = true;
        }
        if (allOverlapManager.hasOverlappingItems(tempRenderTextItem, true, true, true, true)) {
            hints.hasCollision = true;
        }
        if (allOverlapManager.hasOverlappingSrtmTextItems(new RenderSrtmTextItem(tempRenderTextItem), pixelSpacing)) {
            hints.hasSrtmCollision = true;
        }
        hints.maxSingleRotationDiff = maxSingleRotationDiff;
        if (maxSingleRotationDiff > maxSingleCharRotation) {
            hints.toMuchSingleRotation = true;
        }
        hints.maxTotalRotationDiff = maxTotalRotationDiff;
        if (maxTotalRotationDiff > 100.0) {
            hints.toMuchTotalRotation = true;
        }
        dummyCanvas.dispose();
        return hints;
    }

    private double getNormalizedRotation(double rotation) {
        double normalizedRotation = rotation;
        if (normalizedRotation > 180.0) {
            normalizedRotation -= 360.0;
        } else if (normalizedRotation < -180.0) {
            normalizedRotation += 360.0;
        }
        return normalizedRotation;
    }

    private boolean isPolygonLineInBoundingBox(BoundingBox mercatorBBox, PostgresPolygon mercatorPolygon) {
        PostgresPolygonElement basePolygon = mercatorPolygon.getPolygonElements()[0];
        BoundingBox doubleSizeBBox = mercatorBBox.clone();
        doubleSizeBBox.increaseBBox(mercatorBBox.getWidth(), mercatorBBox.getHeight());
        for (Point point : basePolygon.getPoints()) {
            if (!doubleSizeBBox.contains(point)) continue;
            return true;
        }
        return false;
    }

    private boolean isLineStringInBoundingBox(BoundingBox mercatorBBox, PostgresLineString mercatorLineString) {
        BoundingBox doubleSizeBBox = mercatorBBox.clone();
        doubleSizeBBox.increaseBBox(mercatorBBox.getWidth(), mercatorBBox.getHeight());
        for (Point point : mercatorLineString.getPoints()) {
            if (!doubleSizeBBox.contains(point)) continue;
            return true;
        }
        return false;
    }

    public class TextLinePositioningHints {
        boolean canPlaceOnLine = true;
        boolean hasCollision = false;
        boolean hasSrtmCollision = false;
        boolean needsInversion = false;
        boolean toMuchSingleRotation = false;
        boolean toMuchTotalRotation = false;
        double maxSingleRotationDiff = 0.0;
        double maxTotalRotationDiff = 0.0;
        boolean hasTileCrossing = false;
        boolean isCloseToBorder = false;
        Point firstLetterPoint = null;
        Point lastLetterPoint = null;
        Point lastLetterNextPoint = null;
        int firstLetterLineIndex = -1;
        int lastLetterLineIndex = -1;
        int lastLetterNextLineIndex = -1;

        public TextLinePositioningHints(OsmTextSymbolizerRenderer this$0) {
        }
    }
}

