/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.IOsmTextAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.text.TextRow;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import de.wideportal.maprender.resources.fonts.FontContext;
import de.wideportal.maprender.resources.fonts.FontsUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTextPointRenderHints {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int ALIGNMENT_HORIZONTAL_LEFT = -1;
    public static final int ALIGNMENT_HORIZONTAL_MIDDLE = 0;
    public static final int ALIGNMENT_HORIZONTAL_RIGHT = 1;
    public static final int ALIGNMENT_HORIZONTAL_AUTO = 2;
    public static final int ALIGNMENT_VERTICAL_TOP = -1;
    public static final int ALIGNMENT_VERTICAL_MIDDLE = 0;
    public static final int ALIGNMENT_VERTICAL_BOTTOM = 1;
    public static final int ALIGNMENT_VERTICAL_AUTO = 2;
    public static final int ALIGNMENT_MULTILINE_LEFT = -1;
    public static final int ALIGNMENT_MULTILINE_MIDDLE = 0;
    public static final int ALIGNMENT_MULTILINE_RIGHT = 1;
    public static final int ALIGNMENT_MULTILINE_AUTO = 2;
    public static final int LINE_SPACING_CORRECTION = 0;
    IOsmTextAccessor genericTextAccessor;

    public OsmTextPointRenderHints(IOsmTextAccessor genericTextAccessor) {
        this.genericTextAccessor = genericTextAccessor;
    }

    public int getStringWidth(String text, FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(text);
    }

    public BoundingBox getTextRowBoundingBox(String rowText, int row, BoundingBox wholeTextBBox, Graphics dummyCanvas, FontContext fontContext) {
        double bboxLeft = 0.0;
        double bboxTop = 0.0;
        double bboxRight = 0.0;
        double bboxBottom = 0.0;
        double textHeight = 0.0;
        double textWidth = 0.0;
        for (int i = 0; i < rowText.length(); ++i) {
            String currentLetter = "" + rowText.charAt(i);
            Font font = FontsUtil.getBestFittingFont(fontContext, currentLetter);
            dummyCanvas.setFont(font);
            FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
            textHeight = Math.max(textHeight, (double)fontMetrics.getHeight());
            textWidth += (double)this.getStringWidth(currentLetter, fontMetrics);
        }
        double lineSpacing = this.genericTextAccessor.getLineSpacing();
        bboxTop = -2.0 + wholeTextBBox.getTop() + (textHeight + (lineSpacing += 0.0)) * (double)row;
        bboxBottom = -2.0 + wholeTextBBox.getTop() + (textHeight + lineSpacing) * (double)(row + 1);
        int xAlign = this.getMultilineAlignment();
        if (xAlign == 2) {
            bboxLeft = wholeTextBBox.getCenter().getX() - textWidth / 2.0;
        } else if (xAlign == -1) {
            bboxLeft = wholeTextBBox.getLeft();
        } else if (xAlign == 0) {
            bboxLeft = wholeTextBBox.getCenter().getX() - textWidth / 2.0;
        } else if (xAlign == 1) {
            bboxLeft = wholeTextBBox.getRight() - textWidth;
        }
        bboxRight = bboxLeft + textWidth;
        return new BoundingBox(bboxLeft, bboxBottom, bboxRight, bboxTop);
    }

    public BoundingBox getTextRowBoundingBox(TextRow rowText, int row, BoundingBox wholeTextBBox) {
        double bboxLeft = 0.0;
        double bboxTop = 0.0;
        double bboxRight = 0.0;
        double bboxBottom = 0.0;
        double textHeight = rowText.getStringHeight();
        double textWidth = rowText.getStringWidth();
        double lineSpacing = this.genericTextAccessor.getLineSpacing();
        bboxTop = -2.0 + wholeTextBBox.getTop() + (textHeight + (lineSpacing += 0.0)) * (double)row;
        bboxBottom = -2.0 + wholeTextBBox.getTop() + (textHeight + lineSpacing) * (double)(row + 1);
        int xAlign = this.getMultilineAlignment();
        if (xAlign == 2) {
            bboxLeft = wholeTextBBox.getCenter().getX() - textWidth / 2.0;
        } else if (xAlign == -1) {
            bboxLeft = wholeTextBBox.getLeft();
        } else if (xAlign == 0) {
            bboxLeft = wholeTextBBox.getCenter().getX() - textWidth / 2.0;
        } else if (xAlign == 1) {
            bboxLeft = wholeTextBBox.getRight() - textWidth;
        }
        bboxRight = bboxLeft + textWidth;
        return new BoundingBox(bboxLeft, bboxBottom, bboxRight, bboxTop);
    }

    public BoundingBox getTextBoundingBox(Point xyOrigin, TextRowContainer rows, String compassPlacement, FontContext fontContext, Graphics dummyCanvas) {
        return this.getTextBoundingBox(xyOrigin, rows, compassPlacement, null, fontContext, dummyCanvas);
    }

    public BoundingBox getTextBoundingBox(Point xyOrigin, ArrayList<String> rows, String compassPlacement, BoundingBox symbolBBox, FontContext fontContext, Graphics dummyCanvas) {
        int xAlign = this.getHorizontalAlignment();
        int yAlign = this.getVerticalAlignment();
        double dx = this.genericTextAccessor.getDx();
        double x = xyOrigin.getX();
        double dy = this.genericTextAccessor.getDy();
        double y = xyOrigin.getY();
        if (compassPlacement != null) {
            dx = 0.0;
            if (compassPlacement.toLowerCase().contains("w")) {
                xAlign = -1;
                yAlign = 0;
                if (symbolBBox != null) {
                    dx = -symbolBBox.getWidth();
                }
            } else if (compassPlacement.toLowerCase().contains("e")) {
                xAlign = 1;
                yAlign = 0;
                if (symbolBBox != null) {
                    dx = symbolBBox.getWidth();
                }
            }
            if (compassPlacement.toLowerCase().contains("s")) {
                yAlign = 1;
            } else if (compassPlacement.toLowerCase().contains("n")) {
                yAlign = -1;
            } else {
                yAlign = 0;
                dy = 0.0;
            }
        }
        double bboxLeft = 0.0;
        double bboxTop = 0.0;
        double bboxRight = 0.0;
        double bboxBottom = 0.0;
        double lineSpacing = this.genericTextAccessor.getLineSpacing();
        lineSpacing += 0.0;
        double maxRowWidth = 0.0;
        double totalHeight = 0.0;
        double maxDescend = 0.0;
        for (int i = 0; i < rows.size(); ++i) {
            Font font = FontsUtil.getBestFittingFont(fontContext, rows.get(i));
            dummyCanvas.setFont(font);
            FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
            double rowWidth = this.getStringWidth(rows.get(i), fontMetrics);
            double rowHeight = fontMetrics.getHeight();
            maxRowWidth = Math.max(rowWidth, maxRowWidth);
            totalHeight += rowHeight + lineSpacing;
            maxDescend = Math.max(maxDescend, (double)fontMetrics.getMaxDescent());
        }
        x += dx;
        if (xAlign == 2) {
            bboxLeft = x - maxRowWidth / 2.0;
        } else if (xAlign == -1) {
            bboxLeft = x - maxRowWidth;
        } else if (xAlign == 0) {
            bboxLeft = x - maxRowWidth / 2.0;
        } else if (xAlign == 1) {
            bboxLeft = x;
        }
        bboxRight = bboxLeft + maxRowWidth + 1.0;
        if (yAlign == 2) {
            if (dy == 0.0) {
                bboxTop = y + dy - totalHeight / 2.0;
            } else if (dy < 0.0) {
                bboxTop = y + dy - totalHeight + maxDescend;
            } else if (dy > 0.0) {
                bboxTop = y + dy - maxDescend;
            }
        } else if (yAlign == -1) {
            bboxTop = y - dy - totalHeight + maxDescend;
        } else if (yAlign == 0) {
            bboxTop = y + dy - totalHeight / 2.0;
        } else if (yAlign == 1) {
            bboxTop = y + dy - maxDescend;
        }
        bboxBottom = bboxTop + totalHeight - 1.0;
        Point displacement = this.genericTextAccessor.getDisplacement();
        bboxTop = bboxTop + displacement.getY() + 2.0;
        return new BoundingBox(bboxLeft += displacement.getX(), bboxBottom += displacement.getY(), bboxRight += displacement.getX(), bboxTop);
    }

    public BoundingBox getTextBoundingBox(Point xyOrigin, TextRowContainer rows, String compassPlacement, BoundingBox symbolBBox, FontContext fontContext, Graphics dummyCanvas) {
        int xAlign = this.getHorizontalAlignment();
        int yAlign = this.getVerticalAlignment();
        double dx = this.genericTextAccessor.getDx();
        double x = xyOrigin.getX();
        double dy = this.genericTextAccessor.getDy();
        double y = xyOrigin.getY();
        if (compassPlacement != null) {
            dx = 0.0;
            if (compassPlacement.toLowerCase().contains("w")) {
                xAlign = -1;
                yAlign = 0;
                if (symbolBBox != null) {
                    dx = -symbolBBox.getWidth();
                }
            } else if (compassPlacement.toLowerCase().contains("e")) {
                xAlign = 1;
                yAlign = 0;
                if (symbolBBox != null) {
                    dx = symbolBBox.getWidth();
                }
            }
            if (compassPlacement.toLowerCase().contains("s")) {
                yAlign = 1;
            } else if (compassPlacement.toLowerCase().contains("n")) {
                yAlign = -1;
            } else {
                yAlign = 0;
                dy = 0.0;
            }
        }
        double bboxLeft = 0.0;
        double bboxTop = 0.0;
        double bboxRight = 0.0;
        double bboxBottom = 0.0;
        double lineSpacing = this.genericTextAccessor.getLineSpacing();
        lineSpacing += 0.0;
        double maxRowWidth = 0.0;
        double totalHeight = 0.0;
        double maxDescent = 0.0;
        for (int i = 0; i < rows.getTextRows().size(); ++i) {
            TextRow textRow = rows.getTextRows().get(i);
            double rowWidth = textRow.getStringWidth();
            double rowHeight = textRow.getStringHeight();
            double rowMaxDescent = textRow.getMaxDescent();
            maxRowWidth = Math.max(rowWidth, maxRowWidth);
            totalHeight += rowHeight + lineSpacing;
            maxDescent = Math.max(maxDescent, rowMaxDescent);
        }
        x += dx;
        if (xAlign == 2) {
            bboxLeft = x - maxRowWidth / 2.0;
        } else if (xAlign == -1) {
            bboxLeft = x - maxRowWidth;
        } else if (xAlign == 0) {
            bboxLeft = x - maxRowWidth / 2.0;
        } else if (xAlign == 1) {
            bboxLeft = x;
        }
        bboxRight = bboxLeft + maxRowWidth + 1.0;
        if (yAlign == 2) {
            if (dy == 0.0) {
                bboxTop = y + dy - totalHeight / 2.0;
            } else if (dy < 0.0) {
                bboxTop = y + dy - totalHeight + maxDescent;
            } else if (dy > 0.0) {
                bboxTop = y + dy - maxDescent;
            }
        } else if (yAlign == -1) {
            bboxTop = y - dy - totalHeight + maxDescent;
        } else if (yAlign == 0) {
            bboxTop = y + dy - totalHeight / 2.0;
        } else if (yAlign == 1) {
            bboxTop = y + dy - maxDescent;
        }
        bboxBottom = bboxTop + totalHeight - 1.0;
        Point displacement = this.genericTextAccessor.getDisplacement();
        bboxTop = bboxTop + displacement.getY() + 2.0;
        return new BoundingBox(bboxLeft += displacement.getX(), bboxBottom += displacement.getY(), bboxRight += displacement.getX(), bboxTop);
    }

    public int getLongestUnbreakableTextPart(List<String> textRows, FontContext fontContext, Graphics dummyCanvas) {
        int longestUnbreakableWord = 0;
        String wrapCharacter = this.genericTextAccessor.getWrapCharacter();
        for (String textRow : textRows) {
            String[] words;
            for (String word : words = textRow.split(wrapCharacter)) {
                Font font = FontsUtil.getBestFittingFont(fontContext, word);
                dummyCanvas.setFont(font);
                FontMetrics fontMetrics = dummyCanvas.getFontMetrics();
                longestUnbreakableWord = Math.max(longestUnbreakableWord, this.getStringWidth(word, fontMetrics));
            }
        }
        return longestUnbreakableWord;
    }

    public TextRowContainer getTextRowContainer(String text, FontContext fontContext, Graphics dummyCanvas, int minimumLineLength) {
        return TextRowContainer.parse(text, this.genericTextAccessor, fontContext, dummyCanvas, minimumLineLength);
    }

    public int getHorizontalAlignment() {
        String horizontalAlignment = this.genericTextAccessor.getHorizontalAlignment();
        if (horizontalAlignment != null && !horizontalAlignment.trim().isEmpty()) {
            if ("left".equalsIgnoreCase(horizontalAlignment)) {
                return -1;
            }
            if ("middle".equalsIgnoreCase(horizontalAlignment)) {
                return 0;
            }
            if ("right".equalsIgnoreCase(horizontalAlignment)) {
                return 1;
            }
        }
        return 2;
    }

    public int getVerticalAlignment() {
        String verticalAlignment = this.genericTextAccessor.getVerticalAlignment();
        if (verticalAlignment != null && !verticalAlignment.trim().isEmpty()) {
            if ("top".equalsIgnoreCase(verticalAlignment)) {
                return -1;
            }
            if ("middle".equalsIgnoreCase(verticalAlignment)) {
                return 0;
            }
            if ("bottom".equalsIgnoreCase(verticalAlignment)) {
                return 1;
            }
        }
        return 2;
    }

    public int getMultilineAlignment() {
        String multilineAlignment = this.genericTextAccessor.getJustifyAlignment();
        if (multilineAlignment != null && !multilineAlignment.trim().isEmpty()) {
            if ("left".equalsIgnoreCase(multilineAlignment)) {
                return -1;
            }
            if ("middle".equalsIgnoreCase(multilineAlignment)) {
                return 0;
            }
            if ("right".equalsIgnoreCase(multilineAlignment)) {
                return 1;
            }
        }
        return 2;
    }
}

