/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmPolygonSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.util.color.ColorUtil;
import de.wideportal.maprender.util.filter.BlurFilter;
import de.wideportal.maprender.util.filter.ShadowFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPolygonSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderPolygonSymbolizer(OsmPolygonSymbolizerAccessor polygonSymbolizer, RenderImageLayer renderLayer, KmlLineString kmlLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderRequest renderRequest, OsmLayerAccessor layer) {
        PostgresPolygon latLonPolygon = new PostgresPolygon(kmlLineString);
        this.renderPolygonSymbolizer(polygonSymbolizer, renderLayer, latLonPolygon, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
    }

    public void renderPolygonSymbolizer(OsmPolygonSymbolizerAccessor polygonSymbolizer, RenderImageLayer renderLayer, PostgresPolygon latLonPolygon, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, RenderRequest renderRequest, OsmLayerAccessor layer) {
        if (latLonPolygon.getPolygonElements().length == 0) {
            return;
        }
        Graphics2D canvas = renderLayer.getCanvas();
        Color baseColor = polygonSymbolizer.getFill();
        float fillOpacity = polygonSymbolizer.getFillOpacity().floatValue();
        Color fillColor = ColorUtil.getColor(baseColor, fillOpacity);
        Boolean shadow = polygonSymbolizer.getShadow();
        Color shadowColor = polygonSymbolizer.getShadowColor();
        int shadowDirection = polygonSymbolizer.getShadowDirection();
        int shadowOffset = polygonSymbolizer.getShadowOffset();
        int shadowRadius = polygonSymbolizer.getShadowRadius();
        Polygon rootPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[0], zoom, xOffset, yOffset);
        Area polygonArea = new Area(rootPolygon);
        BoundingBox clipBBox = renderRequest.getBoundingBoxPixel().clone();
        clipBBox.increaseBBox(clipBBox.getWidth());
        polygonArea = this.clipAreaToBBox(polygonArea, clipBBox);
        if (shadow.booleanValue()) {
            RenderImageLayer shadowLayer = renderRequest.getRenderImage().createLayer("render-polygon-shadow-canvas", renderRequest.getTileOutputter().getTileSize() + 2 * shadowRadius);
            Graphics2D shadowCanvas = shadowLayer.getCanvas();
            shadowCanvas.setColor(shadowColor);
            Area shadowPolygonArea = (Area)polygonArea.clone();
            for (int i = 1; i < latLonPolygon.getPolygonElements().length; ++i) {
                Polygon subPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[i], zoom, xOffset, yOffset);
                Area shadowSubPolygonArea = new Area(subPolygon);
                shadowPolygonArea.subtract(shadowSubPolygonArea);
            }
            AffineTransform transform = new AffineTransform();
            transform.rotate(Math.toRadians(shadowDirection));
            transform.translate(0.0, -shadowOffset);
            transform.rotate(Math.toRadians(-shadowDirection));
            transform.translate(shadowRadius, shadowRadius);
            shadowPolygonArea.transform(transform);
            shadowCanvas.fill(shadowPolygonArea);
            ShadowFilter shadowFilter = new ShadowFilter(shadowRadius);
            BlurFilter blurFilter = new BlurFilter(shadowRadius);
            BufferedImage bluredImage = shadowFilter.filter(shadowLayer.getImage(), null);
            bluredImage = blurFilter.filter(bluredImage, null);
            shadowLayer.setImage(bluredImage);
            shadowCanvas = shadowLayer.getCanvas();
            shadowCanvas.setColor(fillColor);
            shadowCanvas.setComposite(AlphaComposite.getInstance(2, 1.0f));
            for (int i = 1; i < latLonPolygon.getPolygonElements().length; ++i) {
                Polygon subPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[i], zoom, xOffset, yOffset);
                Area subPolygonArea = new Area(subPolygon);
                polygonArea.subtract(subPolygonArea);
            }
            transform = new AffineTransform();
            transform.translate(shadowRadius, shadowRadius);
            polygonArea.transform(transform);
            shadowCanvas.fill(polygonArea);
            renderRequest.getRenderImage().mergeToLayer(shadowLayer, renderLayer, shadowRadius);
        } else {
            canvas.setColor(fillColor);
            for (int i = 1; i < latLonPolygon.getPolygonElements().length; ++i) {
                Polygon subPolygon = this.getPolygonForMercatorElement(geoCalculator, tileOutputter, latLonPolygon.getPolygonElements()[i], zoom, xOffset, yOffset);
                Area subPolygonArea = new Area(subPolygon);
                polygonArea.subtract(subPolygonArea);
            }
            canvas.fill(polygonArea);
        }
    }

    private Area clipAreaToBBox(Area area, BoundingBox pixelBBox) {
        Rectangle pixelBBoxRect = pixelBBox.getRectangle();
        Area bboxArea = new Area(pixelBBoxRect);
        area.intersect(bboxArea);
        return area;
    }

    public BufferedImage createLargerImage(BufferedImage src, float radius) {
        ColorModel dstCM = src.getColorModel();
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster((int)((float)src.getWidth() + 2.0f * radius), (int)((float)src.getHeight() + 2.0f * radius)), dstCM.isAlphaPremultiplied(), null);
    }

    private Polygon getPolygonForMercatorElement(GeoCalculator geoCalculator, AbstractMapTileOutput tileOutputter, PostgresPolygonElement mercatorPolygonElement, double zoom, double xOffset, double yOffset) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorPolygonElement.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        int[][] xyValues = PostgresPolygonElement.getPointsAsIntArray(xyTilePoints);
        Polygon polygon = new Polygon(xyValues[0], xyValues[1], xyValues[0].length);
        return polygon;
    }

    private BasicStroke getBasicStroke() {
        float width = 0.0f;
        int lineCap = 1;
        int lineJoin = 0;
        BasicStroke basicStroke = new BasicStroke(width, lineCap, lineJoin);
        return basicStroke;
    }
}

