/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.OsmKmlSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLineSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.OsmKmlSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmLineSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmPolygonSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.kml.KmlFile;
import de.wideportal.maprender.resources.kml.KmlFileCache;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.Polygon;
import java.util.List;
import java.util.Optional;
import net.opengis.kml._2.LineStyleType;
import net.opengis.kml._2.StyleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmKmlSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderKml(RenderRequest renderRequest, OsmKmlSymbolizerAccessor kmlSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, OsmLayerAccessor layer) {
        OsmLineSymbolizerRenderer lineSymbolizerRenderer = new OsmLineSymbolizerRenderer();
        OsmPolygonSymbolizerRenderer polygonSymbolizerRenderer = new OsmPolygonSymbolizerRenderer();
        BoundingBox boundingBoxLatLon = renderRequest.getBoundingBoxLatLon();
        Optional<String> optionalKmlFileName = kmlSymbolizer.getFile();
        double adjustWidth = kmlSymbolizer.getAdjustWidth();
        Boolean shadow = kmlSymbolizer.getShadow();
        if (!optionalKmlFileName.isPresent()) {
            this.log.warn("renderKml: no kml file is given. This is most likely a misconfiguration.");
            throw new RuntimeException("renderKml: no kml file was given. This is most likely a misconfiguration.");
        }
        KmlFileCache kmlFileCache = renderRequest.getKmlFileCache();
        Optional<KmlFile> optionalKmlFile = kmlFileCache.getKmlFile(optionalKmlFileName.get());
        if (!optionalKmlFile.isPresent()) {
            this.log.warn("renderKml: no KML file available: " + optionalKmlFileName + ". Skip kml rendering of tile.");
            throw new RuntimeException("renderKml: no KML file available: " + optionalKmlFileName + ". Skip kml rendering of tile.");
        }
        KmlFile kmlFile = optionalKmlFile.get();
        if (shadow.booleanValue()) {
            List<KmlLineString> kmlLineStrings = kmlFile.getKmlLineStrings();
            for (KmlLineString kmlLineString : kmlLineStrings) {
                if (!kmlLineString.isClosedPolygon() || !kmlLineString.isInBoundingBoxLatLon(boundingBoxLatLon)) continue;
                OsmPolygonSymbolizer osmPolygonSymbolizer = new OsmPolygonSymbolizer();
                OsmKmlSymbolizer symbolizer = kmlSymbolizer.getSymbolizer();
                osmPolygonSymbolizer.setFill(symbolizer.getFill());
                osmPolygonSymbolizer.setFillOpacity(symbolizer.getFillOpacity());
                osmPolygonSymbolizer.setShadow(symbolizer.getShadow());
                osmPolygonSymbolizer.setShadowColor(symbolizer.getShadowColor());
                osmPolygonSymbolizer.setShadowDirection(symbolizer.getShadowDirection());
                osmPolygonSymbolizer.setShadowOffset(symbolizer.getShadowOffset());
                osmPolygonSymbolizer.setShadowRadius(symbolizer.getShadowRadius());
                osmPolygonSymbolizer.setIdentifier(symbolizer.getIdentifier());
                polygonSymbolizerRenderer.renderPolygonSymbolizer(osmPolygonSymbolizer.getAccessor(), renderLayer, kmlLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
            }
        } else {
            List<KmlLineString> kmlLineStrings = kmlFile.getKmlLineStrings();
            for (KmlLineString kmlLineString : kmlLineStrings) {
                Double width;
                if (!kmlLineString.isInBoundingBoxLatLon(boundingBoxLatLon)) continue;
                StyleType style = kmlFile.findStyle(kmlLineString.getStyleUrl());
                LineStyleType lineStyleType = style.getLineStyle();
                String color = lineStyleType.getColor();
                if (color == null) {
                    color = "000000";
                }
                if ((width = lineStyleType.getWidth()) == null) {
                    width = 1.0;
                }
                OsmLineSymbolizer osmLineSymbolizer = new OsmLineSymbolizer();
                osmLineSymbolizer.setIdentifier("OsmKmlSymbolizer");
                osmLineSymbolizer.setParent(rule.getOsmRule());
                osmLineSymbolizer.setStrokeWidth("" + (width + adjustWidth));
                osmLineSymbolizer.setStroke("#" + color);
                lineSymbolizerRenderer.renderLineSymbolizer(osmLineSymbolizer.getAccessor(), renderLayer, kmlLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, null);
            }
        }
    }

    private Polygon getPolygonForKmlLineString(GeoCalculator geoCalculator, AbstractMapTileOutput tileOutputter, KmlLineString kmlLineString, double zoom, double xOffset, double yOffset) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(kmlLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        int[][] xyValues = PostgresPolygonElement.getPointsAsIntArray(xyTilePoints);
        Polygon polygon = new Polygon(xyValues[0], xyValues[1], xyValues[0].length);
        return polygon;
    }
}

