/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightRoadSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmSlopeLine;
import de.wideportal.maprender.util.color.ColorLine;
import de.wideportal.maprender.util.color.ColorUtil;
import de.wideportal.maprender.util.color.ColorValueRanges;
import de.wideportal.maprender.util.color.GradientPolygonPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightRoadSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightRoadSymbolizerAccessor heightRoadSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        if ("slope".equalsIgnoreCase(heightRoadSymbolizer.getMode())) {
            this.renderSrtmSlope(renderRequest, heightRoadSymbolizer, renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, mercatorLineString);
        } else {
            this.log.warn("renderSrtm: unknown mode " + heightRoadSymbolizer.getMode());
        }
    }

    public void renderSrtmSlope(RenderRequest renderRequest, OsmHeightRoadSymbolizerAccessor heightRoadSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule, PostgresLineString mercatorLineString) {
        Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
        this.renderSrtmPitch(renderRequest, heightRoadSymbolizer, renderLayer, xyTilePoints, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
    }

    private void renderSrtmPitch(RenderRequest renderRequest, OsmHeightRoadSymbolizerAccessor heightRoadSymbolizer, RenderImageLayer renderLayer, Point[] xyTilePoints, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        int i;
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        Optional<String> colorRanges = heightRoadSymbolizer.getColorRanges();
        int xTileIndex = (int)renderRequest.getTileIndex().getX();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex, yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), true, 0, 0, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderSrtmPitch: could not render pitch because the heightCollectorTile was null");
            return;
        }
        Graphics2D canvas = renderLayer.getCanvas();
        BasicStroke baseStroke = this.getBasicStroke(heightRoadSymbolizer);
        canvas.setStroke(baseStroke);
        ColorValueRanges colorValueRanges = new ColorValueRanges();
        if (colorRanges.isPresent()) {
            colorValueRanges.buildColorRangesFromString(colorRanges.get());
        }
        ArrayList<ColorLine> colorLines = new ArrayList<ColorLine>();
        ArrayList<SrtmSlopeLine> slopeLines = new ArrayList<SrtmSlopeLine>();
        Point lastRenderedPoint = null;
        for (i = 0; i < xyTilePoints.length; ++i) {
            Point point = xyTilePoints[i];
            if (i == 0) {
                lastRenderedPoint = point;
                continue;
            }
            Line line = new Line(lastRenderedPoint, point);
            double lineLength = line.getLength();
            ArrayList<Point> newLinePoints = line.split((int)Math.floor(lineLength / 20.0));
            for (int j = 1; j < newLinePoints.size(); ++j) {
                Point startPoint = newLinePoints.get(j - 1);
                Point stopPoint = newLinePoints.get(j);
                Line subLine = new Line(startPoint, stopPoint);
                double slope = this.getSlope(heightCollectorTile, subLine, geoCalculator, renderRequest.getBoundingBoxLatLon(), tileOutputter.getTileSize());
                slopeLines.add(new SrtmSlopeLine(startPoint, stopPoint, slope));
            }
            lastRenderedPoint = point;
        }
        for (i = 0; i < slopeLines.size(); ++i) {
            Color nextColor;
            Color lastColor;
            Color currentColor;
            Color nextSlopeColor;
            SrtmSlopeLine nextSlopeLine;
            SrtmSlopeLine slopeLine = (SrtmSlopeLine)slopeLines.get(i);
            if (slopeLines.size() == 1) {
                colorLines.add(slopeLine.convertToColorLine(colorValueRanges));
                continue;
            }
            if (i == 0) {
                nextSlopeLine = (SrtmSlopeLine)slopeLines.get(i + 1);
                nextSlopeColor = colorValueRanges.getColorFromColorRanges(nextSlopeLine.getSlope());
                currentColor = colorValueRanges.getColorFromColorRanges(slopeLine.getSlope());
                lastColor = colorValueRanges.getColorFromColorRanges(slopeLine.getSlope());
                nextColor = ColorUtil.getAverageColor(currentColor, nextSlopeColor);
                colorLines.add(new ColorLine(slopeLine.getStart(), slopeLine.getCenter(), lastColor, currentColor));
                colorLines.add(new ColorLine(slopeLine.getCenter(), slopeLine.getStop(), currentColor, nextColor));
                continue;
            }
            if (i == slopeLines.size() - 1) {
                SrtmSlopeLine lastSlopeLine = (SrtmSlopeLine)slopeLines.get(i - 1);
                Color lastSlopeColor = colorValueRanges.getColorFromColorRanges(lastSlopeLine.getSlope());
                currentColor = colorValueRanges.getColorFromColorRanges(slopeLine.getSlope());
                lastColor = ColorUtil.getAverageColor(lastSlopeColor, currentColor);
                nextColor = colorValueRanges.getColorFromColorRanges(slopeLine.getSlope());
                colorLines.add(new ColorLine(slopeLine.getStart(), slopeLine.getCenter(), lastColor, currentColor));
                colorLines.add(new ColorLine(slopeLine.getCenter(), slopeLine.getStop(), currentColor, nextColor));
                continue;
            }
            nextSlopeLine = (SrtmSlopeLine)slopeLines.get(i + 1);
            nextSlopeColor = colorValueRanges.getColorFromColorRanges(nextSlopeLine.getSlope());
            SrtmSlopeLine lastSlopeLine = (SrtmSlopeLine)slopeLines.get(i - 1);
            Color lastSlopeColor = colorValueRanges.getColorFromColorRanges(lastSlopeLine.getSlope());
            Color currentColor2 = colorValueRanges.getColorFromColorRanges(slopeLine.getSlope());
            Color lastColor2 = ColorUtil.getAverageColor(lastSlopeColor, currentColor2);
            Color nextColor2 = ColorUtil.getAverageColor(currentColor2, nextSlopeColor);
            colorLines.add(new ColorLine(slopeLine.getStart(), slopeLine.getCenter(), lastColor2, currentColor2));
            colorLines.add(new ColorLine(slopeLine.getCenter(), slopeLine.getStop(), currentColor2, nextColor2));
        }
        GradientPolygonPaint gradientPolygonPaint = new GradientPolygonPaint(colorLines, heightRoadSymbolizer.getStrokeWidth().floatValue());
        canvas.setPaint(gradientPolygonPaint);
        int[] xPoints = new int[colorLines.size() + 1];
        int[] yPoints = new int[colorLines.size() + 1];
        for (int i2 = 0; i2 < colorLines.size(); ++i2) {
            ColorLine colorLine = colorLines.get(i2);
            if (i2 == colorLines.size() - 1) {
                xPoints[i2] = (int)colorLine.getStart().getX();
                yPoints[i2] = (int)colorLine.getStart().getY();
                xPoints[i2 + 1] = (int)colorLine.getStop().getX();
                yPoints[i2 + 1] = (int)colorLine.getStop().getY();
                continue;
            }
            xPoints[i2] = (int)colorLine.getStart().getX();
            yPoints[i2] = (int)colorLine.getStart().getY();
        }
        canvas.drawPolyline(xPoints, yPoints, xPoints.length);
    }

    public double getSlope(HeightCollectorTile heightCollectorTile, Line line, GeoCalculator geoCalculator, BoundingBox latLonBoundingBox, double tileSize) {
        if (!heightCollectorTile.isInCollectorBounds(line)) {
            return 0.0;
        }
        double heightStart = heightCollectorTile.getValue((int)line.getStart().getX(), (int)line.getStart().getY());
        double heightStop = heightCollectorTile.getValue((int)line.getStop().getX(), (int)line.getStop().getY());
        double heightDiff = Math.abs(heightStop - heightStart);
        double distanceInMeter = geoCalculator.getDistanceInMeterFromPixel(line.getStart().getX(), line.getStart().getY(), line.getStop().getX(), line.getStop().getY(), latLonBoundingBox, tileSize);
        double slope = heightDiff / distanceInMeter;
        double slopeDegree = Math.toDegrees(Math.atan(slope));
        return slopeDegree;
    }

    private BasicStroke getBasicStroke(OsmHeightRoadSymbolizerAccessor heightRoadSymbolizerAccessor) {
        float width = heightRoadSymbolizerAccessor.getStrokeWidth().floatValue();
        int lineCap = 0;
        int lineJoin = 0;
        BasicStroke basicStroke = new BasicStroke(width, lineCap, lineJoin);
        return basicStroke;
    }
}

