/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.metrics;

import de.wideportal.maprender.metrics.MetricEntry;
import de.wideportal.maprender.metrics.ZoomLevelPerformanceMetrics;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceMetrics {
    public static final String METRIC_TILE_TOTAL = "tile-total";
    public static final String METRIC_TILE_RENDER = "tile-render";
    public static final String METRIC_TILE_CLEANUP = "tile-cleanup";
    public static final String METRIC_TILE_RENDER_PROCESS_TRACKING = "tile-render-process-tracking";
    public static final String METRIC_TILE_RENDER_LOG = "tile-render-log";
    public static final String METRIC_TILE_RENDER_TOTAL = "tile-render-total";
    public static final String METRIC_TILE_RENDER_SAVE = "tile-render-save";
    public static final String METRIC_TILE_RENDERTREE_LAYER = "tile-rendertree-layer";
    public static final String METRIC_TILE_RENDERRESULTS = "tile-renderResults";
    public static final String METRIC_TILE_RENDERTREE_LAYER_RESULTSET = "tile-rendertree-layer-resultset";
    public static final String METRIC_TILE_RENDERTREE_STYLEFILTER_ALLDB = "tile-rendertree-stylefilter-alldb";
    public static final String METRIC_TILE_RENDERTREE_STYLEFILTER_ALLDBLESS = "tile-rendertree-stylefilter-alldbless";
    public static final String METRIC_TILE_RENDERTREE_STYLEFILTER_ALLFILTERS = "tile-rendertree-stylefilter-allfilters";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private LinkedHashMap<String, MetricEntry> metrics = new LinkedHashMap();
    private LinkedHashMap<Double, ZoomLevelPerformanceMetrics> zoomLevelPerformanceMetrics = new LinkedHashMap();
    private int parallelThreadCount;

    public PerformanceMetrics(int parallelThreadCount) {
        this.parallelThreadCount = parallelThreadCount;
    }

    public void mergeAllMetrics() {
        for (Map.Entry<Double, ZoomLevelPerformanceMetrics> zoomLevel : this.zoomLevelPerformanceMetrics.entrySet()) {
            ZoomLevelPerformanceMetrics zoomLevelMetric = zoomLevel.getValue();
            for (Map.Entry<String, MetricEntry> entry : zoomLevelMetric.getMetrics().entrySet()) {
                String name = entry.getKey();
                MetricEntry metric = entry.getValue();
                if (!this.metrics.containsKey(name)) {
                    MetricEntry newMetricEntry = new MetricEntry(name);
                    this.metrics.put(name, newMetricEntry);
                }
                MetricEntry threadMetric = this.metrics.get(name);
                threadMetric.add(metric);
            }
        }
    }

    public LinkedHashMap<String, MetricEntry> getMetrics() {
        return this.metrics;
    }

    public ZoomLevelPerformanceMetrics getZoomLevelPerformanceMetric(double zoom) {
        if (!this.zoomLevelPerformanceMetrics.containsKey(zoom)) {
            ZoomLevelPerformanceMetrics newZoomLevelPerformanceMetric = new ZoomLevelPerformanceMetrics(zoom);
            this.zoomLevelPerformanceMetrics.put(zoom, newZoomLevelPerformanceMetric);
        }
        return this.zoomLevelPerformanceMetrics.get(zoom);
    }

    public void logMetrics() {
        this.log.info("logMetrics: start logging zoom levels");
        for (Map.Entry<Double, ZoomLevelPerformanceMetrics> zoomLevel : this.zoomLevelPerformanceMetrics.entrySet()) {
            ZoomLevelPerformanceMetrics zoomLevelMetric = zoomLevel.getValue();
            this.log.info("logMetrics: zoom level " + zoomLevelMetric.getZoom());
            this.logMetricMap(zoomLevelMetric.getMetrics());
        }
        this.log.info("logMetrics: start logging merged data");
        this.logMetricMap(this.metrics);
    }

    private void logMetricMap(LinkedHashMap<String, MetricEntry> metricMap) {
        for (Map.Entry<String, MetricEntry> entry : metricMap.entrySet()) {
            String name = entry.getKey();
            MetricEntry metric = entry.getValue();
            long totalDuration = metric.getTotalDuration();
            double averageDuration = metric.getAverageDuration();
            long callCount = metric.getCallCount();
            String nameString = this.formatStringLength(name, 40);
            String callCountString = this.formatStringLength("#" + callCount, 10);
            String totalDurationString = this.formatStringLength(PerformanceMetrics.formatDuration(totalDuration), 20);
            String averageDurationString = this.formatStringLength(PerformanceMetrics.formatDuration(averageDuration), 20);
            this.log.info("logMetricMap: " + nameString + ": calls=" + callCountString + ", computeTime=" + totalDurationString + ", tileAverage=" + averageDurationString);
        }
    }

    public static String formatDuration(double duration) {
        long hours = (long)(duration / 3.6E12);
        long minutes = (long)(duration / 6.0E10 % 60.0);
        long seconds = (long)(duration / 1.0E9 % 60.0);
        long millis = (long)(duration / 1000000.0 % 1000.0);
        long nanos = (long)(duration % 1000000.0);
        return String.format("%03d:%02d:%02d.%03d.%06d", hours, minutes, seconds, millis, nanos);
    }

    public String formatStringLength(String input, int length) {
        return String.format("%-" + length + "s", input);
    }
}

