/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.math;

import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresPoint;
import de.wideportal.maprender.datasource.osm.PostgresPolygonElement;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import java.util.ArrayList;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;

public class GeoCalculator {
    public static final double EARTH_CIRCUMFENCE_METER = 4.0075016686E7;
    public static final double TILE_PIXEL = 256.0;
    public static final String EPSG_WEBMERCATOR = "3857";
    public static final String EPSG_WSG84_LATLON = "4326";
    private CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    private CRSFactory csFactory = new CRSFactory();
    private CoordinateReferenceSystem latLon = this.csFactory.createFromName("EPSG:4326");
    private CoordinateReferenceSystem webMercator = this.csFactory.createFromName("EPSG:3857");
    private CoordinateTransform transformationLatLonToMercator = this.ctFactory.createTransform(this.latLon, this.webMercator);
    private CoordinateTransform transformationMercatorToLatLon = this.ctFactory.createTransform(this.webMercator, this.latLon);

    public double getDistanceInMeterFromPixel(double startX, double startY, double stopX, double stopY, BoundingBox latLonBoundingBox, double tileSize) {
        double pixelHeight = latLonBoundingBox.getHeight() / tileSize;
        double pixelWidth = latLonBoundingBox.getWidth() / tileSize;
        double startLat = latLonBoundingBox.getLeft() + startX * pixelWidth;
        double startLon = latLonBoundingBox.getTop() + startY * pixelHeight;
        double stopLat = latLonBoundingBox.getLeft() + stopX * pixelWidth;
        double stopLon = latLonBoundingBox.getTop() + stopY * pixelHeight;
        return this.getDistanceInMeterFromLatLon(startLat, startLon, stopLat, stopLon);
    }

    public double getTileWidthInMeterFromLatLon(BoundingBox latLonBoundingBox) {
        return this.getDistanceInMeterFromLatLon(latLonBoundingBox.getLeft(), latLonBoundingBox.getCenter().getY(), latLonBoundingBox.getRight(), latLonBoundingBox.getCenter().getY());
    }

    public double getDistanceInMeterFromLatLon(double startLat, double startLon, double stopLat, double stopLon) {
        startLon = Math.toRadians(startLon);
        stopLon = Math.toRadians(stopLon);
        startLat = Math.toRadians(startLat);
        stopLat = Math.toRadians(stopLat);
        double dlon = stopLon - startLon;
        double dlat = stopLat - startLat;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(startLat) * Math.cos(stopLat) * Math.pow(Math.sin(dlon / 2.0), 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        double r = 6371.0;
        return c * r * 1000.0;
    }

    public BoundingBox convertLatLonToMercator(BoundingBox src) {
        Point mercatorLeftTop = this.convertLatLonToMercator(src.getLeftTop());
        Point mercatorRightBottom = this.convertLatLonToMercator(src.getRightBottom());
        return new BoundingBox(mercatorLeftTop, mercatorRightBottom);
    }

    public BoundingBox convertMercatorToLatLon(BoundingBox src) {
        Point latLonLeftTop = this.convertMercatorToLatLon(src.getLeftTop());
        Point latLonRightBottom = this.convertMercatorToLatLon(src.getRightBottom());
        return new BoundingBox(latLonLeftTop, latLonRightBottom);
    }

    public Point convertLatLonToMercator(Point src) {
        ProjCoordinate p = new ProjCoordinate();
        ProjCoordinate p2 = new ProjCoordinate();
        p.x = src.x;
        p.y = src.y;
        if (p.y > 90.0) {
            p.y = 90.0;
        }
        if (p.y < -89.999999999) {
            p.y = -89.999999999;
        }
        this.transformationLatLonToMercator.transform(p, p2);
        return new Point(p2.x, p2.y);
    }

    public Point convertMercatorToLatLon(Point src) {
        ProjCoordinate p = new ProjCoordinate();
        ProjCoordinate p2 = new ProjCoordinate();
        p.x = src.x;
        p.y = src.y;
        this.transformationMercatorToLatLon.transform(p, p2);
        return new Point(p2.x, p2.y);
    }

    public PostgresLineString convertMercatorToLatLon(PostgresLineString source) {
        PostgresLineString clone = source.clone();
        for (int i = 0; i < clone.getPoints().length; ++i) {
            Point latLonPoint;
            clone.getPoints()[i] = latLonPoint = this.convertMercatorToLatLon(clone.getPoints()[i]);
        }
        return clone;
    }

    public ArrayList<Point> convertMercatorToLatLon(ArrayList<Point> mercatorPoints) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < mercatorPoints.size(); ++i) {
            result.add(this.convertMercatorToLatLon(mercatorPoints.get(i)));
        }
        return result;
    }

    public Point[] convertMercatorToLatLon(Point[] mercatorPoints) {
        Point[] result = new Point[mercatorPoints.length];
        for (int i = 0; i < mercatorPoints.length; ++i) {
            result[i] = this.convertMercatorToLatLon(mercatorPoints[i]);
        }
        return result;
    }

    public PostgresPolygonElement convertMercatorToLatLon(PostgresPolygonElement source) {
        PostgresPolygonElement clone = source.clone();
        for (int i = 0; i < clone.getPoints().length; ++i) {
            Point latLonPoint;
            clone.getPoints()[i] = latLonPoint = this.convertMercatorToLatLon(clone.getPoints()[i]);
        }
        return clone;
    }

    public PostgresPoint convertMercatorToLatLon(PostgresPoint source) {
        PostgresPoint clone = source.clone();
        Point latLonPoint = this.convertMercatorToLatLon(clone.getPoint());
        clone.setPoint(latLonPoint);
        return clone;
    }

    public double getRotation(double x1, double y1, double x2, double y2) {
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        if (xDiff == 0.0 && yDiff == 0.0) {
            return 0.0;
        }
        if (xDiff == 0.0) {
            if (yDiff > 0.0) {
                return 90.0;
            }
            return -90.0;
        }
        if (yDiff == 0.0) {
            if (xDiff > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        if (yDiff < 0.0) {
            double alpha = -90.0 - Math.toDegrees(Math.atan(xDiff / yDiff));
            return alpha;
        }
        double alpha = -270.0 - Math.toDegrees(Math.atan(xDiff / yDiff));
        return alpha;
    }

    public double getNewXLengthAfterRotationToXAxis(double x1, double y1, double x2, double y2) {
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        return Math.sqrt(Math.pow(xDiff, 2.0) + Math.pow(yDiff, 2.0));
    }

    public double getDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }
}

