/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.osm.BoundingBoxCacheKey;
import de.wideportal.maprender.geom.BoundingBox;
import java.sql.ResultSet;
import java.util.Optional;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class PostgresOverCachingCache {
    private CircularFifoQueue<PostgresOverCachingCacheEntry> cache = new CircularFifoQueue(50);

    public synchronized void addToCache(String cachingKeyFromSqlQuery, BoundingBox bbox, ResultSet resultSet) {
        if (cachingKeyFromSqlQuery != null && bbox != null && resultSet != null && !this.isInCache(cachingKeyFromSqlQuery, bbox)) {
            try {
                RowSetFactory factory = RowSetProvider.newFactory();
                CachedRowSet rowset = factory.createCachedRowSet();
                rowset.populate(resultSet);
                BoundingBoxCacheKey bboxCacheKey = new BoundingBoxCacheKey(cachingKeyFromSqlQuery, bbox);
                PostgresOverCachingCacheEntry entry = new PostgresOverCachingCacheEntry(this, bboxCacheKey, rowset);
                this.cache.add((Object)entry);
            }
            catch (Exception e) {
                throw new RuntimeException("addToCache: Could not create Rowset", e);
            }
        }
    }

    public synchronized Optional<ResultSet> getResultSet(String cachingKeyFromSqlQuery, BoundingBox bbox) {
        BoundingBoxCacheKey bboxCacheKey = new BoundingBoxCacheKey(cachingKeyFromSqlQuery, bbox);
        for (PostgresOverCachingCacheEntry entry : this.cache) {
            if (!entry.getKey().equals(bboxCacheKey)) continue;
            try {
                RowSetFactory factory = RowSetProvider.newFactory();
                CachedRowSet rowset = factory.createCachedRowSet();
                rowset.populate(entry.getValue());
                entry.getValue().beforeFirst();
                return Optional.ofNullable(rowset);
            }
            catch (Exception e) {
                throw new RuntimeException("addToCache: Could not create Rowset", e);
            }
        }
        return Optional.empty();
    }

    public boolean isInCache(String cachingKeyFromSqlQuery, BoundingBox bbox) {
        if (cachingKeyFromSqlQuery != null && bbox != null) {
            BoundingBoxCacheKey bboxCacheKey = new BoundingBoxCacheKey(cachingKeyFromSqlQuery, bbox);
            for (PostgresOverCachingCacheEntry entry : this.cache) {
                if (!entry.getKey().equals(bboxCacheKey)) continue;
                return true;
            }
        }
        return false;
    }

    public class PostgresOverCachingCacheEntry {
        private BoundingBoxCacheKey key;
        private ResultSet value;

        public PostgresOverCachingCacheEntry(PostgresOverCachingCache this$0, BoundingBoxCacheKey key, ResultSet value) {
            this.key = key;
            this.value = value;
        }

        public BoundingBoxCacheKey getKey() {
            return this.key;
        }

        public ResultSet getValue() {
            return this.value;
        }
    }
}

