/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.dbcache;

import de.wideportal.maprender.datasource.dbcache.DBCacheLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCache
extends FileAccessor
implements Serializable {
    private static final long serialVersionUID = 344343511639188639L;
    protected static Logger log = LoggerFactory.getLogger(DBCache.class);
    protected static FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    private LinkedHashMap<String, DBCacheLayer> cacheLayers = new LinkedHashMap();

    public void addCacheLayer(DBCacheLayer layer) {
        this.cacheLayers.put(layer.getLayerName(), layer);
    }

    public DBCacheLayer getCacheLayer(String layerName) {
        return this.cacheLayers.get(layerName);
    }

    public void persist(RenderRequest renderRequest) {
        String baseFolder = renderRequest.getOsmMap().getJob().getOutput().getDbCache().getFolder();
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        String fileType = "dbcache";
        String folder = this.getFolderName(baseFolder, zoom, xIndex, true);
        if (folder == null) {
            log.error("persist: folder is not accessible. Cannot save db cache. Folder is: " + folder);
            return;
        }
        String yFileName = yIndex + "." + fileType;
        String yFilePath = folder + "/" + yFileName;
        File yFile = new File(yFilePath);
        if (yFile.exists()) {
            yFile.delete();
            log.debug("persist: deleted old db cache: " + yFile.getAbsolutePath());
        }
        try (FileOutputStream fout = new FileOutputStream(yFile);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry(yFileName);
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)this, new Class[]{DBCache.class});
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public static DBCache load(RenderRequest renderRequest) {
        String baseFolder = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getDbCache().getFolder();
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        String fileType = "dbcache";
        DBCache result = new DBCache();
        String folder = result.getFolderName(baseFolder, zoom, xIndex, true);
        if (folder == null) {
            log.error("load: folder is not accessible. Cannot load db cache. Folder is: " + folder);
            return null;
        }
        String yFileName = folder + "/" + yIndex + "." + fileType;
        File yFile = new File(yFileName);
        try (FileInputStream fis = new FileInputStream(yFile);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry innerFile = zis.getNextEntry();
            if (innerFile != null) {
                FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                result = (DBCache)ois.readObject(new Class[]{DBCache.class});
                ois.close();
            }
        }
        catch (Exception e) {
            log.error("load: could not load from file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
        return result;
    }
}

