/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource;

import de.wideportal.maprender.datasource.IRenderDatasource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceRequest {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private PreparedStatement pStatement;
    private ResultSet resultSet;
    private Optional<Connection> connection;

    public DatasourceRequest(IRenderDatasource datasource) {
        this.connection = datasource.getConnection();
    }

    public Optional<Connection> getConnection() {
        return this.connection;
    }

    public Optional<ResultSet> createResultSet(String query) {
        this.log.debug("createResultSet: " + query);
        Optional<ResultSet> result = Optional.empty();
        if (this.connection.isPresent()) {
            Connection con = this.connection.get();
            try {
                query = this.escapeQueryForPreparedStatement(query);
                this.pStatement = con.prepareStatement(query, 1004, 1007);
                this.pStatement.setFetchSize(1000);
                this.resultSet = this.pStatement.executeQuery();
                result = Optional.ofNullable(this.resultSet);
            }
            catch (SQLException e) {
                this.log.error("createResultSet: Error during executing query: " + query, (Throwable)e);
                try {
                    con.rollback();
                }
                catch (SQLException e1) {
                    this.log.error("createResultSet: could not rollback query: " + query, (Throwable)e);
                }
                throw new RuntimeException("createResultSet: could not create resultset");
            }
        }
        this.log.warn("createResultSet: no connection");
        throw new RuntimeException("createResultSet: could not create resultset because no connection was available");
        this.log.debug("createResultSet: returning result: " + result);
        return result;
    }

    public void closeResultSet(ResultSet resultSet) {
        this.log.debug("closeResultSet: " + resultSet);
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                this.log.error("closeResultSet: Error during closing of ResultSet", (Throwable)e);
            }
            try {
                this.pStatement.close();
            }
            catch (SQLException e) {
                this.log.error("closeResultSet: Error during closing of Statement", (Throwable)e);
            }
        }
    }

    public void releaseConnection() {
        if (this.connection.isPresent()) {
            try {
                this.connection.get().close();
            }
            catch (SQLException ex) {
                this.log.error("releaseConnection: could not release connection", (Throwable)ex);
            }
        }
    }

    private String escapeQueryForPreparedStatement(String query) {
        return query.replaceAll("\\?", "??");
    }
}

