/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.compop;

import de.wideportal.maprender.config.xml.osm.compop.OsmStyleImageCompOpCutOutOpacity;
import de.wideportal.maprender.config.xml.osm.compop.OsmStyleImageCompOpDarken;
import de.wideportal.maprender.config.xml.osm.compop.OsmStyleImageCompOpInvertOpacity;
import de.wideportal.maprender.config.xml.osm.compop.OsmStyleImageCompOpOpacityToHSL;
import de.wideportal.maprender.request.RenderImageLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOsmStyleImageCompOp {
    private static Logger log = LoggerFactory.getLogger(AbstractOsmStyleImageCompOp.class);

    public abstract boolean applyCompOp(RenderImageLayer var1, RenderImageLayer var2);

    public static AbstractOsmStyleImageCompOp parse(String compOpString) {
        if (compOpString != null) {
            if (compOpString.equalsIgnoreCase("darken")) {
                return new OsmStyleImageCompOpDarken();
            }
            if (compOpString.startsWith("opacityToHSL")) {
                return new OsmStyleImageCompOpOpacityToHSL(compOpString);
            }
            if (compOpString.startsWith("invertOpacity")) {
                return new OsmStyleImageCompOpInvertOpacity(compOpString);
            }
            if (compOpString.startsWith("cutOutOpacity")) {
                return new OsmStyleImageCompOpCutOutOpacity(compOpString);
            }
        }
        return null;
    }
}

