/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmDatasource;
import de.wideportal.maprender.config.xml.osm.OsmLayer;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.OsmStyleName;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OsmLayerAccessor
extends BaseAccessor {
    private Optional<Double> cachedMinScaleDenominator = null;
    private Optional<Double> cachedMaxScaleDenominator = null;
    private Optional<Integer> cachedOverCaching = null;
    private OsmLayer osmLayer;

    public OsmLayerAccessor(OsmLayer osmLayer) {
        this.osmLayer = osmLayer;
    }

    public OsmLayer getOsmLayer() {
        return this.osmLayer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmLayer.getIdentifier());
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.osmLayer.getName());
    }

    public Optional<String> getSrs() {
        return Optional.ofNullable(this.osmLayer.getSrs());
    }

    public List<OsmStyleName> getStyleNames() {
        List<OsmStyleName> styleNames = this.osmLayer.getStyleNames();
        if (styleNames == null) {
            styleNames = new ArrayList<OsmStyleName>();
            this.osmLayer.setStyleNames(styleNames);
        }
        return styleNames;
    }

    public Optional<OsmDatasource> getDatasource() {
        return Optional.ofNullable(this.osmLayer.getDatasource());
    }

    public List<OsmStyle> getStyles() {
        List<OsmStyle> styles = this.osmLayer.getStyles();
        if (styles == null) {
            styles = new ArrayList<OsmStyle>();
            this.osmLayer.setStyles(styles);
        }
        return styles;
    }

    public Optional<Double> getMinimumScaleDenominator() {
        if (this.cachedMinScaleDenominator == null) {
            this.cachedMinScaleDenominator = this.safeParseDouble(this.osmLayer.getMinimumScaleDenominator());
        }
        return this.cachedMinScaleDenominator;
    }

    public Optional<Double> getMaximumScaleDenominator() {
        if (this.cachedMaxScaleDenominator == null) {
            this.cachedMaxScaleDenominator = this.safeParseDouble(this.osmLayer.getMaximumScaleDenominator());
        }
        return this.cachedMaxScaleDenominator;
    }

    public Optional<String> getGroupBy() {
        return Optional.ofNullable(this.osmLayer.getGroupBy());
    }

    public Optional<Integer> getOverCaching() {
        if (this.cachedOverCaching == null) {
            this.cachedOverCaching = this.safeParseInteger(this.osmLayer.getOverCaching());
        }
        return this.cachedOverCaching;
    }

    public boolean hasCollisionElements() {
        return this.osmLayer.hasCollisionElements();
    }

    public String toString() {
        return "OsmLayerAccessor[" + this.osmLayer + "]";
    }
}

