/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmKmlSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmKmlSymbolizerAccessor
extends BaseAccessor {
    public static final double DEFAULT_ADJUST_WIDTH = 0.0;
    public static final boolean DEFAULT_SHADOW = false;
    public static final Color DEFAULT_SHADOW_COLOR = Color.BLACK;
    public static final int DEFAULT_SHADOW_DIRECTION = 135;
    public static final int DEFAULT_SHADOW_OFFSET = 3;
    public static final int DEFAULT_SHADOW_RADIUS = 5;
    public static final Color DEFAULT_FILL = new Color(0, 0, 0, 0);
    public static final float DEFAULT_OPACITY = 1.0f;
    private OsmKmlSymbolizer osmKmlSymbolizer;
    private Double cachedAdjustWidth = null;
    private Boolean cachedShadow = null;
    private Color cachedShadowColor = null;
    private Integer cachedShadowDirection = null;
    private Integer cachedShadowOffset = null;
    private Integer cachedShadowRadius = null;
    private Color cachedFill = null;
    private Float cachedFillOpacity = null;

    public OsmKmlSymbolizerAccessor(OsmKmlSymbolizer osmKmlSymbolizer) {
        this.osmKmlSymbolizer = osmKmlSymbolizer;
    }

    public OsmKmlSymbolizer getSymbolizer() {
        return this.osmKmlSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmKmlSymbolizer.getIdentifier());
    }

    public Optional<String> getFile() {
        return Optional.ofNullable(this.osmKmlSymbolizer.getFile());
    }

    public Double getAdjustWidth() {
        if (this.cachedAdjustWidth == null) {
            this.cachedAdjustWidth = this.getFromOptionalOrElse(this.safeParseDouble(this.osmKmlSymbolizer.getAdjustWidth()), 0.0);
        }
        return this.cachedAdjustWidth;
    }

    public Boolean getShadow() {
        if (this.cachedShadow == null) {
            this.cachedShadow = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmKmlSymbolizer.getShadow()), false);
        }
        return this.cachedShadow;
    }

    public Color getShadowColor() {
        if (this.cachedShadowColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmKmlSymbolizer.getShadowColor());
            this.cachedShadowColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_SHADOW_COLOR;
        }
        return this.cachedShadowColor;
    }

    public Integer getShadowDirection() {
        if (this.cachedShadowDirection == null) {
            this.cachedShadowDirection = this.getFromOptionalOrElse(this.safeParseInteger(this.osmKmlSymbolizer.getShadowDirection()), 135);
        }
        return this.cachedShadowDirection;
    }

    public Integer getShadowOffset() {
        if (this.cachedShadowOffset == null) {
            this.cachedShadowOffset = this.getFromOptionalOrElse(this.safeParseInteger(this.osmKmlSymbolizer.getShadowOffset()), 3);
        }
        return this.cachedShadowOffset;
    }

    public Integer getShadowRadius() {
        if (this.cachedShadowRadius == null) {
            this.cachedShadowRadius = this.getFromOptionalOrElse(this.safeParseInteger(this.osmKmlSymbolizer.getShadowRadius()), 5);
        }
        return this.cachedShadowRadius;
    }

    public Float getFillOpacity() {
        if (this.cachedFillOpacity == null) {
            this.cachedFillOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmKmlSymbolizer.getFillOpacity()), 1.0f);
        }
        return this.cachedFillOpacity;
    }

    public Color getFill() {
        if (this.cachedFill == null) {
            Optional<String> optionalFill = this.safeGetNonEmptyString(this.osmKmlSymbolizer.getFill());
            this.cachedFill = optionalFill.isPresent() ? ColorUtil.getColorFromString(optionalFill.get()) : DEFAULT_FILL;
        }
        return this.cachedFill;
    }

    public String toString() {
        return "OsmKmlSymbolizerAccessor[" + this.osmKmlSymbolizer + "]";
    }
}

