/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightProfileSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightProfileSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_HEIGHT_MIN = -12000.0;
    public static final Double DEFAULT_HEIGHT_MAX = 9000.0;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final Float DEFAULT_SHADOW_IMPACT = Float.valueOf(100.0f);
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    public static final Integer DEFAULT_FLATTEN_NOISE = 0;
    public static final Integer DEFAULT_FLATTEN_POINT_NOISE = 0;
    public static final Integer DEFAULT_EXPENSIVE_BLUR = 0;
    private OsmHeightProfileSymbolizer osmHeightProfileSymbolizer;
    private Double cachedHeightMin = null;
    private Double cachedHeightMax = null;
    private Color cachedColor = null;
    private Float cachedShadowImpact = null;
    private Boolean cachedRenderMockTiles = null;
    private Integer cachedFlattenNoise = null;
    private Integer cachedFlattenPointNoise = null;
    private Integer cachedExpensiveBlur = null;

    public OsmHeightProfileSymbolizerAccessor(OsmHeightProfileSymbolizer osmHeightProfileSymbolizer) {
        this.osmHeightProfileSymbolizer = osmHeightProfileSymbolizer;
    }

    public OsmHeightProfileSymbolizer getOsmHeightProfileSymbolizer() {
        return this.osmHeightProfileSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightProfileSymbolizer.getIdentifier());
    }

    public Float getShadowImpact() {
        if (this.cachedShadowImpact == null) {
            this.cachedShadowImpact = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightProfileSymbolizer.getShadowImpact()), DEFAULT_SHADOW_IMPACT.floatValue());
        }
        return this.cachedShadowImpact;
    }

    public Double getHeightMin() {
        if (this.cachedHeightMin == null) {
            this.cachedHeightMin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightProfileSymbolizer.getHeightMin()), DEFAULT_HEIGHT_MIN);
        }
        return this.cachedHeightMin;
    }

    public Double getHeightMax() {
        if (this.cachedHeightMax == null) {
            this.cachedHeightMax = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightProfileSymbolizer.getHeightMax()), DEFAULT_HEIGHT_MAX);
        }
        return this.cachedHeightMax;
    }

    public Integer getFlattenNoise() {
        if (this.cachedFlattenNoise == null) {
            this.cachedFlattenNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightProfileSymbolizer.getFlattenNoise()), DEFAULT_FLATTEN_NOISE);
        }
        return this.cachedFlattenNoise;
    }

    public Integer getFlattenPointNoise() {
        if (this.cachedFlattenPointNoise == null) {
            this.cachedFlattenPointNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightProfileSymbolizer.getFlattenPointNoise()), DEFAULT_FLATTEN_POINT_NOISE);
        }
        return this.cachedFlattenPointNoise;
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightProfileSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightProfileSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public Integer getExpensiveBlur() {
        if (this.cachedExpensiveBlur == null) {
            this.cachedExpensiveBlur = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightProfileSymbolizer.getExpensiveBlur()), DEFAULT_EXPENSIVE_BLUR);
        }
        return this.cachedExpensiveBlur;
    }

    public String toString() {
        return "OsmHeightProfileSymbolizerAccessor[" + this.osmHeightProfileSymbolizer + "]";
    }
}

