/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightLinesSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightLinesSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_HEIGHT_MIN = -12000.0;
    public static final Double DEFAULT_HEIGHT_MAX = 9000.0;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    public static final Integer DEFAULT_FLATTEN_NOISE = 0;
    public static final Integer DEFAULT_FLATTEN_POINT_NOISE = 0;
    public static final Integer DEFAULT_LINES_SPACING = 100;
    public static final Integer DEFAULT_LINES_MAJOR = 5;
    public static final Float DEFAULT_LINES_WIDTH = Float.valueOf(1.0f);
    public static final Float DEFAULT_LINES_WIDTH_MAJOR = Float.valueOf(2.0f);
    public static final Integer DEFAULT_EXPENSIVE_BLUR = 0;
    public static final double DEFAULT_SPACING = 0.0;
    public static final Color DEFAULT_HALO_FILL = Color.WHITE;
    public static final float DEFAULT_HALO_RADIUS = 0.0f;
    public static final double DEFAULT_REPEAT_DISTANCE = 0.0;
    public static final double DEFAULT_SIZE = 10.0;
    public static final Boolean DEFAULT_RENDER_TEXT = true;
    public static final String DEFAULT_SKIP_HEIGHTS = "";
    public static final Integer DEFAULT_DELETE_SMALL_CYCLIC_LINES = 1;
    private OsmHeightLinesSymbolizer osmHeightLinesSymbolizer;
    private Double cachedHeightMin = null;
    private Double cachedHeightMax = null;
    private Color cachedColor = null;
    private Boolean cachedRenderMockTiles = null;
    private Integer cachedFlattenNoise = null;
    private Integer cachedFlattenPointNoise = null;
    private Integer cachedLinesSpacing = null;
    private Integer cachedLinesMajor = null;
    private Float cachedLinesWidth = null;
    private Float cachedLinesWidthMajor = null;
    private Integer cachedExpensiveBlur = null;
    private Double cachedSpacing = null;
    private Color cachedHaloFill = null;
    private Float cachedHaloRadius = null;
    private Double cachedRepeatDistance = null;
    private Double cachedSize = null;
    private Boolean cachedRenderText = null;
    private String cachedSkipHeights = null;
    private Double simplifyDistanceTolerance = null;
    private Integer splinePointsPerSegment = null;
    private Integer cachedDeleteSmallCyclicLines = null;

    public OsmHeightLinesSymbolizerAccessor(OsmHeightLinesSymbolizer osmHeightLinesSymbolizer) {
        this.osmHeightLinesSymbolizer = osmHeightLinesSymbolizer;
    }

    public OsmHeightLinesSymbolizer getOsmHeightLinesSymbolizer() {
        return this.osmHeightLinesSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightLinesSymbolizer.getIdentifier());
    }

    public String getSkipHeights() {
        if (this.cachedSkipHeights == null) {
            this.cachedSkipHeights = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmHeightLinesSymbolizer.getSkipHeights()), DEFAULT_SKIP_HEIGHTS);
        }
        return this.cachedSkipHeights;
    }

    public Double getHeightMin() {
        if (this.cachedHeightMin == null) {
            this.cachedHeightMin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightLinesSymbolizer.getHeightMin()), DEFAULT_HEIGHT_MIN);
        }
        return this.cachedHeightMin;
    }

    public Double getHeightMax() {
        if (this.cachedHeightMax == null) {
            this.cachedHeightMax = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightLinesSymbolizer.getHeightMax()), DEFAULT_HEIGHT_MAX);
        }
        return this.cachedHeightMax;
    }

    public Integer getFlattenNoise() {
        if (this.cachedFlattenNoise == null) {
            this.cachedFlattenNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getFlattenNoise()), DEFAULT_FLATTEN_NOISE);
        }
        return this.cachedFlattenNoise;
    }

    public Integer getFlattenPointNoise() {
        if (this.cachedFlattenPointNoise == null) {
            this.cachedFlattenPointNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getFlattenPointNoise()), DEFAULT_FLATTEN_POINT_NOISE);
        }
        return this.cachedFlattenPointNoise;
    }

    public Integer getLinesSpacing() {
        if (this.cachedLinesSpacing == null) {
            this.cachedLinesSpacing = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getLinesSpacing()), DEFAULT_LINES_SPACING);
        }
        return this.cachedLinesSpacing;
    }

    public Integer getLinesMajor() {
        if (this.cachedLinesMajor == null) {
            this.cachedLinesMajor = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getLinesMajor()), DEFAULT_LINES_MAJOR);
        }
        return this.cachedLinesMajor;
    }

    public Integer getDeleteSmallCyclicLines() {
        if (this.cachedDeleteSmallCyclicLines == null) {
            this.cachedDeleteSmallCyclicLines = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getDeleteSmallCyclicLines()), DEFAULT_DELETE_SMALL_CYCLIC_LINES);
        }
        return this.cachedDeleteSmallCyclicLines;
    }

    public Float getLinesWidth() {
        if (this.cachedLinesWidth == null) {
            this.cachedLinesWidth = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightLinesSymbolizer.getLinesWidth()), DEFAULT_LINES_WIDTH.floatValue());
        }
        return this.cachedLinesWidth;
    }

    public Float getLinesWidthMajor() {
        if (this.cachedLinesWidthMajor == null) {
            this.cachedLinesWidthMajor = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightLinesSymbolizer.getLinesWidthMajor()), DEFAULT_LINES_WIDTH_MAJOR.floatValue());
        }
        return this.cachedLinesWidthMajor;
    }

    public Optional<Integer> getSplinePointsPerSegment() {
        if (this.splinePointsPerSegment == null) {
            Optional<Integer> optionalSplinePointsPerSegment = this.safeParseInteger(this.osmHeightLinesSymbolizer.getSplinePointsPerSegment());
            return optionalSplinePointsPerSegment;
        }
        return Optional.ofNullable(this.splinePointsPerSegment);
    }

    public Optional<Double> getSimplifyDistanceTolerance() {
        if (this.simplifyDistanceTolerance == null) {
            Optional<Double> optionalSimplifyDistanceTolerance = this.safeParseDouble(this.osmHeightLinesSymbolizer.getSimplifyDistanceTolerance());
            return optionalSimplifyDistanceTolerance;
        }
        return Optional.ofNullable(this.simplifyDistanceTolerance);
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightLinesSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightLinesSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public Boolean getRenderText() {
        if (this.cachedRenderText == null) {
            this.cachedRenderText = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightLinesSymbolizer.getRenderText()), DEFAULT_RENDER_TEXT);
        }
        return this.cachedRenderText;
    }

    public Integer getExpensiveBlur() {
        if (this.cachedExpensiveBlur == null) {
            this.cachedExpensiveBlur = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightLinesSymbolizer.getExpensiveBlur()), DEFAULT_EXPENSIVE_BLUR);
        }
        return this.cachedExpensiveBlur;
    }

    public Double getSpacing() {
        if (this.cachedSpacing == null) {
            this.cachedSpacing = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightLinesSymbolizer.getSpacing()), 0.0);
        }
        return this.cachedSpacing;
    }

    public Color getHaloFill() {
        if (this.cachedHaloFill == null) {
            Optional<String> optionalHaloFill = this.safeGetNonEmptyString(this.osmHeightLinesSymbolizer.getHaloFill());
            this.cachedHaloFill = optionalHaloFill.isPresent() ? ColorUtil.getColorFromString(optionalHaloFill.get()) : DEFAULT_HALO_FILL;
        }
        return this.cachedHaloFill;
    }

    public Float getHaloRadius() {
        if (this.cachedHaloRadius == null) {
            this.cachedHaloRadius = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightLinesSymbolizer.getHaloRadius()), 0.0f);
        }
        return this.cachedHaloRadius;
    }

    public Double getRepeatDistance() {
        if (this.cachedRepeatDistance == null) {
            this.cachedRepeatDistance = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightLinesSymbolizer.getRepeatDistance()), 0.0);
        }
        return this.cachedRepeatDistance;
    }

    public Optional<String> getFontsetName() {
        return Optional.ofNullable(this.osmHeightLinesSymbolizer.getFontsetName());
    }

    public Double getSize() {
        if (this.cachedSize == null) {
            this.cachedSize = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightLinesSymbolizer.getSize()), 10.0);
        }
        return this.cachedSize;
    }

    public String toString() {
        return "OsmHeightLinesSymbolizerAccessor[" + this.osmHeightLinesSymbolizer + "]";
    }
}

