/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.Logging;

public class MultiFetchOverpassObjectReader
extends MultiFetchServerObjectReader {
    private static String getPackageString(OsmPrimitiveType type, Set<Long> idPackage) {
        return idPackage.stream().map(String::valueOf).collect(Collectors.joining(",", type.getAPIName() + (idPackage.size() == 1 ? "(" : "(id:"), ");"));
    }

    protected String buildComplexRequestString() {
        StringBuilder sb = new StringBuilder();
        int countTypes = 0;
        for (Map.Entry e : this.primitivesMap.entrySet()) {
            if (((Set)e.getValue()).isEmpty()) continue;
            ++countTypes;
            String list = MultiFetchOverpassObjectReader.getPackageString((OsmPrimitiveType)((Object)e.getKey()), (Set)e.getValue());
            switch ((OsmPrimitiveType)((Object)e.getKey())) {
                case MULTIPOLYGON: 
                case RELATION: {
                    sb.append(list);
                    if (!this.recurseDownRelations) break;
                    sb.append(">>;");
                    break;
                }
                case CLOSEDWAY: 
                case WAY: {
                    sb.append('(').append(list).append(">;);");
                    break;
                }
                case NODE: {
                    sb.append(list);
                }
            }
        }
        String query = sb.toString();
        if (countTypes > 1) {
            query = "(" + query + ");";
        }
        query = query + "out meta;";
        Logging.debug("{0} {1}", "Generated Overpass query:", query);
        return query;
    }

    @Override
    protected String getBaseUrl() {
        return OverpassDownloadReader.OVERPASS_SERVER.get();
    }
}

