/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class DataSetMerger {
    private final ConflictCollection conflicts;
    private final DataSet targetDataSet;
    private final DataSet sourceDataSet;
    private final Map<PrimitiveId, PrimitiveId> mergedMap;
    private final Set<PrimitiveId> objectsWithChildrenToMerge;
    private final Set<OsmPrimitive> objectsToDelete;

    public DataSetMerger(DataSet targetDataSet, DataSet sourceDataSet) {
        CheckParameterUtil.ensureParameterNotNull(targetDataSet, "targetDataSet");
        this.targetDataSet = targetDataSet;
        this.sourceDataSet = sourceDataSet;
        this.conflicts = new ConflictCollection();
        this.mergedMap = new HashMap<PrimitiveId, PrimitiveId>();
        this.objectsWithChildrenToMerge = new HashSet<PrimitiveId>();
        this.objectsToDelete = new HashSet<OsmPrimitive>();
    }

    protected void mergePrimitive(OsmPrimitive source, Collection<? extends OsmPrimitive> candidates) {
        OsmPrimitive target;
        if (!source.isNew()) {
            if (this.mergeById(source)) {
                return;
            }
        } else {
            if (source.isDeleted()) {
                return;
            }
            for (OsmPrimitive osmPrimitive : candidates) {
                if (!osmPrimitive.isNew() || osmPrimitive.isDeleted() || !osmPrimitive.hasEqualSemanticAttributes(source)) continue;
                this.mergedMap.put(source.getPrimitiveId(), osmPrimitive.getPrimitiveId());
                osmPrimitive.setVisible(source.isVisible());
                osmPrimitive.setUser(source.getUser());
                osmPrimitive.setRawTimestamp(source.getRawTimestamp());
                osmPrimitive.setModified(source.isModified());
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
                return;
            }
        }
        switch (source.getType()) {
            case NODE: {
                target = source.isNew() ? new Node() : new Node(source.getId());
                break;
            }
            case WAY: {
                target = source.isNew() ? new Way() : new Way(source.getId());
                break;
            }
            case RELATION: {
                target = source.isNew() ? new Relation() : new Relation(source.getId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        target.mergeFrom(source);
        this.targetDataSet.addPrimitive(target);
        this.mergedMap.put(source.getPrimitiveId(), target.getPrimitiveId());
        this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
    }

    protected OsmPrimitive getMergeTarget(OsmPrimitive mergeSource) {
        PrimitiveId targetId = this.mergedMap.get(mergeSource.getPrimitiveId());
        if (targetId == null) {
            return null;
        }
        return this.targetDataSet.getPrimitiveById(targetId);
    }

    protected void addConflict(Conflict<?> c) {
        c.setMergedMap(this.mergedMap);
        this.conflicts.add(c);
    }

    protected void addConflict(OsmPrimitive my, OsmPrimitive their) {
        this.addConflict(new Conflict<OsmPrimitive>(my, their));
    }

    protected void fixIncomplete(Way other) {
        Way myWay = (Way)this.getMergeTarget(other);
        if (myWay == null) {
            throw new JosmRuntimeException(I18n.tr("Missing merge target for way with id {0}", other.getUniqueId()));
        }
    }

    public void fixReferences() {
        for (Way w : this.sourceDataSet.getWays()) {
            if (this.conflicts.hasConflictForTheir(w) || !this.objectsWithChildrenToMerge.contains(w.getPrimitiveId())) continue;
            this.mergeNodeList(w);
            this.fixIncomplete(w);
        }
        for (Relation r : this.sourceDataSet.getRelations()) {
            if (this.conflicts.hasConflictForTheir(r) || !this.objectsWithChildrenToMerge.contains(r.getPrimitiveId())) continue;
            this.mergeRelationMembers(r);
        }
        this.deleteMarkedObjects();
    }

    protected void deleteMarkedObjects() {
        boolean flag;
        do {
            flag = false;
            Iterator<OsmPrimitive> it = this.objectsToDelete.iterator();
            block1: while (it.hasNext()) {
                OsmPrimitive target = it.next();
                OsmPrimitive source = this.sourceDataSet.getPrimitiveById(target.getPrimitiveId());
                if (source == null) {
                    throw new JosmRuntimeException(I18n.tr("Object of type {0} with id {1} was marked to be deleted, but it''s missing in the source dataset", new Object[]{target.getType(), target.getUniqueId()}));
                }
                List<OsmPrimitive> referrers = target.getReferrers();
                if (referrers.isEmpty()) {
                    DataSetMerger.resetPrimitive(target);
                    target.mergeFrom(source);
                    target.setDeleted(true);
                    it.remove();
                    flag = true;
                    continue;
                }
                for (OsmPrimitive referrer : referrers) {
                    if (this.objectsToDelete.contains(referrer)) continue;
                    this.addConflict(target, source);
                    it.remove();
                    flag = true;
                    continue block1;
                }
            }
        } while (flag);
        if (!this.objectsToDelete.isEmpty()) {
            for (OsmPrimitive osm : this.objectsToDelete) {
                DataSetMerger.resetPrimitive(osm);
            }
            for (OsmPrimitive osm : this.objectsToDelete) {
                osm.setDeleted(true);
                osm.mergeFrom(this.sourceDataSet.getPrimitiveById(osm.getPrimitiveId()));
            }
        }
    }

    private static void resetPrimitive(OsmPrimitive osm) {
        if (osm instanceof Way) {
            ((Way)osm).setNodes((List<Node>)null);
        } else if (osm instanceof Relation) {
            ((Relation)osm).setMembers((List<RelationMember>)null);
        }
    }

    private void mergeNodeList(Way source) {
        Way target = (Way)this.getMergeTarget(source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for way with id {0}", source.getUniqueId()));
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(source.getNodesCount());
        for (Node sourceNode : source.getNodes()) {
            Node targetNode = (Node)this.getMergeTarget(sourceNode);
            if (targetNode != null) {
                newNodes.add(targetNode);
                if (!targetNode.isDeleted() || this.conflicts.hasConflictForMy(targetNode)) continue;
                this.addConflict(new Conflict<Node>(targetNode, sourceNode, true));
                targetNode.setDeleted(false);
                continue;
            }
            throw new IllegalStateException(I18n.tr("Missing merge target for node with id {0}", sourceNode.getUniqueId()));
        }
        target.setNodes((List<Node>)newNodes);
    }

    private void mergeRelationMembers(Relation source) {
        Relation target = (Relation)this.getMergeTarget(source);
        if (target == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for relation with id {0}", source.getUniqueId()));
        }
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember sourceMember : source.getMembers()) {
            OsmPrimitive targetMember = this.getMergeTarget(sourceMember.getMember());
            if (targetMember == null) {
                throw new IllegalStateException(I18n.tr("Missing merge target of type {0} with id {1}", new Object[]{sourceMember.getType(), sourceMember.getUniqueId()}));
            }
            newMembers.add(new RelationMember(sourceMember.getRole(), targetMember));
            if (!targetMember.isDeleted() || this.conflicts.hasConflictForMy(targetMember)) continue;
            this.addConflict(new Conflict<OsmPrimitive>(targetMember, sourceMember.getMember(), true));
            targetMember.setDeleted(false);
        }
        target.setMembers((List<RelationMember>)newMembers);
    }

    private boolean mergeById(OsmPrimitive source) {
        OsmPrimitive target = (OsmPrimitive)this.targetDataSet.getPrimitiveById(source.getId(), source.getType());
        if (target == null) {
            return false;
        }
        this.mergedMap.put(source.getPrimitiveId(), target.getPrimitiveId());
        if (target.getVersion() > source.getVersion()) {
            return true;
        }
        if (target.isIncomplete() && !source.isIncomplete()) {
            target.mergeFrom(source);
            this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
        } else if (!(!target.isIncomplete() && source.isIncomplete() || target.isIncomplete() && source.isIncomplete())) {
            if (!target.isModified() && !source.isModified() && target.isVisible() != source.isVisible() && target.getVersion() == source.getVersion()) {
                throw new DataIntegrityProblemException(I18n.tr("Conflict in ''visible'' attribute for object of type {0} with id {1}", new Object[]{target.getType(), target.getId()}));
            }
            if (target.isDeleted() && !source.isDeleted() && target.getVersion() == source.getVersion()) {
                if (source.isModified()) {
                    this.addConflict(new Conflict<OsmPrimitive>(target, source, true));
                }
                for (OsmPrimitive referrer : source.getReferrers()) {
                    if (this.targetDataSet.getPrimitiveById(referrer.getPrimitiveId()) != null) continue;
                    this.addConflict(new Conflict<OsmPrimitive>(target, source, true));
                    target.setDeleted(false);
                    break;
                }
            } else if (!target.isModified() && source.isDeleted()) {
                this.objectsToDelete.add(target);
            } else if (!target.isModified() && source.isModified()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (!target.isModified() && !source.isModified() && target.getVersion() == source.getVersion()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (!target.isModified() && !source.isModified() && target.getVersion() < source.getVersion()) {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            } else if (target.isModified() && !source.isModified() && target.getVersion() == source.getVersion()) {
                if (target.hasEqualSemanticAttributes(source, false)) {
                    target.setModified(false);
                }
            } else if (source.isDeleted() != target.isDeleted()) {
                this.addConflict(target, source);
            } else if (!target.hasEqualSemanticAttributes(source)) {
                this.addConflict(target, source);
            } else {
                target.mergeFrom(source);
                this.objectsWithChildrenToMerge.add(source.getPrimitiveId());
            }
        }
        return true;
    }

    public void merge() {
        this.merge(null);
    }

    public void merge(ProgressMonitor progressMonitor) {
        this.merge(progressMonitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ProgressMonitor progressMonitor, boolean mergeBounds) {
        if (this.sourceDataSet == null) {
            return;
        }
        if (progressMonitor != null) {
            progressMonitor.beginTask(I18n.tr("Merging data...", new Object[0]), this.sourceDataSet.allPrimitives().size());
        }
        this.targetDataSet.beginUpdate();
        try {
            ArrayList<OsmPrimitive> candidates = new ArrayList<Node>(this.targetDataSet.getNodes());
            for (Node node : this.sourceDataSet.getNodes()) {
                this.mergePrimitive(node, candidates);
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
            candidates.clear();
            candidates = new ArrayList<Way>(this.targetDataSet.getWays());
            for (Way way : this.sourceDataSet.getWays()) {
                this.mergePrimitive(way, candidates);
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
            candidates.clear();
            candidates = new ArrayList<Relation>(this.targetDataSet.getRelations());
            for (Relation relation : this.sourceDataSet.getRelations()) {
                this.mergePrimitive(relation, candidates);
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
            candidates.clear();
            this.fixReferences();
            Area a = this.targetDataSet.getDataSourceArea();
            if (mergeBounds) {
                for (DataSource src : this.sourceDataSet.getDataSources()) {
                    if (a != null && a.contains(src.bounds.asRect())) continue;
                    this.targetDataSet.addDataSource(src);
                }
            }
            if (this.targetDataSet.getVersion() == null) {
                this.targetDataSet.setVersion(this.sourceDataSet.getVersion());
            }
            if (this.sourceDataSet.getUploadPolicy() != null && (this.targetDataSet.getUploadPolicy() == null || this.sourceDataSet.getUploadPolicy().compareTo(this.targetDataSet.getUploadPolicy()) > 0)) {
                this.targetDataSet.setUploadPolicy(this.sourceDataSet.getUploadPolicy());
            }
            if (this.sourceDataSet.getDownloadPolicy() != null && (this.targetDataSet.getDownloadPolicy() == null || this.sourceDataSet.getDownloadPolicy().compareTo(this.targetDataSet.getDownloadPolicy()) > 0)) {
                this.targetDataSet.setDownloadPolicy(this.sourceDataSet.getDownloadPolicy());
            }
            if (this.sourceDataSet.isLocked() && !this.targetDataSet.isLocked()) {
                this.targetDataSet.lock();
            }
        }
        finally {
            this.targetDataSet.endUpdate();
        }
        if (progressMonitor != null) {
            progressMonitor.finishTask();
        }
    }

    public DataSet getTargetDataSet() {
        return this.targetDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

