/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TagDescriptor<T extends Directory> {
    @NotNull
    protected final T _directory;

    public TagDescriptor(@NotNull T directory) {
        this._directory = directory;
    }

    @Nullable
    public String getDescription(int tagType) {
        int length;
        Object object = ((Directory)this._directory).getObject(tagType);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray() && (length = Array.getLength(object)) > 16) {
            return String.format("[%d values]", length);
        }
        if (object instanceof Date) {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy").format((Date)object).replaceAll("([0-9]{2} [^ ]+)$", ":$1");
        }
        return ((Directory)this._directory).getString(tagType);
    }

    @Nullable
    public static String convertBytesToVersionString(@Nullable int[] components, int majorDigits) {
        if (components == null) {
            return null;
        }
        StringBuilder version = new StringBuilder();
        for (int i = 0; i < 4 && i < components.length; ++i) {
            char c;
            if (i == majorDigits) {
                version.append('.');
            }
            if ((c = (char)components[i]) < '0') {
                c = (char)(c + 48);
            }
            if (i == 0 && c == '0') continue;
            version.append(c);
        }
        return version.toString();
    }

    @Nullable
    protected String getVersionBytesDescription(int tagType, int majorDigits) {
        int[] values = ((Directory)this._directory).getIntArray(tagType);
        return values == null ? null : TagDescriptor.convertBytesToVersionString(values, majorDigits);
    }

    @Nullable
    protected String getIndexedDescription(int tagType, String ... descriptions) {
        return this.getIndexedDescription(tagType, 0, descriptions);
    }

    @Nullable
    protected String getIndexedDescription(int tagType, int baseIndex, String ... descriptions) {
        String description;
        Long index = ((Directory)this._directory).getLongObject(tagType);
        if (index == null) {
            return null;
        }
        long arrayIndex = index - (long)baseIndex;
        if (arrayIndex >= 0L && arrayIndex < (long)descriptions.length && (description = descriptions[(int)arrayIndex]) != null) {
            return description;
        }
        return "Unknown (" + index + ")";
    }

    @Nullable
    protected String getByteLengthDescription(int tagType) {
        byte[] bytes = ((Directory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        return String.format("(%d byte%s)", bytes.length, bytes.length == 1 ? "" : "s");
    }

    @Nullable
    protected String getSimpleRational(int tagType) {
        Rational value = ((Directory)this._directory).getRational(tagType);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(true);
    }

    @Nullable
    protected String getDecimalRational(int tagType, int decimalPlaces) {
        Rational value = ((Directory)this._directory).getRational(tagType);
        if (value == null) {
            return null;
        }
        return String.format("%." + decimalPlaces + "f", value.doubleValue());
    }

    @Nullable
    protected String getFormattedInt(int tagType, @NotNull String format) {
        Integer value = ((Directory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getFormattedFloat(int tagType, @NotNull String format) {
        Float value = ((Directory)this._directory).getFloatObject(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getFormattedString(int tagType, @NotNull String format) {
        String value = ((Directory)this._directory).getString(tagType);
        if (value == null) {
            return null;
        }
        return String.format(format, value);
    }

    @Nullable
    protected String getEpochTimeDescription(int tagType) {
        Long value = ((Directory)this._directory).getLongObject(tagType);
        if (value == null) {
            return null;
        }
        return new Date(value).toString();
    }

    @Nullable
    protected String getBitFlagDescription(int tagType, Object ... labels) {
        Integer value = ((Directory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (int bitIndex = 0; labels.length > bitIndex; ++bitIndex) {
            Object labelObj = labels[bitIndex];
            if (labelObj != null) {
                boolean isBitSet;
                boolean bl = isBitSet = (value & 1) == 1;
                if (labelObj instanceof String[]) {
                    String[] labelPair = (String[])labelObj;
                    assert (labelPair.length == 2);
                    parts.add(labelPair[isBitSet ? 1 : 0]);
                } else if (isBitSet && labelObj instanceof String) {
                    parts.add((String)labelObj);
                }
            }
            value = value >> 1;
        }
        return StringUtil.join(parts, ", ");
    }

    @Nullable
    protected String get7BitStringFromBytes(int tagType) {
        byte[] bytes = ((Directory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        for (int index = 0; index < bytes.length; ++index) {
            int i = bytes[index] & 0xFF;
            if (i != 0 && i <= 127) continue;
            length = index;
            break;
        }
        return new String(bytes, 0, length);
    }

    @Nullable
    protected String getStringFromBytes(int tag, Charset cs) {
        byte[] values = ((Directory)this._directory).getByteArray(tag);
        if (values == null) {
            return null;
        }
        try {
            return new String(values, cs.name()).trim();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nullable
    protected String getRationalOrDoubleString(int tagType) {
        Rational rational = ((Directory)this._directory).getRational(tagType);
        if (rational != null) {
            return rational.toSimpleString(true);
        }
        Double d = ((Directory)this._directory).getDoubleObject(tagType);
        if (d != null) {
            DecimalFormat format = new DecimalFormat("0.###");
            return format.format(d);
        }
        return null;
    }

    @Nullable
    protected static String getFStopDescription(double fStop) {
        DecimalFormat format = new DecimalFormat("0.0");
        format.setRoundingMode(RoundingMode.HALF_UP);
        return "f/" + format.format(fStop);
    }

    @Nullable
    protected static String getFocalLengthDescription(double mm) {
        DecimalFormat format = new DecimalFormat("0.#");
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format.format(mm) + " mm";
    }

    @Nullable
    protected String getLensSpecificationDescription(int tag) {
        Rational[] values = ((Directory)this._directory).getRationalArray(tag);
        if (values == null || values.length != 4 || values[0].isZero() && values[2].isZero()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (values[0].equals(values[1])) {
            sb.append(values[0].toSimpleString(true)).append("mm");
        } else {
            sb.append(values[0].toSimpleString(true)).append('-').append(values[1].toSimpleString(true)).append("mm");
        }
        if (!values[2].isZero()) {
            sb.append(' ');
            DecimalFormat format = new DecimalFormat("0.0");
            format.setRoundingMode(RoundingMode.HALF_UP);
            if (values[2].equals(values[3])) {
                sb.append(TagDescriptor.getFStopDescription(values[2].doubleValue()));
            } else {
                sb.append("f/").append(format.format(values[2].doubleValue())).append('-').append(format.format(values[3].doubleValue()));
            }
        }
        return sb.toString();
    }

    @Nullable
    protected String getOrientationDescription(int tag) {
        return this.getIndexedDescription(tag, 1, "Top, left side (Horizontal / normal)", "Top, right side (Mirror horizontal)", "Bottom, right side (Rotate 180)", "Bottom, left side (Mirror vertical)", "Left side, top (Mirror horizontal and rotate 270 CW)", "Right side, top (Rotate 90 CW)", "Right side, bottom (Mirror horizontal and rotate 90 CW)", "Left side, bottom (Rotate 270 CW)");
    }

    @Nullable
    protected String getShutterSpeedDescription(int tag) {
        Float apexValue = ((Directory)this._directory).getFloatObject(tag);
        if (apexValue == null) {
            return null;
        }
        if (apexValue.floatValue() <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)apexValue.floatValue() * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            DecimalFormat format = new DecimalFormat("0.##");
            format.setRoundingMode(RoundingMode.HALF_UP);
            return format.format(fApexPower) + " sec";
        }
        int apexPower = (int)Math.exp((double)apexValue.floatValue() * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    @Nullable
    protected String getLightSourceDescription(short wbtype) {
        switch (wbtype) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Fluorescent";
            }
            case 3: {
                return "Tungsten (Incandescent)";
            }
            case 4: {
                return "Flash";
            }
            case 9: {
                return "Fine Weather";
            }
            case 10: {
                return "Cloudy";
            }
            case 11: {
                return "Shade";
            }
            case 12: {
                return "Daylight Fluorescent";
            }
            case 13: {
                return "Day White Fluorescent";
            }
            case 14: {
                return "Cool White Fluorescent";
            }
            case 15: {
                return "White Fluorescent";
            }
            case 16: {
                return "Warm White Fluorescent";
            }
            case 17: {
                return "Standard Light A";
            }
            case 18: {
                return "Standard Light B";
            }
            case 19: {
                return "Standard Light C";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 23: {
                return "D50";
            }
            case 24: {
                return "ISO Studio Tungsten";
            }
            case 255: {
                return "Other";
            }
        }
        return this.getDescription(wbtype);
    }

    @Nullable
    protected String getEncodedTextDescription(int tagType) {
        byte[] commentBytes = ((Directory)this._directory).getByteArray(tagType);
        if (commentBytes == null) {
            return null;
        }
        if (commentBytes.length == 0) {
            return "";
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("ASCII", System.getProperty("file.encoding"));
        encodingMap.put("UNICODE", "UTF-16LE");
        encodingMap.put("JIS", "Shift-JIS");
        try {
            if (commentBytes.length >= 10) {
                String firstTenBytesString = new String(commentBytes, 0, 10);
                for (Map.Entry pair : encodingMap.entrySet()) {
                    String encodingName = (String)pair.getKey();
                    String charset = (String)pair.getValue();
                    if (!firstTenBytesString.startsWith(encodingName)) continue;
                    for (int j = encodingName.length(); j < 10; ++j) {
                        byte b = commentBytes[j];
                        if (b == 0 || b == 32) continue;
                        return new String(commentBytes, j, commentBytes.length - j, charset).trim();
                    }
                    return new String(commentBytes, 10, commentBytes.length - 10, charset).trim();
                }
            }
            return new String(commentBytes, System.getProperty("file.encoding")).trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

