/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.util.filter;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class ShadowFilter
implements BufferedImageOp,
ImageObserver {
    protected int radius;

    public ShadowFilter(int radius) {
        this.setRadius(radius);
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        dst.getGraphics().drawImage(src, 0, 0, this);
        WritableRaster srcRaster = src.getRaster();
        WritableRaster dstRaster = dst.getRaster();
        float[] srcPixel = new float[4];
        float[] dstPixel = new float[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                srcPixel = srcRaster.getPixel(x, y, srcPixel);
                for (int rX = x - this.radius; rX < x + this.radius; ++rX) {
                    for (int rY = y - this.radius; rY < y + this.radius; ++rY) {
                        float dstAlpha;
                        float srcAlpha;
                        float newAlpha;
                        float r;
                        if (rX < 0 || rX >= width || rY < 0 || rY >= height || !((r = (float)Math.sqrt(Math.pow(x - rX, 2.0) + Math.pow(y - rY, 2.0))) < (float)this.radius) || !((newAlpha = (srcAlpha = srcPixel[3]) / (float)this.radius * ((float)this.radius - r)) >= (dstAlpha = (dstPixel = dstRaster.getPixel(rX, rY, dstPixel))[3]))) continue;
                        dstPixel[0] = srcPixel[0];
                        dstPixel[1] = srcPixel[1];
                        dstPixel[2] = srcPixel[2];
                        dstPixel[3] = newAlpha;
                        dstRaster.setPixel(rX, rY, dstPixel);
                    }
                }
            }
        }
        dst.flush();
        return dst;
    }

    public String toString() {
        return "ShadowFilter[radius=" + this.radius + "]";
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

