/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.util.color;

import de.wideportal.maprender.util.color.ColorLine;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;

public class GradientPolygonPaint
implements Paint {
    private ArrayList<ColorLine> colorLines;
    private double lineWidth;

    public GradientPolygonPaint(ArrayList<ColorLine> colorLines, double lineWidth) {
        this.colorLines = colorLines;
        this.lineWidth = lineWidth;
    }

    @Override
    public int getTransparency() {
        boolean hasTransparancy = false;
        for (int i = 0; i < this.colorLines.size(); ++i) {
            if (this.colorLines.get(i).getColorStart().getAlpha() != 255) {
                hasTransparancy = true;
                break;
            }
            if (this.colorLines.get(i).getColorStop().getAlpha() == 255) continue;
            hasTransparancy = true;
            break;
        }
        return hasTransparancy ? 1 : 3;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new GradientPolygonPaintContext(this, cm, deviceBounds, userBounds, this.colorLines, xform, this.lineWidth);
    }

    public class GradientPolygonPaintContext
    implements PaintContext {
        private ColorModel cm;
        private Graphics2D graphics;
        private ArrayList<ColorLine> colorLines;
        private BufferedImage buff;
        private Rectangle deviceBounds;
        private Rectangle2D userBounds;
        private double lineWidth;
        private BasicStroke basicStroke;
        private WritableRaster rasterBuffer;

        public GradientPolygonPaintContext(GradientPolygonPaint this$0, ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, ArrayList<ColorLine> colorLines, AffineTransform xform, double lineWidth) {
            this.cm = cm;
            this.colorLines = colorLines;
            this.deviceBounds = deviceBounds;
            this.userBounds = userBounds;
            this.lineWidth = lineWidth;
            this.basicStroke = new BasicStroke((float)this.lineWidth + 1.0f, 1, 1);
            this.createRaster();
        }

        @Override
        public void dispose() {
            if (this.buff != null) {
                this.buff.flush();
                this.buff = null;
            }
            if (this.graphics != null) {
                this.graphics.dispose();
                this.graphics = null;
            }
            if (this.rasterBuffer != null) {
                this.rasterBuffer = null;
            }
            this.colorLines = null;
            this.basicStroke = null;
            this.cm = null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.cm;
        }

        private void createRaster() {
            BufferedImage blurredImage;
            this.buff = new BufferedImage((int)(this.deviceBounds.getX() + this.deviceBounds.getWidth()), (int)(this.deviceBounds.getY() + this.deviceBounds.getHeight()), 2);
            this.graphics = (Graphics2D)this.buff.getGraphics();
            this.graphics.setStroke(this.basicStroke);
            this.graphics.setComposite(AlphaComposite.getInstance(11));
            for (int i = 0; i < this.colorLines.size(); ++i) {
                ColorLine colorLine = this.colorLines.get(i);
                float xStartCorrected = (float)colorLine.getStart().getX();
                float yStartCorrected = (float)colorLine.getStart().getY();
                float xStopCorrected = (float)colorLine.getStop().getX();
                float yStopCorrected = (float)colorLine.getStop().getY();
                GradientPaint grad = new GradientPaint(xStartCorrected, yStartCorrected, colorLine.getColorStart(), xStopCorrected, yStopCorrected, colorLine.getColorStop());
                this.graphics.setPaint(grad);
                this.graphics.drawLine((int)xStartCorrected, (int)yStartCorrected, (int)xStopCorrected, (int)yStopCorrected);
            }
            this.buff.flush();
            int blurSize = 5;
            float outer = 0.036363635f;
            float middle = 0.049999997f;
            float inner = 0.057142857f;
            float[] matrix = new float[]{outer, outer, outer, outer, outer, outer, middle, middle, middle, outer, outer, middle, inner, middle, outer, outer, middle, middle, middle, outer, outer, outer, outer, outer, outer};
            ConvolveOp blurFilter = new ConvolveOp(new Kernel(blurSize, blurSize, matrix), 1, null);
            this.buff = blurredImage = blurFilter.filter(this.buff, null);
            this.rasterBuffer = this.buff.getRaster();
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            if (this.rasterBuffer == null) {
                this.createRaster();
            }
            return this.rasterBuffer.createChild(x, y, w, h, 0, 0, null);
        }
    }
}

