/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm.algos;

import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.buffer.BooleanArrayBuffer;
import java.util.ArrayList;

public class PointGroupAlgo {
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int C = 8;

    public static ArrayList<Point> getSurroundingPoints(Point[][][] pointMap, Point point) {
        ArrayList<Point> surroundingPoints = new ArrayList<Point>();
        for (int z = 0; z < pointMap[(int)point.getX()][(int)point.getY()].length; ++z) {
            if (z == 8 || pointMap[(int)point.getX()][(int)point.getY()][z] == null) continue;
            surroundingPoints.add(pointMap[(int)point.getX()][(int)point.getY()][z]);
        }
        return surroundingPoints;
    }

    public static int getSurroundingPointsCount(BooleanArrayBuffer cellOnLineBuffer, Point center, int z) {
        int counter = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                int x = (int)(center.getX() + (double)i);
                int y = (int)(center.getY() + (double)j);
                if (x < 0 || y < 0 || x >= cellOnLineBuffer.getXSize() || y >= cellOnLineBuffer.getYSize() || !cellOnLineBuffer.getValue(x, y, z)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static Point findPointInGroup(ArrayList<Point> group, double x, double y) {
        for (Point point : group) {
            if (!point.hasCoordinates(x, y)) continue;
            return point;
        }
        return null;
    }

    public static ArrayList<Point> getGroupTileBorderCrossings(ArrayList<Point> group, long tileSize) {
        ArrayList<Point> tileBorderCrossings = new ArrayList<Point>();
        for (int i = 0; i < group.size(); ++i) {
            double x = group.get(i).getX();
            double y = group.get(i).getY();
            if (!(x <= 0.0 || x >= (double)(tileSize - 1L) || y <= 0.0) && !(y >= (double)(tileSize - 1L))) continue;
            tileBorderCrossings.add(group.get(i));
        }
        return tileBorderCrossings;
    }

    public static boolean isInsideTile(Point point, long tileSize) {
        return PointGroupAlgo.isInsideTile(point.getX(), point.getY(), tileSize);
    }

    public static boolean isInsideTile(double x, double y, long tileSize) {
        return !(x < 0.0 || y < 0.0 || x >= (double)tileSize) && !(y >= (double)tileSize);
    }

    public static boolean isOnTileBorder(Point point, long tileSize) {
        return PointGroupAlgo.isOnTileBorder(point.getX(), point.getY(), tileSize);
    }

    public static boolean isOnTileBorder(double x, double y, long tileSize) {
        return x == 0.0 || y == 0.0 || x == (double)(tileSize - 1L) || y == (double)(tileSize - 1L);
    }
}

