/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.srtm;

import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.util.color.ColorLine;
import de.wideportal.maprender.util.color.ColorValueRanges;
import java.awt.Color;

public class SrtmSlopeLine
extends Line {
    private double slope = 0.0;

    public SrtmSlopeLine() {
    }

    public SrtmSlopeLine(Point start, Point stop) {
        super(start, stop);
    }

    public SrtmSlopeLine(Point start, Point stop, long optionalLineIndex) {
        super(start, stop, optionalLineIndex);
    }

    public SrtmSlopeLine(Point start, Point stop, double slope) {
        super(start, stop);
        this.slope = slope;
    }

    public SrtmSlopeLine(Point start, Point stop, long optionalLineIndex, double slope) {
        super(start, stop, optionalLineIndex);
        this.slope = slope;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public ColorLine convertToColorLine(ColorValueRanges colorValueRanges) {
        Color color = colorValueRanges.getColorFromColorRanges(this.slope);
        return new ColorLine(this.start, this.stop, this.optionalLineIndex, color, color);
    }

    @Override
    public String toString() {
        return "SrtmSlopeLine[start=" + this.start + ", stop=" + this.stop + ", optionalLineIndex=" + this.optionalLineIndex + ", slope=" + this.slope + "]";
    }
}

