/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.kml;

import de.wideportal.maprender.datasource.kml.KmlLineString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.opengis.kml._2.AbstractFeatureType;
import net.opengis.kml._2.AbstractGeometryType;
import net.opengis.kml._2.AbstractStyleSelectorType;
import net.opengis.kml._2.DocumentType;
import net.opengis.kml._2.FolderType;
import net.opengis.kml._2.KmlType;
import net.opengis.kml._2.LineStringType;
import net.opengis.kml._2.PairType;
import net.opengis.kml._2.PlacemarkType;
import net.opengis.kml._2.PolygonType;
import net.opengis.kml._2.StyleMapType;
import net.opengis.kml._2.StyleStateEnumType;
import net.opengis.kml._2.StyleType;

public class KmlFile {
    private String fileName;
    private KmlType kml;
    private LinkedHashMap<String, StyleMapType> styleGroupMap;
    private LinkedHashMap<String, StyleType> styleMap;
    private List<PlacemarkType> placemarks;
    private List<KmlLineString> kmlLineStrings;

    public KmlFile(String fileName, KmlType kml) {
        this.fileName = fileName;
        this.kml = kml;
    }

    public void initialize() {
        this.kmlLineStrings = new ArrayList<KmlLineString>();
        JAXBElement<? extends AbstractFeatureType> abstractFeature = this.kml.getAbstractFeatureGroup();
        Class declaredType = abstractFeature.getDeclaredType();
        if (declaredType == DocumentType.class) {
            DocumentType document = (DocumentType)abstractFeature.getValue();
            this.styleGroupMap = this.getStyleGroups(document);
            this.styleMap = this.getStyles(document);
            this.placemarks = this.findPlacemarksInDocument(document);
            for (PlacemarkType placemark : this.placemarks) {
                JAXBElement<? extends AbstractGeometryType> geometry = placemark.getAbstractGeometryGroup();
                if (geometry.getDeclaredType() == LineStringType.class) {
                    this.kmlLineStrings.add(this.getCoordinates(placemark));
                }
                if (geometry.getDeclaredType() != PolygonType.class) continue;
                this.kmlLineStrings.add(this.getCoordinates(placemark));
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public KmlType getKml() {
        return this.kml;
    }

    public void setKml(KmlType kml) {
        this.kml = kml;
    }

    public List<PlacemarkType> getPlacemarks() {
        return this.placemarks;
    }

    public List<KmlLineString> getKmlLineStrings() {
        return this.kmlLineStrings;
    }

    public StyleType findStyle(String styleUrl) {
        StyleMapType styleGroup;
        if (styleUrl == null) {
            return null;
        }
        if (styleUrl.startsWith("#")) {
            styleUrl = styleUrl.substring(1);
        }
        if (this.styleMap.containsKey(styleUrl)) {
            return this.styleMap.get(styleUrl);
        }
        if (this.styleGroupMap.containsKey(styleUrl) && (styleGroup = this.styleGroupMap.get(styleUrl)) != null) {
            List<PairType> pairs = styleGroup.getPair();
            for (PairType pair : pairs) {
                if (pair.getKey() != StyleStateEnumType.NORMAL) continue;
                String subStyleUrl = pair.getStyleUrl();
                return this.findStyle(subStyleUrl);
            }
        }
        return null;
    }

    private LinkedHashMap<String, StyleType> getStyles(DocumentType document) {
        LinkedHashMap<String, StyleType> styleMap = new LinkedHashMap<String, StyleType>();
        List<JAXBElement<? extends AbstractStyleSelectorType>> styleSelectors = document.getAbstractStyleSelectorGroup();
        for (JAXBElement<? extends AbstractStyleSelectorType> styleSelector : styleSelectors) {
            if (styleSelector.getDeclaredType() != StyleType.class) continue;
            StyleType styleType = (StyleType)styleSelector.getValue();
            String styleName = styleType.getId();
            styleMap.put(styleName, styleType);
        }
        return styleMap;
    }

    private LinkedHashMap<String, StyleMapType> getStyleGroups(DocumentType document) {
        LinkedHashMap<String, StyleMapType> styleGroupMap = new LinkedHashMap<String, StyleMapType>();
        List<JAXBElement<? extends AbstractStyleSelectorType>> styleSelectors = document.getAbstractStyleSelectorGroup();
        for (JAXBElement<? extends AbstractStyleSelectorType> styleSelector : styleSelectors) {
            if (styleSelector.getDeclaredType() != StyleMapType.class) continue;
            StyleMapType styleMapType = (StyleMapType)styleSelector.getValue();
            String styleMapName = styleMapType.getId();
            styleGroupMap.put(styleMapName, styleMapType);
        }
        return styleGroupMap;
    }

    private List<PlacemarkType> findPlacemarksInDocument(DocumentType document) {
        List<JAXBElement<? extends AbstractFeatureType>> documentFeatureGroups = document.getAbstractFeatureGroup();
        ArrayList<PlacemarkType> allPlacemarks = new ArrayList<PlacemarkType>();
        for (JAXBElement<? extends AbstractFeatureType> featureGroup : documentFeatureGroups) {
            if (featureGroup.getDeclaredType() == FolderType.class) {
                FolderType folder = (FolderType)featureGroup.getValue();
                List<PlacemarkType> placementsInFolder = this.findPlacemarksInFolder(folder);
                allPlacemarks.addAll(placementsInFolder);
                continue;
            }
            if (featureGroup.getDeclaredType() != PlacemarkType.class) continue;
            allPlacemarks.add((PlacemarkType)featureGroup.getValue());
        }
        return allPlacemarks;
    }

    private List<PlacemarkType> findPlacemarksInFolder(FolderType folder) {
        List<JAXBElement<? extends AbstractFeatureType>> documentFeatureGroups = folder.getAbstractFeatureGroup();
        ArrayList<PlacemarkType> allPlacemarks = new ArrayList<PlacemarkType>();
        for (JAXBElement<? extends AbstractFeatureType> featureGroup : documentFeatureGroups) {
            if (featureGroup.getDeclaredType() == FolderType.class) {
                FolderType subFolder = (FolderType)featureGroup.getValue();
                List<PlacemarkType> placementsInFolder = this.findPlacemarksInFolder(subFolder);
                allPlacemarks.addAll(placementsInFolder);
                continue;
            }
            if (featureGroup.getDeclaredType() != PlacemarkType.class) continue;
            allPlacemarks.add((PlacemarkType)featureGroup.getValue());
        }
        return allPlacemarks;
    }

    public KmlLineString getCoordinates(PlacemarkType placemark) {
        JAXBElement<? extends AbstractGeometryType> geometry = placemark.getAbstractGeometryGroup();
        if (geometry.getDeclaredType() == LineStringType.class) {
            LineStringType lineString = (LineStringType)geometry.getValue();
            List<String> coordinates = lineString.getCoordinates();
            return new KmlLineString(placemark.getId(), placemark.getStyleUrl(), coordinates);
        }
        if (geometry.getDeclaredType() == PolygonType.class) {
            PolygonType polygonString = (PolygonType)geometry.getValue();
            List<String> coordinates = polygonString.getOuterBoundaryIs().getLinearRing().getCoordinates();
            return new KmlLineString(placemark.getId(), placemark.getStyleUrl(), coordinates);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof KmlFile)) {
            return false;
        }
        KmlFile otherFile = (KmlFile)other;
        return this.fileName == otherFile.fileName;
    }
}

