/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.jaxa.cache;

import de.wideportal.maprender.resources.file.FileAccessor;
import de.wideportal.maprender.resources.jaxa.JaxaTile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxaFlattenedTileCachePersister
extends FileAccessor {
    protected static Logger log = LoggerFactory.getLogger(JaxaFlattenedTileCachePersister.class);
    private static final String FILETYPE = "flattened.zip";
    private String baseFolder;

    public JaxaFlattenedTileCachePersister(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    private String getFileName(int lat, int lon, int heightDiffThreshold) {
        Object fileName = "";
        fileName = lat < 0 ? (String)fileName + "S" : (String)fileName + "N";
        fileName = (String)fileName + String.format("%03d", Math.abs(lat));
        fileName = lon < 0 ? (String)fileName + "W" : (String)fileName + "E";
        fileName = (String)fileName + String.format("%03d", Math.abs(lon));
        fileName = (String)fileName + "F";
        fileName = (String)fileName + heightDiffThreshold;
        return fileName;
    }

    public Optional<JaxaTile> load(int lat, int lon, int heightDiffThreshold) {
        log.debug("load: lat=" + lat + " / lon=" + lon);
        String fileName = this.getFileName(lat, lon, heightDiffThreshold);
        Optional<File> optionalYFile = this.getFile(this.baseFolder, fileName, FILETYPE, false);
        JaxaTile result = null;
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
            if (yFile.exists()) {
                try (FileInputStream fis = new FileInputStream(yFile);
                     ZipInputStream zis = new ZipInputStream(fis);){
                    ZipEntry innerFile = zis.getNextEntry();
                    if (innerFile != null) {
                        FSTObjectInput ois = new FSTObjectInput((InputStream)zis);
                        result = (JaxaTile)ois.readObject(new Class[]{JaxaTile.class});
                        ois.close();
                    }
                }
                catch (Exception e) {
                    log.error("load: could not load from file: " + yFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else {
            log.debug("load: file is not accessible. Cannot load flattened JAXA cache. Base folder is: " + this.baseFolder);
        }
        return Optional.ofNullable(result);
    }

    public void persist(int zoom, int xTileIndex, int yTileIndex, JaxaTile jaxaTile, int heightDiffThreshold) {
        log.debug("persist: zoom=" + zoom + " / xTileIndex=" + xTileIndex + " / yTileIndex=" + yTileIndex);
        String fileName = this.getFileName(jaxaTile.getLat(), jaxaTile.getLon(), heightDiffThreshold);
        Optional<File> optionalYFile = this.getFile(this.baseFolder, fileName, FILETYPE, true);
        jaxaTile.setFileName(fileName + ".flattened.zip");
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
        } else {
            log.error("persist: file is not accessible. Cannot save tile. Base folder is: " + this.baseFolder);
        }
        if (yFile.exists()) {
            log.debug("persist: cache was already created");
            return;
        }
        try {
            log.debug("persist: saved flattened JAXA cache file: " + yFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("persist: could not write flattened JAXA cache file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
        try (FileOutputStream fout = new FileOutputStream(yFile);
             ZipOutputStream zos = new ZipOutputStream(fout);
             FSTObjectOutput oos = new FSTObjectOutput((OutputStream)zos);){
            ZipEntry innerFile = new ZipEntry("cache");
            zos.putNextEntry(innerFile);
            oos.writeObject((Object)jaxaTile, new Class[]{JaxaTile.class});
            log.info("persist: saved flattened JAXA tile to file: " + fileName + ".flattened.zip");
        }
        catch (IOException e) {
            log.error("persist: could not write to file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

