/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.jaxa;

import de.wideportal.maprender.config.xml.RenderConfigurationJaxa;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.resources.height.HeightCollectorTileCachePersister;
import de.wideportal.maprender.resources.height.ITile;
import de.wideportal.maprender.resources.height.ITileCache;
import de.wideportal.maprender.resources.jaxa.JaxaTile;
import de.wideportal.maprender.resources.jaxa.JaxaTileLoader;
import de.wideportal.maprender.resources.jaxa.cache.JaxaFlattenedTileCachePersister;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxaTileCache
implements ITileCache {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private int cacheSize;
    private ArrayList<ITile> tiles;
    private JaxaTileLoader tileLoader;
    private HeightCollectorTileCachePersister collectTileCachePersister;
    private JaxaFlattenedTileCachePersister flattenedTileCachePersister;
    private int tilesRemovedFromCache = 0;

    public JaxaTileCache(RenderConfigurationJaxa jaxaConfig) {
        if (jaxaConfig != null) {
            this.cacheSize = jaxaConfig.getCache();
            this.tiles = new ArrayList();
            this.tileLoader = new JaxaTileLoader(jaxaConfig.getFolder(), jaxaConfig.getFormat(), jaxaConfig.getZipped(), jaxaConfig.getMockMissingTiles(), jaxaConfig.getMockSize());
            if (jaxaConfig.getFileCache() != null) {
                this.collectTileCachePersister = new HeightCollectorTileCachePersister(jaxaConfig.getFileCache(), jaxaConfig.getFileCacheMaxZoom());
            }
            if (jaxaConfig.getFlattenedCache() != null) {
                this.flattenedTileCachePersister = new JaxaFlattenedTileCachePersister(jaxaConfig.getFlattenedCache());
            }
        } else {
            this.log.error("SrtmTileCache: Cannot load srtm tiles since no srtm configuration is available. This is likely a misconfiguration that will result in broken rendering.");
        }
    }

    @Override
    public void addTile(ITile tile) {
        if (tile != null && !this.tiles.contains(tile)) {
            this.tiles.add(tile);
            if (this.tiles.size() > this.cacheSize) {
                int deleteIndex = 0;
                this.log.debug("addTile: removed tile from cache. Mocked=" + this.getTiles().get(deleteIndex).isMocked() + " / " + this.tiles.get(deleteIndex).getFileName() + " (Cache-size is " + this.tiles.size() + ")");
                this.tiles.remove(deleteIndex);
            }
        }
    }

    @Override
    public synchronized List<ITile> getUnloadedTiles(BoundingBox latLonBBox, int heightDiffThreshold, int heightPointDiffThreshold) {
        return this.getUnloadedTiles(latLonBBox.getLeft(), latLonBBox.getTop(), latLonBBox.getRight(), latLonBBox.getBottom(), heightDiffThreshold, heightPointDiffThreshold);
    }

    @Override
    public synchronized ITile getCachedTile(int lon, int lat, int heightDiffThreshold, int heightPointDiffThreshold) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            ITile tile = this.tiles.get(i);
            if (tile.getLon() != lon || tile.getLat() != lat || tile.getHeightDiffThreshold() != heightDiffThreshold || tile.getHeightPointDiffThreshold() != heightPointDiffThreshold) continue;
            this.tiles.add(tile);
            this.tiles.remove(i);
            ++this.tilesRemovedFromCache;
            if (this.tilesRemovedFromCache % 10 == 0) {
                System.gc();
            }
            return tile;
        }
        JaxaTile tile = new JaxaTile(lat, lon, heightDiffThreshold, heightPointDiffThreshold);
        if (tile != null) {
            this.addTile(tile);
            return tile;
        }
        return null;
    }

    @Override
    public synchronized List<ITile> getUnloadedTiles(double leftLon, double topLat, double rightLon, double bottomLat, int heightDiffThreshold, int heightPointDiffThreshold) {
        ArrayList<ITile> result = new ArrayList<ITile>();
        int leftLonBound = (int)Math.floor(leftLon);
        int rightLonBound = (int)Math.ceil(rightLon);
        int topLatBound = (int)Math.ceil(topLat);
        int bottomLatBound = (int)Math.floor(bottomLat);
        for (int lon = leftLonBound; lon < rightLonBound; ++lon) {
            for (int lat = bottomLatBound; lat < topLatBound; ++lat) {
                ITile tile = this.getCachedTile(lon, lat, heightDiffThreshold, heightPointDiffThreshold);
                if (tile == null) {
                    tile = new JaxaTile(lat, lon, heightDiffThreshold, heightPointDiffThreshold);
                    this.addTile(tile);
                }
                result.add(tile);
            }
        }
        return result;
    }

    @Override
    public synchronized ITile loadTile(ITile unloadedTile, int heightDiffThreshold) {
        if (heightDiffThreshold > 0) {
            unloadedTile = this.loadTileFromFlattenedFile(unloadedTile, heightDiffThreshold);
        }
        if (!unloadedTile.isLoaded()) {
            unloadedTile = this.tileLoader.loadTile((JaxaTile)unloadedTile);
        }
        return unloadedTile;
    }

    @Override
    public synchronized ITile loadTileFromFlattenedFile(ITile unloadedTile, int heightDiffThreshold) {
        Optional<JaxaTile> optionalJaxaTile;
        if (this.flattenedTileCachePersister != null && (optionalJaxaTile = this.flattenedTileCachePersister.load(unloadedTile.getLat(), unloadedTile.getLon(), heightDiffThreshold)).isPresent()) {
            this.log.info("loadTile: loading flattened srtm tile " + optionalJaxaTile.get().getFileName());
            return optionalJaxaTile.get();
        }
        return unloadedTile;
    }

    @Override
    public ArrayList<ITile> getTiles() {
        return this.tiles;
    }

    @Override
    public Optional<HeightCollectorTileCachePersister> getHeightCollectorTileCachePersister() {
        return Optional.ofNullable(this.collectTileCachePersister);
    }

    public boolean isTileFileExisting(ITile unloadedTile) {
        return this.tileLoader.isTileFileExisting(unloadedTile);
    }

    @Override
    public void purgeZoomSpecificCaches() {
        this.log.info("purgeZoomSpecificCaches()");
        this.tiles.clear();
    }

    @Override
    public void logCache() {
        this.log.info("logCache: starting to log all tiles currently in the jaxa tile cache: #" + this.tiles.size());
        List sortedTiles = this.tiles.stream().sorted(Comparator.comparing(ITile::getFileName)).collect(Collectors.toList());
        for (int i = 0; i < sortedTiles.size(); ++i) {
            this.log.info("logCache: " + i + ": " + ((ITile)sortedTiles.get(i)).getFileName());
        }
    }
}

