/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.resources.file;

import de.wideportal.maprender.config.xml.RenderConfigurationJob;
import de.wideportal.maprender.request.RenderImage;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileAccessor;
import de.wideportal.maprender.resources.output.IRenderOutputPersister;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Optional;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePersister
extends FileAccessor
implements IRenderOutputPersister {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public synchronized void persistTile(RenderRequest renderRequest) {
        this.log.debug("persistTile: zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
        if (renderRequest.getOsmMap().getJob().getOutput().getFile() != null) {
            this.persistOsmTileFile(renderRequest);
            if (renderRequest.getOsmMap().getJob().getOutput().getFtp() != null) {
                this.persistOsmTileFtp(renderRequest);
            }
        } else {
            this.log.debug("persistTile: no file output is configured. This is likely a misconfiguration.");
        }
    }

    public void persistOsmTileFile(RenderRequest renderRequest) {
        this.log.debug("persistOsmTileFile: zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
        String baseFolder = renderRequest.getOsmMap().getJob().getOutput().getFile().getFolder();
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int xIndex = (int)renderRequest.getTileIndex().getX();
        int yIndex = (int)renderRequest.getTileIndex().getY();
        RenderConfigurationJob currentJob = renderRequest.getOsmMap().getJob();
        String configuredImageType = currentJob.getOutput().getImageType();
        String configuredImageQuality = currentJob.getOutput().getQuality();
        String fileType = "png";
        if (configuredImageType != null) {
            fileType = configuredImageType;
        }
        if ("none".equalsIgnoreCase(fileType)) {
            return;
        }
        float quality = 100.0f;
        if (configuredImageQuality != null) {
            try {
                quality = Integer.parseInt(configuredImageQuality);
            }
            catch (NumberFormatException e) {
                this.log.error("persistOsmTileFile: could not parse the image file quality setting from the output configuration: " + configuredImageQuality + ". Using default: " + quality);
            }
        }
        Optional<File> optionalYFile = this.getFile(baseFolder, zoom, xIndex, yIndex, fileType, true);
        File yFile = null;
        if (optionalYFile.isPresent()) {
            yFile = optionalYFile.get();
        } else {
            this.log.error("persistOsmTile: file is not accessible. Cannot save tile. Base folder is: " + baseFolder);
        }
        if (yFile.exists()) {
            yFile.delete();
            this.log.debug("persistOsmTile: deleted old file: " + yFile.getAbsolutePath());
        }
        RenderImage renderImage = renderRequest.getRenderImage();
        renderImage.mergeLayers();
        try {
            if ("png".equalsIgnoreCase(fileType)) {
                ImageIO.write((RenderedImage)renderImage.getBaseLayer().getImage(), "png", yFile);
            } else if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType)) {
                BufferedImage alphaLessImage = this.removeAlphaChannel(renderImage.getBaseLayer().getImage());
                JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality(quality / 100.0f);
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                FileImageOutputStream fos = new FileImageOutputStream(yFile);
                writer.setOutput(fos);
                writer.write(null, new IIOImage(alphaLessImage, null, null), jpegParams);
                fos.close();
            } else if ("bmp".equalsIgnoreCase(fileType)) {
                BufferedImage alphaLessImage = this.removeAlphaChannel(renderImage.getBaseLayer().getImage());
                ImageIO.write((RenderedImage)alphaLessImage, "bmp", yFile);
            }
            this.log.debug("persistOsmTile: saved tile file: " + yFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.error("persistOsmTile: could not write tile file: " + yFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public void persistOsmTileFtp(RenderRequest renderRequest) {
        this.log.debug("persistOsmTileFtp: zoom=" + renderRequest.getZoomInfo().getZoom() + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon());
    }

    private BufferedImage removeAlphaChannel(BufferedImage alphaImage) {
        BufferedImage copy = new BufferedImage(alphaImage.getWidth(), alphaImage.getHeight(), 1);
        Graphics2D g2d = copy.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, copy.getWidth(), copy.getHeight());
        g2d.drawImage((Image)alphaImage, 0, 0, null);
        g2d.dispose();
        return copy;
    }
}

