/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.request;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;

public class RenderImageLayer {
    public static final String LAYER_BASE = "LAYER_BASE";
    public static final String LAYER_FILTER = "LAYER_FILTER";
    public static final String LAYER_BASE_FILTER = "LAYER_BASE_FILTER";
    public static final String LAYER_COMP_OP = "LAYER_COMP_OP";
    public static final String LAYER_OPACITY = "LAYER_OPACITY";
    private String name;
    private BufferedImage image;
    private Graphics2D canvas;
    private Float opacity = Float.valueOf(1.0f);

    public RenderImageLayer(String name, int tileSize) {
        this.name = name;
        this.image = new BufferedImage(tileSize, tileSize, 2);
        this.refreshCanvas();
    }

    public RenderImageLayer(Color backgroundColor, String name, int tileSize) {
        this.name = name;
        this.image = new BufferedImage(tileSize, tileSize, 2);
        this.refreshCanvas();
        this.canvas.setColor(backgroundColor);
        this.canvas.fillRect(0, 0, tileSize, tileSize);
    }

    public void refreshCanvas() {
        this.image.flush();
        this.canvas = this.image.createGraphics();
        this.canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.canvas.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        this.canvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public void recreateFromByteArray(byte[] input) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        BufferedImage newImage = ImageIO.read(bais);
        bais.close();
        this.image.flush();
        this.image = newImage;
        this.canvas.dispose();
        this.refreshCanvas();
    }

    public String getName() {
        return this.name;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.canvas = image.createGraphics();
    }

    public Graphics2D getCanvas() {
        return this.canvas;
    }

    public void cleanup() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        if (this.canvas != null) {
            this.canvas.dispose();
            this.canvas = null;
        }
    }

    public float getOpacity() {
        return this.opacity.floatValue();
    }

    public void setOpacity(Float opacity) {
        this.opacity = opacity;
    }
}

