/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.text;

import de.wideportal.maprender.renderer.text.TextRowEntry;
import de.wideportal.maprender.resources.fonts.FontContext;
import java.awt.Graphics;
import java.util.ArrayList;

public class TextRow {
    public static final int TYPE_HARD_BREAK = 0;
    public static final int TYPE_SOFT_BREAK = 1;
    private int breakType;
    private String text;
    private String wrapCharacter;
    private ArrayList<TextRowEntry> textRowEntries = new ArrayList();

    public TextRow(int breakType, String wrapCharacter, String text) {
        this.breakType = breakType;
        this.text = text;
        this.wrapCharacter = wrapCharacter;
    }

    public int getBreakType() {
        return this.breakType;
    }

    public void setBreakType(int breakType) {
        this.breakType = breakType;
    }

    public String getFullText() {
        return this.text;
    }

    public String getWrapCharacter() {
        return this.wrapCharacter;
    }

    public ArrayList<TextRowEntry> getTextRowEntries() {
        return this.textRowEntries;
    }

    public void setTextRowEntries(ArrayList<TextRowEntry> textRowEntries) {
        this.textRowEntries = textRowEntries;
    }

    public String getParsedText() {
        StringBuffer parsedText = new StringBuffer();
        for (TextRowEntry textRowEntry : this.textRowEntries) {
            if (textRowEntry.getType() != 0) continue;
            parsedText.append(textRowEntry.getParsedText(this.wrapCharacter));
        }
        return parsedText.toString();
    }

    public void parse() {
        String textBlock;
        this.textRowEntries.clear();
        ArrayList<String> formatCharacters = new ArrayList<String>();
        formatCharacters.add("<b>");
        formatCharacters.add("<i>");
        formatCharacters.add("<p>");
        int indexStartBlock = 0;
        int indexEndBlock = 0;
        while (true) {
            int smallestIndexOfBreakerFound = Integer.MAX_VALUE;
            String breakerUsed = "";
            for (String breaker : formatCharacters) {
                int index = this.text.indexOf(breaker, indexEndBlock);
                if (index <= -1 || index >= smallestIndexOfBreakerFound) continue;
                smallestIndexOfBreakerFound = index;
                breakerUsed = breaker;
            }
            if (smallestIndexOfBreakerFound >= Integer.MAX_VALUE) break;
            indexStartBlock = smallestIndexOfBreakerFound;
            textBlock = this.text.substring(indexEndBlock, indexStartBlock);
            if (textBlock.length() > 0) {
                this.textRowEntries.add(new TextRowEntry(0, textBlock));
            }
            this.textRowEntries.add(new TextRowEntry(1, breakerUsed));
            indexEndBlock = indexStartBlock + breakerUsed.length();
        }
        textBlock = this.text.substring(indexEndBlock);
        this.textRowEntries.add(new TextRowEntry(0, textBlock));
        for (int i = 0; i < this.textRowEntries.size(); ++i) {
            TextRowEntry textRowEntry = this.textRowEntries.get(i);
            if (textRowEntry.getType() != 0) continue;
            ArrayList<TextRowEntry> newEntries = new ArrayList<TextRowEntry>();
            String[] words = textRowEntry.getFullText().split(this.wrapCharacter);
            for (int k = 0; k < words.length; ++k) {
                TextRowEntry newEntry;
                if (k < words.length - 1) {
                    newEntry = new TextRowEntry(0, words[k] + this.wrapCharacter);
                    newEntries.add(newEntry);
                    continue;
                }
                newEntry = new TextRowEntry(0, words[k]);
                newEntries.add(newEntry);
            }
            this.textRowEntries.remove(i);
            this.textRowEntries.addAll(i, newEntries);
            i = i + newEntries.size() - 1;
        }
    }

    public void calculateStringDimension(FontContext currentFontContext, Graphics dummyCanvas) {
        for (TextRowEntry entry : this.textRowEntries) {
            entry.calculateStringDimension(currentFontContext, dummyCanvas);
        }
    }

    public int getStringWidth() {
        int rowLength = 0;
        for (TextRowEntry entry : this.textRowEntries) {
            rowLength += entry.getStringWidth();
        }
        return rowLength;
    }

    public int getStringHeight() {
        int rowHeight = 0;
        for (TextRowEntry entry : this.textRowEntries) {
            rowHeight = Math.max(rowHeight, entry.getStringHeight());
        }
        return rowHeight;
    }

    public int getMaxDescent() {
        int maxDescent = 0;
        for (TextRowEntry entry : this.textRowEntries) {
            maxDescent = Math.max(maxDescent, entry.getMaxDescent());
        }
        return maxDescent;
    }

    public void add(TextRow other) {
        this.text = this.text.endsWith(this.wrapCharacter) ? this.text + other.text : this.text + this.wrapCharacter + other.text;
        this.parse();
    }

    public int getLongestUnbreakableTextPart(FontContext fontContext, Graphics dummyCanvas) {
        int longestUnbreakableWord = 0;
        for (TextRowEntry entry : this.textRowEntries) {
            int longestUnbreakableTextPart = entry.getLongestUnbreakableTextPart(fontContext, dummyCanvas, this.wrapCharacter);
            longestUnbreakableWord = Math.max(longestUnbreakableWord, longestUnbreakableTextPart);
        }
        return longestUnbreakableWord;
    }

    public ArrayList<TextRow> breakRowAfterLength(int maxLength, FontContext fontContext, Graphics dummyCanvas) {
        ArrayList<TextRow> result = new ArrayList<TextRow>();
        Object newText = "";
        int newTextLength = 0;
        boolean isFirstNewRow = true;
        for (int i = 0; i < this.textRowEntries.size(); ++i) {
            TextRow newTextRow;
            TextRowEntry textRowEntry = this.textRowEntries.get(i);
            int entryLength = textRowEntry.getStringWidth();
            if (newTextLength + entryLength <= maxLength) {
                newTextLength += entryLength;
                newText = (String)newText + textRowEntry.getFullText();
                if (i != this.textRowEntries.size() - 1) continue;
                newTextRow = new TextRow(isFirstNewRow ? 0 : 1, this.wrapCharacter, (String)newText);
                newTextRow.parse();
                isFirstNewRow = false;
                newText = "";
                newTextLength = 0;
                result.add(newTextRow);
                continue;
            }
            if (entryLength > maxLength) {
                if (newTextLength > 0) {
                    newTextRow = new TextRow(isFirstNewRow ? 0 : 1, this.wrapCharacter, (String)newText);
                    newTextRow.parse();
                    isFirstNewRow = false;
                    newText = "";
                    newTextLength = 0;
                    result.add(newTextRow);
                }
                newTextLength += entryLength;
                newText = (String)newText + textRowEntry.getFullText();
                newTextRow = new TextRow(isFirstNewRow ? 0 : 1, this.wrapCharacter, (String)newText);
                newTextRow.parse();
                isFirstNewRow = false;
                newText = "";
                newTextLength = 0;
                result.add(newTextRow);
                continue;
            }
            if (newTextLength > 0) {
                newTextRow = new TextRow(isFirstNewRow ? 0 : 1, this.wrapCharacter, (String)newText);
                newTextRow.parse();
                isFirstNewRow = false;
                newText = "";
                newTextLength = 0;
                result.add(newTextRow);
            }
            newTextLength = entryLength;
            newText = textRowEntry.getFullText();
            isFirstNewRow = false;
            if (i != this.textRowEntries.size() - 1) continue;
            newTextRow = new TextRow(isFirstNewRow ? 0 : 1, this.wrapCharacter, (String)newText);
            newTextRow.parse();
            isFirstNewRow = false;
            newText = "";
            newTextLength = 0;
            result.add(newTextRow);
        }
        return result;
    }

    public String toString() {
        return "TextRow[breakType=" + (this.breakType == 0 ? "TYPE_HARD_BREAK" : "TYPE_SOFT_BREAK") + ", text='" + this.text + "', textRowEntries=" + this.textRowEntries + "]";
    }
}

