/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.progress;

import de.wideportal.maprender.resources.sqlitedb.AbstractSqLiteDbAccessor;
import de.wideportal.maprender.resources.sqlitedb.AbstractSqLiteDbConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderProgressTrackingSqLiteAccessor
extends AbstractSqLiteDbAccessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean dbIsInitialized = false;

    public RenderProgressTrackingSqLiteAccessor(AbstractSqLiteDbConnector connectorProvider) {
        super(connectorProvider);
    }

    private void createTableTiles() {
        String createSql = "CREATE TABLE tiles (x INTEGER,y INTEGER,z INTEGER,rendered BOOLEAN,PRIMARY KEY (x, y, z));";
        this.executeSql(createSql);
    }

    @Override
    public void initTablesIfNecessary() {
        if (!this.dbIsInitialized) {
            this.log.info("initTablesIfNecessary: initializing sqlite db");
            this.setPragmas();
            boolean tableTilesExists = this.doesTableExist("tiles");
            if (!tableTilesExists) {
                this.log.info("initTablesIfNecessary: creating sqlite tables");
                this.createTableTiles();
                this.log.info("initTablesIfNecessary: created sqlite tables");
            }
            this.dbIsInitialized = true;
        }
    }

    public void setRendered(int x, int y, int zoom, boolean completed) {
        block4: {
            Connection connection = this.connectorProvider.getConnection();
            String sqlMetadata = "INSERT INTO tiles(x,y,z,rendered) VALUES(?,?,?,?);";
            try {
                if (connection == null || connection.isClosed()) break block4;
                PreparedStatement pstmt = connection.prepareStatement(sqlMetadata);
                pstmt.setInt(1, x);
                pstmt.setInt(2, y);
                pstmt.setInt(3, zoom);
                pstmt.setBoolean(4, completed);
                pstmt.executeUpdate();
                try {
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.error("setRendered: an sql exception occured", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRendered(int x, int y, int zoom) {
        Connection connection = this.connectorProvider.getConnection();
        String sqlMetadata = "SELECT rendered FROM tiles WHERE x=? AND y=? AND z=?;";
        Statement pstmt = null;
        try {
            if (connection != null && !connection.isClosed()) {
                pstmt = connection.prepareStatement(sqlMetadata);
                pstmt.setInt(1, x);
                pstmt.setInt(2, y);
                pstmt.setInt(3, zoom);
                ResultSet resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    boolean bl = resultSet.getBoolean("rendered");
                    return bl;
                }
            }
        }
        catch (Exception e) {
            this.log.error("isRendered: an exception occured", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null && !pstmt.isClosed()) {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                this.log.error("isRendered: Could not close prepared statement", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRenderedCount(int zoom, int tileIndexLeft, int tileIndexRight, int tileIndexTop, int tileIndexBottom) {
        Connection connection = this.connectorProvider.getConnection();
        String sqlMetadata = "SELECT count(*) as counted FROM tiles WHERE rendered=true AND z=? AND x>=? AND x<=? AND y>=? AND y<=?;";
        Statement pstmt = null;
        try {
            if (connection != null && !connection.isClosed()) {
                pstmt = connection.prepareStatement(sqlMetadata);
                pstmt.setInt(1, zoom);
                pstmt.setInt(2, tileIndexLeft);
                pstmt.setInt(3, tileIndexRight);
                pstmt.setInt(4, tileIndexTop);
                pstmt.setInt(5, tileIndexBottom);
                ResultSet resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    int counted = resultSet.getInt("counted");
                    long l = counted;
                    return l;
                }
            }
        }
        catch (SQLException e) {
            this.log.error("getRenderedCount: an sql exception occured", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null && !pstmt.isClosed()) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.error("getRenderedCount: Could not close prepared statement", (Throwable)e);
            }
        }
        return 0L;
    }

    public boolean isRendered(int zoom, int expectedCount, int tileIndexLeft, int tileIndexRight, int tileIndexTop, int tileIndexBottom) {
        long renderedCount = this.getRenderedCount(zoom, tileIndexLeft, tileIndexRight, tileIndexTop, tileIndexBottom);
        return renderedCount >= (long)expectedCount;
    }
}

