/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.blocking;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Circle;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.blocking.AbstractBlockingItem;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import java.util.ArrayList;

public class RenderTextLineItem
extends AbstractBlockingItem {
    protected ArrayList<Circle> boundingCircles = new ArrayList();

    public RenderTextLineItem(TextRowContainer textRowContainer, Point xyAnchor, double zoom, Point tileIndex, String description) {
        this.xyAnchor = xyAnchor;
        this.text = textRowContainer;
        this.zoom = zoom;
        this.tileIndex = tileIndex;
        this.description = description;
    }

    public void addBoundingCircle(Circle circle) {
        this.boundingCircles.add(circle);
        this.calculateBounds();
    }

    public ArrayList<Circle> getBoundingCircles() {
        return this.boundingCircles;
    }

    public void setBoundingCircles(ArrayList<Circle> boundingCircles) {
        this.boundingCircles = boundingCircles;
    }

    @Override
    public void calculateBounds() {
        if (this.boundingCircles.size() == 0) {
            return;
        }
        BoundingBox baseBounds = this.boundingCircles.get(0).getBoundingBox();
        for (int i = 1; i < this.boundingCircles.size(); ++i) {
            baseBounds.expand(this.boundingCircles.get(i).getBoundingBox());
        }
        this.bounds = baseBounds;
    }

    public String toString() {
        return "RenderTextLineItem[text=" + this.text + ", boundingCircles=" + this.boundingCircles + ", zoom=" + this.zoom + ", xyAnchor=" + this.xyAnchor + ", description=" + this.description + "]";
    }
}

