/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer.blocking;

import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.renderer.blocking.RenderTextLineItem;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import java.util.ArrayList;

public abstract class AbstractBlockingItem {
    protected TextRowContainer text;
    protected Point xyAnchor;
    protected ArrayList<BoundingBox> boundingBoxes = new ArrayList();
    protected BoundingBox bounds;
    protected double zoom;
    protected Point tileIndex;
    protected String description;

    public void addBoundingBox(BoundingBox boundingBox) {
        this.boundingBoxes.add(boundingBox);
        this.calculateBounds();
    }

    public ArrayList<BoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public void setBoundingBoxes(ArrayList<BoundingBox> boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
        this.calculateBounds();
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public TextRowContainer getText() {
        return this.text;
    }

    public void setText(TextRowContainer text) {
        this.text = text;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public Point getTileIndex() {
        return this.tileIndex;
    }

    public void setTileIndex(Point tileIndex) {
        this.tileIndex = tileIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Point getXyAnchor() {
        return this.xyAnchor;
    }

    public void setXyAnchor(Point xyAnchor) {
        this.xyAnchor = xyAnchor;
    }

    public void calculateBounds() {
        if (this.boundingBoxes.size() == 0) {
            return;
        }
        this.bounds = this.boundingBoxes.get(0).clone();
        for (int i = 1; i < this.boundingBoxes.size(); ++i) {
            this.bounds.expand(this.boundingBoxes.get(i));
        }
    }

    public boolean intersects(AbstractBlockingItem other) {
        if (this instanceof RenderTextLineItem) {
            RenderTextLineItem thisInstance = (RenderTextLineItem)this;
            if (other instanceof RenderTextLineItem) {
                RenderTextLineItem otherItem = (RenderTextLineItem)other;
                for (int i = 0; i < thisInstance.boundingCircles.size(); ++i) {
                    for (int j = 0; j < otherItem.boundingCircles.size(); ++j) {
                        if (!thisInstance.boundingCircles.get(i).intersects(otherItem.boundingCircles.get(j))) continue;
                        return true;
                    }
                }
            } else {
                for (int i = 0; i < thisInstance.boundingCircles.size(); ++i) {
                    for (int j = 0; j < other.boundingBoxes.size(); ++j) {
                        if (!thisInstance.boundingCircles.get(i).intersects(other.boundingBoxes.get(j))) continue;
                        return true;
                    }
                }
            }
        } else if (other instanceof RenderTextLineItem) {
            RenderTextLineItem otherItem = (RenderTextLineItem)other;
            for (int i = 0; i < this.boundingBoxes.size(); ++i) {
                for (int j = 0; j < otherItem.boundingCircles.size(); ++j) {
                    if (!this.boundingBoxes.get(i).intersects(otherItem.boundingCircles.get(j))) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < this.boundingBoxes.size(); ++i) {
                for (int j = 0; j < other.boundingBoxes.size(); ++j) {
                    if (!this.boundingBoxes.get(i).intersects(other.boundingBoxes.get(j))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public double getDistance(AbstractBlockingItem other) {
        if (this.bounds == null || other.bounds == null) {
            return Double.MAX_VALUE;
        }
        return this.bounds.getDistance(other.bounds);
    }
}

