/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmTileSymbolizerAccessor;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.file.FileLoader;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTileSymbolizerRenderer
extends AbstractSymbolizerRenderer
implements ImageObserver {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderTileImage(RenderRequest renderRequest, OsmTileSymbolizerAccessor tileSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        Optional<String> optionalBaseFolder = tileSymbolizer.getFolder();
        Optional<Float> opacity = tileSymbolizer.getOpacity();
        Optional<Boolean> optionalMockMissing = tileSymbolizer.getMockMissing();
        if (!optionalBaseFolder.isPresent()) {
            this.log.warn("renderTileImage: no base folder for the tiles is given. This is most likely a misconfiguration.");
            throw new RuntimeException("renderTileImage: no base folder for the tiles is given. This is most likely a misconfiguration.");
        }
        FileLoader fileLoader = new FileLoader();
        boolean mockMissing = optionalMockMissing.isPresent() && optionalMockMissing.get() != false;
        boolean verbose = !mockMissing;
        Optional<BufferedImage> optionalTileImage = fileLoader.loadOsmTile(renderRequest, optionalBaseFolder.get(), verbose);
        if (optionalTileImage.isPresent()) {
            BufferedImage tileImage = optionalTileImage.get();
            Graphics2D canvas = renderLayer.getCanvas();
            if (opacity.isPresent()) {
                AlphaComposite renderOpacity = AlphaComposite.getInstance(3, opacity.get().floatValue());
                canvas.setComposite(renderOpacity);
            }
            canvas.drawImage((Image)tileImage, 0, 0, this);
        } else if (!mockMissing) {
            throw new RuntimeException("renderTileImage: could not render tile due to missing input file");
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

