/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmShieldSymbolizerAccessor;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmTextBoxLayouter;
import de.wideportal.maprender.renderer.OsmTextPointRenderHints;
import de.wideportal.maprender.renderer.blocking.RenderMarkerItem;
import de.wideportal.maprender.renderer.blocking.RenderOverlapManager;
import de.wideportal.maprender.renderer.blocking.RenderShieldItem;
import de.wideportal.maprender.renderer.text.TextRow;
import de.wideportal.maprender.renderer.text.TextRowContainer;
import de.wideportal.maprender.renderer.text.TextRowEntry;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.fonts.FontContext;
import de.wideportal.maprender.resources.fonts.FontsUtil;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.symbols.SymbolsCache;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmShieldSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    public static final double SHIELD_TEXT_PADDING_WIDTH = 6.0;
    public static final double SHIELD_TEXT_PADDING_HEIGHT = 4.0;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private double[] shieldSizeWidthMappings = new double[]{16.0, 22.0, 28.0, 34.0, 40.0, 47.0, 53.0, 59.0, 65.0, 71.0, 78.0};
    private double[] shieldSizeHeightMappings = new double[]{18.0, 30.0, 42.0, 54.0};

    public void renderShieldSymbolizer(OsmShieldSymbolizerAccessor shieldSymbolizer, RenderImageLayer renderLayer, Point xyTilePixel, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        Graphics2D canvas = renderLayer.getCanvas();
        Graphics dummyCanvas = canvas.create();
        int minimumLineLength = 4;
        RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
        String textValue = this.extractText(shieldSymbolizer.getValue(), resultSetCache);
        if (textValue != null && !textValue.isBlank()) {
            Optional<String> optionalFile;
            Color colorHalo = shieldSymbolizer.getHaloFill();
            boolean isFillSet = shieldSymbolizer.isFillSet();
            boolean isForbidBorderPlacement = shieldSymbolizer.isForbidBorderPlacement();
            double spacing = shieldSymbolizer.getSpacing();
            double margin = shieldSymbolizer.getMargin();
            double zoomScaleMultiplicator = this.getZoomScaleMultiplicator(zoom, 1.05);
            double pixelSpacing = spacing * zoomScaleMultiplicator;
            double pixelMargin = margin;
            Optional<BasicStroke> textHaloStroke = this.getTextHaloStroke(shieldSymbolizer.getHaloRadius().floatValue());
            if (textHaloStroke.isPresent()) {
                canvas.setStroke(textHaloStroke.get());
            }
            AlphaComposite renderOpacity = AlphaComposite.getInstance(3, shieldSymbolizer.getOpacity().floatValue());
            canvas.setComposite(renderOpacity);
            Optional<String> optionalCDataFill = shieldSymbolizer.getFillCData();
            Color directColor = shieldSymbolizer.getFill();
            Color colorFill = this.extractColorFromCData(optionalCDataFill, directColor, resultSetCache, Float.valueOf(1.0f));
            if (isFillSet) {
                canvas.setColor(colorFill);
            }
            if (!(optionalFile = shieldSymbolizer.getFile()).isPresent()) {
                this.log.error("renderShieldSymbolizer: no symbol file given");
                throw new RuntimeException("renderShieldSymbolizer: no symbol file was given. This is most likely a misconfiguration.");
            }
            BufferedImage symbol = symbolsCache.getSymbol(optionalFile.get());
            if (symbol == null) {
                this.log.error("renderShieldSymbolizer: no symbol file available: " + optionalFile + ". Skip rendering of tile.");
                throw new RuntimeException("renderShieldSymbolizer: no symbol file available: " + optionalFile + ". Skip rendering of tile.");
            }
            BufferedImage maskedSymbol = symbol;
            int width = symbol.getWidth();
            int height = symbol.getHeight();
            Rectangle rectangleShapeTexture = new Rectangle((int)(xyTilePixel.getX() - (double)(width / 2)), (int)(xyTilePixel.y - (double)(height / 2)), width, height);
            BoundingBox symbolBoundingBox = new BoundingBox(rectangleShapeTexture, true);
            OsmTextBoxLayouter textBoxLayouter = new OsmTextBoxLayouter();
            textBoxLayouter.init(renderRequest, shieldSymbolizer, canvas, zoom);
            boolean foundPlacement = textBoxLayouter.calculateBestFittingPosition(textValue, xyTilePixel, pixelSpacing, pixelMargin, shieldSymbolizer.getPlacements(), symbolBoundingBox, minimumLineLength, isForbidBorderPlacement, renderRequest.getBoundingBoxPixel());
            if (!foundPlacement) {
                return;
            }
            OsmTextPointRenderHints textPointRenderHints = textBoxLayouter.getFoundTextPointRenderingHints();
            TextRowContainer textRows = textBoxLayouter.getTextRowContainer();
            BoundingBox textBBox = textBoxLayouter.getFoundBoundingBox();
            FontContext adjustedFontContext = textBoxLayouter.getFontContext();
            RenderMarkerItem renderMarkerItem = new RenderMarkerItem(symbolBoundingBox, xyTilePixel, zoom, renderRequest.getTileIndex(), textValue, textRows);
            RenderShieldItem renderShieldItem = textBoxLayouter.getFoundRenderShieldItem();
            allOverlapManager.addRenderShieldItem(renderShieldItem);
            allOverlapManager.addRenderMarkerItem(renderMarkerItem);
            TexturePaint texture = new TexturePaint(maskedSymbol, rectangleShapeTexture);
            canvas.setPaint(texture);
            canvas.fill(rectangleShapeTexture);
            int fontType = shieldSymbolizer.getFaceStyle();
            for (int i = 0; i < textRows.getTextRows().size(); ++i) {
                int letterWidth;
                Shape textShape;
                float getDescend;
                GlyphVector glyphVector;
                FontMetrics fontMetrics;
                Font font;
                FontContext dummyFontContext;
                String currentLetter;
                int t;
                String entryText;
                TextRowEntry entry;
                int k;
                double leftX;
                TextRow textRow = textRows.getTextRows().get(i);
                BoundingBox rowBBox = textPointRenderHints.getTextRowBoundingBox(textRow, i, textBBox);
                if (textHaloStroke.isPresent()) {
                    canvas.setColor(colorHalo);
                    leftX = rowBBox.getLeft();
                    for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                        entry = textRow.getTextRowEntries().get(k);
                        if (entry.getType() == 1) {
                            fontType = entry.getFaceStyle();
                            continue;
                        }
                        entryText = entry.getParsedText(textRow.getWrapCharacter());
                        for (t = 0; t < entryText.length(); ++t) {
                            currentLetter = "" + entryText.charAt(t);
                            dummyFontContext = adjustedFontContext.clone();
                            dummyFontContext.setFaceStyle(fontType);
                            font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                            canvas.setFont(font);
                            fontMetrics = canvas.getFontMetrics();
                            glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                            getDescend = fontMetrics.getMaxDescent();
                            textShape = glyphVector.getOutline((float)leftX - shieldSymbolizer.getHaloRadius().floatValue() / 2.0f, (float)rowBBox.getBottom() - getDescend);
                            canvas.draw(textShape);
                            letterWidth = fontMetrics.stringWidth(currentLetter);
                            leftX += (double)letterWidth;
                        }
                    }
                }
                canvas.setColor(colorFill);
                leftX = rowBBox.getLeft();
                for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                    entry = textRow.getTextRowEntries().get(k);
                    if (entry.getType() == 1) {
                        fontType = entry.getFaceStyle();
                        continue;
                    }
                    entryText = entry.getParsedText(textRow.getWrapCharacter());
                    for (t = 0; t < entryText.length(); ++t) {
                        currentLetter = "" + entryText.charAt(t);
                        dummyFontContext = adjustedFontContext.clone();
                        dummyFontContext.setFaceStyle(fontType);
                        font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                        canvas.setFont(font);
                        fontMetrics = canvas.getFontMetrics();
                        glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                        getDescend = fontMetrics.getMaxDescent();
                        textShape = glyphVector.getOutline((float)leftX, (float)rowBBox.getBottom() - getDescend);
                        canvas.fill(textShape);
                        letterWidth = fontMetrics.stringWidth(currentLetter);
                        leftX += (double)letterWidth;
                    }
                }
            }
        }
        dummyCanvas.dispose();
    }

    public void renderShieldSymbolizer(OsmShieldSymbolizerAccessor shieldSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, SymbolsCache symbolsCache, RenderResultSetCache resultSetCache, RenderRequest renderRequest, OsmRuleAccessor rule) {
        Graphics2D canvas = renderLayer.getCanvas();
        int minimumLineLength = 0;
        String textValue = this.extractText(shieldSymbolizer.getValue(), resultSetCache);
        if (textValue != null && !textValue.isBlank()) {
            Color colorHalo = shieldSymbolizer.getHaloFill();
            boolean isFillSet = shieldSymbolizer.isFillSet();
            boolean isForbidBorderPlacement = shieldSymbolizer.isForbidBorderPlacement();
            double spacing = shieldSymbolizer.getSpacing();
            double repeatDistance = shieldSymbolizer.getRepeatDistance();
            double margin = shieldSymbolizer.getMargin();
            double zoomScaleMultiplicator = this.getZoomScaleMultiplicator(zoom, 1.05);
            double pixelSpacing = spacing * zoomScaleMultiplicator;
            double pixelRepeating = repeatDistance * zoomScaleMultiplicator;
            double pixelMargin = margin;
            Optional<BasicStroke> textHaloStroke = this.getTextHaloStroke(shieldSymbolizer.getHaloRadius().floatValue());
            if (textHaloStroke.isPresent()) {
                canvas.setStroke(textHaloStroke.get());
            }
            AlphaComposite renderOpacity = AlphaComposite.getInstance(3, shieldSymbolizer.getOpacity().floatValue());
            canvas.setComposite(renderOpacity);
            Optional<String> optionalCDataFill = shieldSymbolizer.getFillCData();
            Color directColor = shieldSymbolizer.getFill();
            Color colorFill = this.extractColorFromCData(optionalCDataFill, directColor, resultSetCache, Float.valueOf(1.0f));
            if (isFillSet) {
                canvas.setColor(colorFill);
            }
            OsmTextBoxLayouter textBoxLayouter = new OsmTextBoxLayouter();
            textBoxLayouter.init(renderRequest, shieldSymbolizer, canvas, zoom);
            textBoxLayouter.calculateBestFittingPosition(textValue, new Point(0.0, 0.0), pixelSpacing, pixelMargin, shieldSymbolizer.getPlacements(), minimumLineLength, isForbidBorderPlacement, renderRequest.getBoundingBoxPixel());
            OsmTextPointRenderHints textPointRenderHints = textBoxLayouter.getFoundTextPointRenderingHints();
            TextRowContainer textRows = textBoxLayouter.getTextRowContainer();
            BoundingBox textBBox = textBoxLayouter.getFoundBoundingBox();
            FontContext adjustedFontContext = textBoxLayouter.getFontContext();
            textBBox.increaseBBox(6.0, 4.0);
            Point[] xyTilePoints = this.convertMercatorLineStringToTilePoints(mercatorLineString.getPoints(), xOffset, yOffset, zoom, tileOutputter, geoCalculator);
            LineSequence lineSequence = new LineSequence(xyTilePoints);
            LineSequence.NextPointOnLineIterator<Point> nextShieldRenderPointIterator = lineSequence.getIterator(pixelRepeating > 0.0 ? pixelRepeating : textBBox.getRadius(), pixelMargin);
            double textBBoxWidth = textBBox.getWidth();
            double textBBoxHeight = textBBox.getHeight();
            textBBox.decreaseBBox(6.0, 4.0);
            Point bestFittingSymbolWidthHeight = this.getBestFittingSymbolWidthHeight(textBBoxWidth - 1.0, textBBoxHeight - 1.0);
            Optional<String> optionalFile = shieldSymbolizer.getFile();
            if (optionalFile.isPresent()) {
                String symbolFileName = this.getWidthHeightSymbolFileName(optionalFile.get(), bestFittingSymbolWidthHeight);
                BufferedImage symbol = symbolsCache.getSymbol(symbolFileName);
                while (nextShieldRenderPointIterator.hasNext()) {
                    Point xyTilePixel = nextShieldRenderPointIterator.next();
                    textBBox.centerTo(xyTilePixel);
                    RenderShieldItem renderShieldItem = new RenderShieldItem(textBBox, xyTilePixel, zoom, renderRequest.getTileIndex(), shieldSymbolizer.toString(), textRows);
                    RenderOverlapManager allOverlapManager = renderRequest.getRenderOverlapManager();
                    if (allOverlapManager.hasOverlappingItemsShieldSpacing(renderShieldItem, true, true, true, true, pixelSpacing, pixelMargin, textValue)) {
                        return;
                    }
                    if (isForbidBorderPlacement && !allOverlapManager.isInTile(renderShieldItem, renderRequest.getBoundingBoxPixel())) continue;
                    allOverlapManager.addRenderShieldItem(renderShieldItem);
                    BufferedImage maskedSymbol = symbol;
                    if (isFillSet) {
                        // empty if block
                    }
                    double effectiveSymbolWidthHeightRation = (double)symbol.getWidth() / (double)symbol.getHeight();
                    textBBoxHeight = Math.floor(textBBoxWidth / effectiveSymbolWidthHeightRation);
                    double rectX = xyTilePixel.getX() - textBBoxWidth / 2.0;
                    double rectY = xyTilePixel.getY() - textBBoxHeight / 2.0;
                    Rectangle rectangleShape = new Rectangle((int)rectX, (int)rectY, (int)textBBoxWidth, (int)textBBoxHeight);
                    Rectangle rectangleShapeTexture = new Rectangle((int)rectX, (int)rectY, (int)textBBoxWidth - 1, (int)textBBoxHeight - 1);
                    TexturePaint texture = new TexturePaint(maskedSymbol, rectangleShapeTexture);
                    canvas.setPaint(texture);
                    canvas.fill(rectangleShape);
                    int fontType = shieldSymbolizer.getFaceStyle();
                    for (int i = 0; i < textRows.getTextRows().size(); ++i) {
                        int letterWidth;
                        Shape textShape;
                        float getDescend;
                        GlyphVector glyphVector;
                        FontMetrics fontMetrics;
                        Font font;
                        FontContext dummyFontContext;
                        String currentLetter;
                        int t;
                        String entryText;
                        TextRowEntry entry;
                        int k;
                        double leftX;
                        TextRow textRow = textRows.getTextRows().get(i);
                        BoundingBox rowBBox = textPointRenderHints.getTextRowBoundingBox(textRow, i, textBBox);
                        if (textHaloStroke.isPresent()) {
                            canvas.setColor(colorHalo);
                            leftX = rowBBox.getLeft();
                            for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                                entry = textRow.getTextRowEntries().get(k);
                                if (entry.getType() == 1) {
                                    fontType = entry.getFaceStyle();
                                    continue;
                                }
                                entryText = entry.getParsedText(textRow.getWrapCharacter());
                                for (t = 0; t < entryText.length(); ++t) {
                                    currentLetter = "" + entryText.charAt(t);
                                    dummyFontContext = adjustedFontContext.clone();
                                    dummyFontContext.setFaceStyle(fontType);
                                    font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                                    canvas.setFont(font);
                                    fontMetrics = canvas.getFontMetrics();
                                    glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                                    getDescend = fontMetrics.getMaxDescent();
                                    textShape = glyphVector.getOutline((float)leftX - shieldSymbolizer.getHaloRadius().floatValue() / 2.0f, (float)rowBBox.getBottom() - getDescend);
                                    canvas.draw(textShape);
                                    letterWidth = fontMetrics.stringWidth(currentLetter);
                                    leftX += (double)letterWidth;
                                }
                            }
                        }
                        canvas.setColor(colorFill);
                        leftX = rowBBox.getLeft();
                        for (k = 0; k < textRow.getTextRowEntries().size(); ++k) {
                            entry = textRow.getTextRowEntries().get(k);
                            if (entry.getType() == 1) {
                                fontType = entry.getFaceStyle();
                                continue;
                            }
                            entryText = entry.getParsedText(textRow.getWrapCharacter());
                            for (t = 0; t < entryText.length(); ++t) {
                                currentLetter = "" + entryText.charAt(t);
                                dummyFontContext = adjustedFontContext.clone();
                                dummyFontContext.setFaceStyle(fontType);
                                font = FontsUtil.getBestFittingFont(dummyFontContext, currentLetter);
                                canvas.setFont(font);
                                fontMetrics = canvas.getFontMetrics();
                                glyphVector = font.createGlyphVector(canvas.getFontRenderContext(), currentLetter);
                                getDescend = fontMetrics.getMaxDescent();
                                textShape = glyphVector.getOutline((float)leftX, (float)rowBBox.getBottom() - getDescend);
                                canvas.fill(textShape);
                                letterWidth = fontMetrics.stringWidth(currentLetter);
                                leftX += (double)letterWidth;
                            }
                        }
                    }
                }
            }
        }
    }

    private Point getBestFittingSymbolWidthHeight(double width, double height) {
        double ratio = width / height;
        double bestFitRatioDiff = Double.MAX_VALUE;
        int bestFitWidth = -1;
        int bestFitHeight = -1;
        for (int i = 1; i <= 11; ++i) {
            for (int j = 1; j <= 4; ++j) {
                double currentRatio = this.shieldSizeWidthMappings[i - 1] / this.shieldSizeHeightMappings[j - 1];
                double currentRatioDiff = Math.max(currentRatio, ratio) - Math.min(currentRatio, ratio);
                if (!(currentRatioDiff < bestFitRatioDiff)) continue;
                bestFitRatioDiff = currentRatioDiff;
                bestFitWidth = i;
                bestFitHeight = j;
            }
        }
        return new Point(bestFitWidth, bestFitHeight);
    }

    private String getWidthHeightSymbolFileName(String symbolFileNameWithPlaceholders, Point bestFittingSymbolWidthHeight) {
        String symbolFileName = symbolFileNameWithPlaceholders.replaceAll("\\[width\\]", "" + (int)bestFittingSymbolWidthHeight.getX()).replaceAll("\\[height\\]", "" + (int)bestFittingSymbolWidthHeight.getY());
        return symbolFileName;
    }
}

