/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.RenderConfigurationProcessing;
import de.wideportal.maprender.config.xml.RenderConfigurationProcessingLayers;
import de.wideportal.maprender.config.xml.osm.OsmDatasource;
import de.wideportal.maprender.config.xml.osm.OsmHeightColorSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightFakeDepthSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightLinesSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightProfileSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightRoadSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightSurroundReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmKmlSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLayer;
import de.wideportal.maprender.config.xml.osm.OsmLinePatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLineSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmMarkersSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmParameter;
import de.wideportal.maprender.config.xml.osm.OsmPolygonPatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonTileSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmShieldSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.OsmTextSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmTileSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.OsmLayerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmStyleAccessor;
import de.wideportal.maprender.config.xml.osm.compop.AbstractOsmStyleImageCompOp;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilter;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterResult;
import de.wideportal.maprender.config.xml.osm.imagefilter.AbstractOsmStyleImageFilter;
import de.wideportal.maprender.config.xml.osm.imagefilter.LicenseWatermarkFilter;
import de.wideportal.maprender.datasource.DBCacheRenderResultSetCache;
import de.wideportal.maprender.datasource.DatasourceGeometryFactory;
import de.wideportal.maprender.datasource.DatasourceRequest;
import de.wideportal.maprender.datasource.FakeRenderResultSetCache;
import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.datasource.RenderResultSetCache;
import de.wideportal.maprender.datasource.dbcache.DBCache;
import de.wideportal.maprender.datasource.dbcache.DBCacheEntry;
import de.wideportal.maprender.datasource.dbcache.DBCacheLayer;
import de.wideportal.maprender.datasource.dbcache.DBCacheLine;
import de.wideportal.maprender.datasource.kml.KmlLineString;
import de.wideportal.maprender.datasource.osm.PostgresCache;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.datasource.osm.PostgresMultiLineString;
import de.wideportal.maprender.datasource.osm.PostgresMultiPolygon;
import de.wideportal.maprender.datasource.osm.PostgresPoint;
import de.wideportal.maprender.datasource.osm.PostgresPolygon;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.licenselib.LicenseContainer;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.metrics.PerformanceMetrics;
import de.wideportal.maprender.metrics.StopWatch;
import de.wideportal.maprender.renderer.CanvasStash;
import de.wideportal.maprender.renderer.OsmHeightColorSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightFakeDepthSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightLinesSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightProfileSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightReliefSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightRoadSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmHeightSurroundReliefSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmKmlSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmLinePatternSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmLineSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmMarkersSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmPolygonPatternSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmPolygonSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmPolygonTileSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmShieldSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmTextSymbolizerRenderer;
import de.wideportal.maprender.renderer.OsmTileSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.request.RenderRequestJobProgress;
import de.wideportal.maprender.request.RenderRequestZoomLevelProgress;
import de.wideportal.maprender.resources.kml.KmlFile;
import de.wideportal.maprender.resources.kml.KmlFileCache;
import de.wideportal.maprender.resources.kml.KmlResultSet;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbAccessor;
import de.wideportal.maprender.resources.sqlitedb.SqLiteDbConnector;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmRenderer {
    public static final String GEOMETRY_FIELD = "rendererOsmGeometry";
    public static final String NO_GEOMETRY = "noGeometry";
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void render(RenderRequest renderRequest, DatasourceRequest datasourceRequest) {
        boolean useMetric = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getMetrics();
        StopWatch logWatch = StopWatch.start(useMetric);
        logWatch.stop(useMetric);
        renderRequest.getThreadPerformanceMetrics().addMetric("tile-render-log", logWatch, useMetric);
        DBCache dbCache = new DBCache();
        boolean useDBCache = false;
        if (renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources() != null && renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getDbCache() != null) {
            useDBCache = true;
        }
        if (useDBCache) {
            dbCache = DBCache.load(renderRequest);
        }
        StopWatch renderWatch = StopWatch.start(useMetric);
        boolean useSqliteDBAsInput = false;
        if (renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources() != null && renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getSqLiteDb() != null) {
            useSqliteDBAsInput = true;
        }
        if (useSqliteDBAsInput) {
            SqLiteDbConnector sqliteDbConnector = (SqLiteDbConnector)renderRequest.getConnectableResourceManager().getConnectableResource(SqLiteDbConnector.class);
            SqLiteDbAccessor sqliteDbInputAccessor = new SqLiteDbAccessor(sqliteDbConnector);
            this.extractTileFromSqliteDB(renderRequest, sqliteDbInputAccessor);
        } else {
            boolean saveDBCache;
            for (OsmLayer layer : renderRequest.getOsmMap().getLayers()) {
                this.renderLayer(layer.getAccessor(), renderRequest, datasourceRequest, dbCache);
            }
            RenderConfigurationProcessing processing = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing();
            if (processing.getDebugmeta() != null && processing.getDebugmeta().booleanValue()) {
                this.paintTileDebugInfos(renderRequest, true);
            } else if (processing.getDebugtiles() != null && processing.getDebugtiles().booleanValue()) {
                this.paintTileDebugInfos(renderRequest, false);
            }
            renderWatch.stop(useMetric);
            renderRequest.getThreadPerformanceMetrics().addMetric("tile-render-total", renderWatch, useMetric);
            boolean bl = saveDBCache = renderRequest.getOsmMap().getJob().getOutput().getDbCache() != null;
            if (saveDBCache) {
                dbCache.persist(renderRequest);
            }
        }
        StopWatch saveWatch = StopWatch.start(useMetric);
        this.addLicenseWatermark(renderRequest);
        renderRequest.saveRenderedImage();
        this.logProgress(renderRequest);
        saveWatch.stop(useMetric);
        renderRequest.getThreadPerformanceMetrics().addMetric("tile-render-save", saveWatch, useMetric);
    }

    private synchronized void logProgress(RenderRequest renderRequest) {
        int tileLogModule = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getTilelogmodulo();
        String remainingTimeZoom = this.getEstimatedRemainingTimeZoom(renderRequest);
        String jobName = renderRequest.getJobProgressMonitor().getJobName();
        long zoom = (long)renderRequest.getZoomInfo().getZoom();
        RenderRequestZoomLevelProgress zoomProgress = renderRequest.getJobProgressMonitor().getZoomLevelProgress(zoom);
        long zoomProgressDone = zoomProgress.getTilesDone() + 1L;
        long zoomProgressCount = zoomProgress.getTilesCount();
        long jobProgressDone = renderRequest.getJobProgressMonitor().getTilesDone() + 1L;
        long jobProgressCount = renderRequest.getJobProgressMonitor().getTilesCount();
        if (renderRequest.getRenderRequestNumber() % (long)tileLogModule == 0L) {
            this.log.info("job: " + jobName + " / zoom: " + zoom + " / zoomProgress: " + zoomProgressDone + " of " + zoomProgressCount + ", rest: ~" + remainingTimeZoom + " / jobProgress: " + jobProgressDone + " of " + jobProgressCount + " / tileIndex=" + renderRequest.getTileIndex() + " / bbox" + renderRequest.getBoundingBoxLatLon() + ", scaleDenom=" + renderRequest.getScaleDenominator());
        }
    }

    private void extractTileFromSqliteDB(RenderRequest renderRequest, SqLiteDbAccessor sqliteDbInputAccessor) {
        int x = (int)renderRequest.getTileIndex().getX();
        int y = (int)renderRequest.getTileIndex().getY();
        int zoom = (int)renderRequest.getZoomInfo().getZoom();
        int zoomInverted = 17 - zoom;
        byte[] imageBytes = sqliteDbInputAccessor.getTile(x, y, zoomInverted);
        try {
            renderRequest.getRenderImage().getBaseLayer().recreateFromByteArray(imageBytes);
        }
        catch (Exception e) {
            this.log.error("extractTileFromSqliteDB: Exception occured when trying to create new image layer from SQLiteDB blob", (Throwable)e);
        }
    }

    private boolean isLayerInScaleDenominator(double currentScaleDenominator, double minimumScaleDenominatorLayer, double maximumScaleDenominatorLayer) {
        if (currentScaleDenominator < minimumScaleDenominatorLayer) {
            return false;
        }
        return !(currentScaleDenominator > maximumScaleDenominatorLayer);
    }

    private void renderLayer(OsmLayerAccessor layer, RenderRequest renderRequest, DatasourceRequest datasourceRequest, DBCache dbCache) {
        boolean useMetric = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getMetrics();
        Optional<String> optionalLayerName = layer.getName();
        StopWatch layerWatch = StopWatch.start(useMetric);
        long maxSecondsBeforeWarning = 60L;
        long timestampLayerStart = System.currentTimeMillis();
        double zoom = renderRequest.getZoomInfo().getZoom();
        RenderConfigurationProcessingLayers processingLayers = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getLayers();
        if (processingLayers != null && processingLayers.shouldSkipLayer(optionalLayerName)) {
            this.log.debug("renderLayer: skip layer " + optionalLayerName);
            return;
        }
        this.log.debug("renderLayer: render layer " + optionalLayerName);
        double minimumScaleDenominatorLayer = layer.getFromOptionalOrElse(layer.getMinimumScaleDenominator(), 0.0);
        double maximumScaleDenominatorLayer = layer.getFromOptionalOrElse(layer.getMaximumScaleDenominator(), (double)Double.MAX_VALUE);
        double scaleDenominator = renderRequest.getScaleDenominator();
        boolean hasCollisionElements = layer.hasCollisionElements();
        if (!this.isLayerInScaleDenominator(scaleDenominator, minimumScaleDenominatorLayer, maximumScaleDenominatorLayer)) {
            return;
        }
        if (optionalLayerName.isPresent()) {
            if ("debug".equalsIgnoreCase(optionalLayerName.get())) {
                this.paintTileDebugInfos(renderRequest, true);
                return;
            }
            if ("tiles".equalsIgnoreCase(optionalLayerName.get())) {
                this.paintTileDebugInfos(renderRequest, false);
                return;
            }
        }
        Optional<OsmDatasource> optionalDatasource = layer.getDatasource();
        boolean useDBCache = false;
        if (renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources() != null && renderRequest.getRenderConfiguration().getMaprenderConfiguration().getDatasources().getDbCache() != null) {
            useDBCache = true;
        }
        if (useDBCache) {
            try {
                this.renderStyleFilters(renderRequest, layer, null, dbCache);
            }
            catch (SQLException e) {
                throw new RuntimeException("renderLayer: could not read ResultSet from cached db file", e);
            }
        }
        if (!optionalDatasource.isPresent()) {
            try {
                this.renderStyleFilters(renderRequest, layer, null, null);
            }
            catch (SQLException e) {
                throw new RuntimeException("renderLayer: could not read ResultSet. Which is strange since we should be in the case without datasource.", e);
            }
        }
        Optional<OsmParameter> tableParameter = optionalDatasource.get().findParameter("table");
        Optional<OsmParameter> geometryFieldParameter = optionalDatasource.get().findParameter("geometry_field");
        Optional<OsmParameter> kmlParameter = optionalDatasource.get().findParameter("kml");
        if (kmlParameter.isPresent()) {
            boolean skipRendering = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().isSkiprendering();
            if (!skipRendering) {
                String kmlFileName = kmlParameter.get().getValue();
                if (kmlFileName == null || kmlFileName.isBlank()) {
                    this.log.warn("renderLayer: no kml file is given. This is most likely a misconfiguration.");
                    throw new RuntimeException("renderLayer: no kml file was given. This is most likely a misconfiguration.");
                }
                KmlFileCache kmlFileCache = renderRequest.getKmlFileCache();
                Optional<KmlFile> optionalKmlFile = kmlFileCache.getKmlFile(kmlFileName);
                if (!optionalKmlFile.isPresent()) {
                    this.log.warn("renderLayer: no KML file available: " + kmlFileName + ". Skip kml rendering of layer.");
                    throw new RuntimeException("renderLayer: no KML file available: " + kmlFileName + ". Skip kml rendering of layer.");
                }
                KmlFile kmlFile = optionalKmlFile.get();
                KmlResultSet kmlResultSet = new KmlResultSet();
                List<KmlLineString> kmlLineStrings = kmlFile.getKmlLineStrings();
                for (KmlLineString kmlLineString : kmlLineStrings) {
                    ArrayList<String> header = new ArrayList<String>();
                    header.add(GEOMETRY_FIELD);
                    header.add("styleUrl");
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(kmlLineString.convertToPostgresGeometry(renderRequest.getGeoCalculator()));
                    values.add(kmlLineString.getStyleUrl());
                    kmlResultSet.addEntry(header, values);
                }
                try {
                    this.renderStyleFilters(renderRequest, layer, kmlResultSet, dbCache);
                }
                catch (SQLException e) {
                    throw new RuntimeException("renderLayer: could not reander KmlResultSet", e);
                }
            }
        } else if (tableParameter.isPresent() && geometryFieldParameter.isPresent()) {
            StopWatch dbAccessWatch = StopWatch.start(useMetric);
            AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
            BoundingBox mercatorTile = renderRequest.getBoundingBoxMercator();
            BoundingBox latLonTile = renderRequest.getBoundingBoxLatLon();
            BoundingBox mercatorTileAdjusted = mercatorTile;
            if (hasCollisionElements) {
                mercatorTileAdjusted = new BoundingBox(mercatorTile.getLeft() - 1.1 * mercatorTile.getWidth(), mercatorTile.getBottom() - 1.1 * mercatorTile.getHeight(), mercatorTile.getRight() + 1.1 * mercatorTile.getWidth(), mercatorTile.getTop() + 1.1 * mercatorTile.getHeight());
            }
            double meterPerPixel = tileOutputter.getMeterPerPixel(zoom, latLonTile.getCenter().getY());
            long timestampSqlStart = System.currentTimeMillis();
            String capsulatedQuery = null;
            Optional<Object> result = Optional.empty();
            boolean useOverCaching = layer.getOverCaching().isPresent();
            if (useOverCaching) {
                int overCachingFactor = layer.getOverCaching().get();
                double bboxWidth = mercatorTileAdjusted.getWidth();
                double bboxHeight = mercatorTileAdjusted.getHeight();
                BoundingBox increasedSizeForCacheBBox = mercatorTile.clone();
                increasedSizeForCacheBBox.increaseBBox(bboxWidth * (double)overCachingFactor, bboxHeight * (double)overCachingFactor);
                capsulatedQuery = this.createSqlQuery(renderRequest, increasedSizeForCacheBBox, zoom, meterPerPixel, tableParameter, geometryFieldParameter);
                String cachingKeyFromSqlQuery = this.getCachingKeyFromSqlQuery(capsulatedQuery);
                Optional<ResultSet> optionalCachedResultSet = renderRequest.getPostgresCache().getResultSet(cachingKeyFromSqlQuery, mercatorTileAdjusted);
                if (optionalCachedResultSet.isPresent()) {
                    result = optionalCachedResultSet;
                } else {
                    result = datasourceRequest.createResultSet(capsulatedQuery);
                    renderRequest.getPostgresCache().addToCache(cachingKeyFromSqlQuery, increasedSizeForCacheBBox, (ResultSet)result.get());
                }
            } else {
                capsulatedQuery = this.createSqlQuery(renderRequest, mercatorTileAdjusted, zoom, meterPerPixel, tableParameter, geometryFieldParameter);
                result = datasourceRequest.createResultSet(capsulatedQuery);
            }
            long timestampSqlStop = System.currentTimeMillis();
            double durationSqlQuery = (double)(timestampSqlStop - timestampSqlStart) / 1000.0;
            if (durationSqlQuery > (double)maxSecondsBeforeWarning) {
                String jobName = renderRequest.getJobProgressMonitor().getJobName();
                this.log.warn("job: " + jobName + " / zoom: " + zoom + " / long duration of sql query: " + durationSqlQuery + "s, layer=" + layer.getName());
            }
            dbAccessWatch.stop(useMetric);
            renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-layer-resultset", dbAccessWatch, useMetric);
            if (result.isPresent()) {
                ResultSet resultSet = (ResultSet)result.get();
                try {
                    long timestampRenderStop;
                    double durationRendering;
                    boolean skipRendering;
                    boolean saveDBCache;
                    long timestampRenderStart = System.currentTimeMillis();
                    boolean bl = saveDBCache = renderRequest.getOsmMap().getJob().getOutput().getDbCache() != null;
                    if (saveDBCache) {
                        this.addDBCacheLayer(dbCache, resultSet, optionalLayerName);
                    }
                    if (!(skipRendering = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().isSkiprendering())) {
                        this.renderStyleFilters(renderRequest, layer, resultSet, dbCache);
                    }
                    if ((durationRendering = (double)((timestampRenderStop = System.currentTimeMillis()) - timestampRenderStart) / 1000.0) > (double)maxSecondsBeforeWarning) {
                        String jobName = renderRequest.getJobProgressMonitor().getJobName();
                        this.log.warn("job: " + jobName + " / zoom: " + (int)zoom + " / long duration of rendering: " + durationRendering + "s, layer=" + layer.getName());
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException("renderLayer: could not render layer due to an exception. Zoom=" + renderRequest.getZoomInfo().getZoom() + ", tile=" + renderRequest.getTileIndex(), e);
                }
                finally {
                    datasourceRequest.closeResultSet(resultSet);
                }
            }
        }
        layerWatch.stop(useMetric);
        long timestampLayerStop = System.currentTimeMillis();
        double durationLayer = (double)(timestampLayerStop - timestampLayerStart) / 1000.0;
        if (durationLayer > (double)maxSecondsBeforeWarning) {
            String jobName = renderRequest.getJobProgressMonitor().getJobName();
            this.log.debug("job: " + jobName + " / zoom: " + zoom + " / long duration of layer: " + durationLayer + "s, layer=" + layer.getName());
        }
        renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-layer", layerWatch, useMetric);
    }

    private String createSqlQuery(RenderRequest renderRequest, BoundingBox mercatorTileAdjusted, double zoom, double meterPerPixel, Optional<OsmParameter> tableParameter, Optional<OsmParameter> geometryFieldParameter) {
        String bbox = "ST_MakeEnvelope(" + mercatorTileAdjusted.left + "," + mercatorTileAdjusted.bottom + "," + mercatorTileAdjusted.right + "," + mercatorTileAdjusted.top + ",3857)";
        String query = tableParameter.get().getValue();
        String geometryField = geometryFieldParameter.get().getValue();
        Object capsulatedQuery = "SELECT ST_AsText(" + geometryField + ") rendererOsmGeometry, * FROM " + query + " WHERE " + geometryField + " && ST_MakeEnvelope (" + mercatorTileAdjusted.getLeft() + ", " + mercatorTileAdjusted.getBottom() + ", " + mercatorTileAdjusted.getRight() + ", " + mercatorTileAdjusted.getTop() + ", 3857);";
        capsulatedQuery = ((String)capsulatedQuery).replaceAll("!pixel_width!", "" + meterPerPixel);
        capsulatedQuery = ((String)capsulatedQuery).replaceAll("!pixel_height!", "" + meterPerPixel);
        capsulatedQuery = ((String)capsulatedQuery).replaceAll("!scale_denominator!", "" + renderRequest.getScaleDenominator());
        capsulatedQuery = ((String)capsulatedQuery).replaceAll("!bbox!", bbox);
        renderRequest.setCapsulatedQuery((String)capsulatedQuery);
        renderRequest.setCapsulatedQueryBBox(bbox);
        this.log.debug("renderLayer: capsulatedQueryBBox = " + bbox);
        return capsulatedQuery;
    }

    private String getCachingKeyFromSqlQuery(String capsulatedQuery) {
        return capsulatedQuery.substring(0, capsulatedQuery.lastIndexOf("WHERE "));
    }

    private void addDBCacheLayer(DBCache dbCache, ResultSet resultSet, Optional<String> optionalLayerName) throws SQLException {
        if (dbCache != null && resultSet != null && optionalLayerName.isPresent()) {
            DBCacheLayer cacheLayer = new DBCacheLayer(optionalLayerName.orElse(""));
            resultSet.beforeFirst();
            int resultSetRow = -1;
            while (resultSet.next()) {
                DBCacheLine dbCacheLine = new DBCacheLine(++resultSetRow);
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = resultSet.getMetaData().getColumnLabel(i);
                    int columnType = resultSet.getMetaData().getColumnType(i);
                    String columnTypeName = resultSet.getMetaData().getColumnTypeName(i);
                    Object value = resultSet.getObject(columnName);
                    DBCacheEntry dbCacheEntry = new DBCacheEntry(i, columnType, columnTypeName, columnName, value);
                    dbCacheLine.addDBCacheEntry(dbCacheEntry);
                }
                cacheLayer.addCacheLine(dbCacheLine);
            }
            if (resultSetRow == 0) {
                this.log.debug("createDBCacheFile: resultset had no entries");
            }
            dbCache.addCacheLayer(cacheLayer);
        }
    }

    private void renderStyleFilters(RenderRequest renderRequest, OsmLayerAccessor layer, ResultSet resultSet, DBCache dbCache) throws SQLException {
        boolean useMetric = renderRequest.getRenderConfiguration().getMaprenderConfiguration().getProcessing().getMetrics();
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        List<OsmStyle> styles = layer.getStyles();
        for (int i = 0; i < styles.size(); ++i) {
            RenderImageLayer baseLayer;
            OsmStyle rawStyle = styles.get(i);
            OsmStyleAccessor style = rawStyle.getAccessor();
            RenderImageLayer renderLayer = baseLayer = renderRequest.getRenderImage().getBaseLayer();
            RenderImageLayer opacityLayer = null;
            Optional<Float> styleOpacity = style.getOpacity();
            if (styleOpacity.isPresent()) {
                opacityLayer = renderRequest.getRenderImage().createLayer("LAYER_OPACITY", tileOutputter.getTileSize());
                opacityLayer.setOpacity(styleOpacity.get());
                renderLayer = opacityLayer;
            }
            RenderImageLayer compOpLayer = null;
            Optional<AbstractOsmStyleImageCompOp> optionalCompOp = style.getCompOp();
            if (optionalCompOp.isPresent()) {
                renderLayer = compOpLayer = renderRequest.getRenderImage().createLayer("LAYER_COMP_OP", tileOutputter.getTileSize());
            }
            RenderImageLayer filterLayer = null;
            ArrayList<AbstractOsmStyleImageFilter> styleFilters = style.getImageFilters();
            if (styleFilters.size() > 0) {
                renderLayer = filterLayer = renderRequest.getRenderImage().createLayer("LAYER_FILTER", tileOutputter.getTileSize());
            }
            RenderImageLayer baseFilterLayer = null;
            ArrayList<AbstractOsmStyleImageFilter> styleBaseFilters = style.getBaseImageFilters();
            if (styleBaseFilters.size() > 0) {
                renderLayer = baseFilterLayer = renderRequest.getRenderImage().createLayer("LAYER_BASE_FILTER", tileOutputter.getTileSize());
            }
            int totalNumberOfRulesMatched = 0;
            if (resultSet != null) {
                renderResultSetWatch = StopWatch.start(useMetric);
                resultSet.beforeFirst();
                int resultSetRow = -1;
                while (resultSet.next()) {
                    ++resultSetRow;
                    RenderResultSetCache resultSetCache = new RenderResultSetCache(resultSet);
                    int ruleMatchCount = this.renderStyle(renderLayer, style, resultSetCache, layer, renderRequest);
                    totalNumberOfRulesMatched += ruleMatchCount;
                }
                if (resultSetRow == 0) {
                    this.log.debug("renderStyleFilters: resultset had no entries");
                }
                renderResultSetWatch.stop(useMetric);
                renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-stylefilter-alldb", renderResultSetWatch, useMetric);
            } else if (dbCache != null) {
                renderResultSetWatch = StopWatch.start(useMetric);
                DBCacheLayer cacheLayer = dbCache.getCacheLayer(layer.getName().orElse(""));
                if (cacheLayer == null) continue;
                ArrayList<DBCacheLine> cacheLines = cacheLayer.getCacheLines();
                int resultSetRow = -1;
                for (int j = 0; j < cacheLines.size(); ++j) {
                    DBCacheLine cacheLine = cacheLines.get(j);
                    ++resultSetRow;
                    DBCacheRenderResultSetCache resultSetCache = new DBCacheRenderResultSetCache(cacheLine);
                    int ruleMatchCount = this.renderStyle(renderLayer, style, resultSetCache, layer, renderRequest);
                    totalNumberOfRulesMatched += ruleMatchCount;
                }
                if (resultSetRow == 0) {
                    this.log.debug("renderStyleFilters: resultset had no entries");
                }
                renderResultSetWatch.stop(useMetric);
                renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-stylefilter-alldb", renderResultSetWatch, useMetric);
            } else {
                StopWatch renderDBLessWatch = StopWatch.start(useMetric);
                FakeRenderResultSetCache fakeResultSetCache = new FakeRenderResultSetCache();
                int ruleMatchCount = this.renderStyle(renderLayer, style, fakeResultSetCache, layer, renderRequest);
                totalNumberOfRulesMatched += ruleMatchCount;
                renderDBLessWatch.stop(useMetric);
                renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-stylefilter-alldbless", renderDBLessWatch, useMetric);
            }
            StopWatch renderFilterWatch = StopWatch.start(useMetric);
            if (baseFilterLayer != null) {
                if (totalNumberOfRulesMatched > 0) {
                    this.log.debug("renderStyleFilters: styleBaseFilters found with #" + totalNumberOfRulesMatched + " matching rules. Style=" + style.getName());
                    for (AbstractOsmStyleImageFilter filter : styleBaseFilters) {
                        filter.applyFilter(baseLayer);
                    }
                    renderRequest.getRenderImage().mergeBackLayer(baseFilterLayer);
                } else {
                    this.log.debug("renderStyleFilters: styleBaseFilters found but no rules matched. Discarding filter layer. Style=" + style.getName());
                    renderRequest.getRenderImage().discardLayer(baseFilterLayer);
                }
            }
            if (filterLayer != null) {
                if (totalNumberOfRulesMatched > 0) {
                    this.log.debug("renderStyleFilters: styleFilters found with #" + totalNumberOfRulesMatched + " matching rules. Style=" + style.getName());
                    for (AbstractOsmStyleImageFilter filter : styleFilters) {
                        filter.applyFilter(filterLayer);
                    }
                    renderRequest.getRenderImage().mergeBackLayer(filterLayer);
                } else {
                    this.log.debug("renderStyleFilters: styleFilters found but no rules matched. Discarding filter layer. Style=" + style.getName());
                    renderRequest.getRenderImage().discardLayer(filterLayer);
                }
            }
            if (compOpLayer != null) {
                if (totalNumberOfRulesMatched > 0) {
                    this.log.debug("renderStyleFilters: compOp found with #" + totalNumberOfRulesMatched + " matching rules. Style=" + style.getName());
                    AbstractOsmStyleImageCompOp compOp = optionalCompOp.get();
                    boolean mergeLayerBackToBase = compOp.applyCompOp(compOpLayer, baseLayer);
                    if (mergeLayerBackToBase) {
                        renderRequest.getRenderImage().mergeBackLayer(compOpLayer);
                    } else {
                        renderRequest.getRenderImage().discardLayer(compOpLayer);
                    }
                } else {
                    this.log.debug("renderStyleFilters: compOp found but no rules matched. Discarding filter layer. Style=" + style.getName());
                    renderRequest.getRenderImage().discardLayer(compOpLayer);
                }
            }
            if (opacityLayer != null) {
                if (totalNumberOfRulesMatched > 0) {
                    this.log.debug("renderStyleFilters: opacityLayer found with #" + totalNumberOfRulesMatched + " matching rules. Style=" + style.getName());
                    renderRequest.getRenderImage().mergeBackLayer(opacityLayer);
                } else {
                    this.log.debug("renderStyleFilters: opacityLayer found but no rules matched. Discarding filter layer. Style=" + style.getName());
                    renderRequest.getRenderImage().discardLayer(opacityLayer);
                }
            }
            renderFilterWatch.stop(useMetric);
            renderRequest.getThreadPerformanceMetrics().addMetric("tile-rendertree-stylefilter-allfilters", renderFilterWatch, useMetric);
        }
    }

    private ArrayList<OsmRule> getMatchingRules(OsmStyleAccessor style, RenderResultSetCache resultSetCache, RenderRequest renderRequest) throws SQLException {
        double currentScaleDenominator = renderRequest.getScaleDenominator();
        List<OsmRule> rules = style.getRules();
        ArrayList<OsmRule> matchingRules = new ArrayList<OsmRule>();
        for (int j = 0; j < rules.size(); ++j) {
            OsmRule rawRule = rules.get(j);
            OsmRuleAccessor rule = rawRule.getAccessor();
            OsmRuleFilter filter = rule.getRuleFilter();
            OsmRuleFilterResult matchResult = filter.matchesResultSet(resultSetCache, currentScaleDenominator);
            if (!matchResult.matches()) continue;
            rawRule.setRuleFilterResult(matchResult);
            matchingRules.add(rawRule);
            if ("first".equalsIgnoreCase(style.getFilterMode())) break;
        }
        return matchingRules;
    }

    private int renderStyle(RenderImageLayer renderLayer, OsmStyleAccessor style, RenderResultSetCache resultSetCache, OsmLayerAccessor layer, RenderRequest renderRequest) throws SQLException {
        long resultSetRow = resultSetCache.getRow();
        String geometry = resultSetCache.getString(GEOMETRY_FIELD);
        ArrayList<OsmRule> matchingRules = this.getMatchingRules(style, resultSetCache, renderRequest);
        if (matchingRules.size() > 0) {
            this.renderResult(renderLayer, resultSetCache, resultSetRow, geometry, style, matchingRules, renderRequest, layer);
        }
        return matchingRules.size();
    }

    private void renderResult(RenderImageLayer renderLayer, RenderResultSetCache resultSetCache, long resultSetRow, String geometry, OsmStyleAccessor style, ArrayList<OsmRule> matchingRules, RenderRequest renderRequest, OsmLayerAccessor layer) {
        this.log.debug("renderResult: row #" + resultSetRow + ", matchingRules=#" + matchingRules.size());
        if (NO_GEOMETRY.equals(geometry)) {
            this.paintNoGeometry(renderLayer, matchingRules, renderRequest, layer);
        } else {
            PostgresCache postgresCache = renderRequest.getPostgresCache();
            Optional<IDatasourceGeometry> optionalGeometry = DatasourceGeometryFactory.getFittingGeometry(geometry, postgresCache);
            if (optionalGeometry.isPresent()) {
                IDatasourceGeometry geomInterface = optionalGeometry.get();
                if (geomInterface instanceof PostgresPoint) {
                    PostgresPoint geom = (PostgresPoint)optionalGeometry.get();
                    this.paintPoint(renderLayer, geom, resultSetCache, resultSetRow, geometry, matchingRules, renderRequest, layer);
                } else if (geomInterface instanceof PostgresLineString) {
                    PostgresLineString geom = (PostgresLineString)optionalGeometry.get();
                    this.paintLineString(renderLayer, geom, resultSetCache, resultSetRow, geometry, matchingRules, renderRequest, layer);
                } else if (geomInterface instanceof PostgresMultiLineString) {
                    PostgresMultiLineString geom = (PostgresMultiLineString)optionalGeometry.get();
                    for (PostgresLineString subGeom : geom.getLineStrings()) {
                        this.paintLineString(renderLayer, subGeom, resultSetCache, resultSetRow, geometry, matchingRules, renderRequest, layer);
                    }
                } else if (geomInterface instanceof PostgresPolygon) {
                    PostgresPolygon geom = (PostgresPolygon)optionalGeometry.get();
                    this.paintPolygon(renderLayer, geom, resultSetCache, resultSetRow, geometry, matchingRules, renderRequest, layer);
                } else if (geomInterface instanceof PostgresMultiPolygon) {
                    PostgresMultiPolygon geom = (PostgresMultiPolygon)optionalGeometry.get();
                    for (PostgresPolygon subGeom : geom.getPolygons()) {
                        this.paintPolygon(renderLayer, subGeom, resultSetCache, resultSetRow, geometry, matchingRules, renderRequest, layer);
                    }
                }
            } else {
                this.log.warn("renderResult: unknown geometry: " + geometry + " / \n" + renderRequest.getCapsulatedQuery());
            }
        }
    }

    private void paintNoGeometry(RenderImageLayer renderLayer, ArrayList<OsmRule> matchingRules, RenderRequest renderRequest, OsmLayerAccessor layer) {
        OsmHeightColorSymbolizerRenderer osmHeightColorSymbolizerRenderer = new OsmHeightColorSymbolizerRenderer();
        OsmHeightLinesSymbolizerRenderer osmHeightLinesSymbolizerRenderer = new OsmHeightLinesSymbolizerRenderer();
        OsmHeightReliefSymbolizerRenderer osmHeightReliefSymbolizerRenderer = new OsmHeightReliefSymbolizerRenderer();
        OsmHeightSurroundReliefSymbolizerRenderer osmHeightSurroundReliefSymbolizerRenderer = new OsmHeightSurroundReliefSymbolizerRenderer();
        OsmHeightFakeDepthSymbolizerRenderer osmHeightFakeDepthSymbolizerRenderer = new OsmHeightFakeDepthSymbolizerRenderer();
        OsmHeightProfileSymbolizerRenderer osmHeightProfileSymbolizerRenderer = new OsmHeightProfileSymbolizerRenderer();
        OsmTileSymbolizerRenderer osmTileSymbolizerRenderer = new OsmTileSymbolizerRenderer();
        OsmKmlSymbolizerRenderer osmKmlSymbolizerRenderer = new OsmKmlSymbolizerRenderer();
        LicenseContainer license = renderRequest.getLicense();
        boolean licenseConstraintHeightAllowed = license.getFromOptionalOrElse(license.safeParseBoolean(license.getOptionalLicenseEntry("feature-height")), true);
        boolean licenseConstraintKmlAllowed = license.getFromOptionalOrElse(license.safeParseBoolean(license.getOptionalLicenseEntry("feature-kml")), true);
        boolean licenseConstraintTileLoadAllowed = license.getFromOptionalOrElse(license.safeParseBoolean(license.getOptionalLicenseEntry("feature-tileload")), true);
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        GeoCalculator geoCalculator = renderRequest.getGeoCalculator();
        Point tileIndex = renderRequest.getTileIndex();
        double xOffset = tileIndex.getX() * (double)tileOutputter.getTileSize();
        double yOffset = tileIndex.getY() * (double)tileOutputter.getTileSize();
        double zoom = renderRequest.getZoomInfo().getZoom();
        for (OsmRule rawRule : matchingRules) {
            CanvasStash canvasStash;
            OsmRuleAccessor rule = rawRule.getAccessor();
            Graphics2D canvas = renderLayer.getCanvas();
            for (OsmHeightColorSymbolizer heightColorSymbolizer : rule.getHeightColorSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightColorSymbolizerRenderer.renderHeight(renderRequest, heightColorSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightLinesSymbolizer heightLinesSymbolizer : rule.getHeightLinesSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightLinesSymbolizerRenderer.renderHeight(renderRequest, heightLinesSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightReliefSymbolizer heightReliefSymbolizer : rule.getHeightReliefSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightReliefSymbolizerRenderer.renderHeight(renderRequest, heightReliefSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightSurroundReliefSymbolizer heightSurroundReliefSymbolizer : rule.getHeightSurroundReliefSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow surround height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightSurroundReliefSymbolizerRenderer.renderHeight(renderRequest, heightSurroundReliefSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightFakeDepthSymbolizer heightFakeDepthSymbolizer : rule.getHeightFakeDepthSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow surround height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightFakeDepthSymbolizerRenderer.renderHeight(renderRequest, heightFakeDepthSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightProfileSymbolizer heightProfileSymbolizer : rule.getHeightProfileSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow height rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightProfileSymbolizerRenderer.renderHeight(renderRequest, heightProfileSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmTileSymbolizer tileSymbolizer : rule.getTileSymbolizers()) {
                if (!licenseConstraintTileLoadAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow tileload rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmTileSymbolizerRenderer.renderTileImage(renderRequest, tileSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmKmlSymbolizer kmlSymbolizer : rule.getKmlSymbolizers()) {
                if (!licenseConstraintKmlAllowed) {
                    this.log.warn("paintNoGeometry: license does not allow kml rendering");
                    continue;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmKmlSymbolizerRenderer.renderKml(renderRequest, kmlSymbolizer.getAccessor(), renderLayer, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
        }
    }

    private void paintPolygon(RenderImageLayer renderLayer, PostgresPolygon geom, RenderResultSetCache resultSetCache, long resultSetRow, String geometry, ArrayList<OsmRule> matchingRules, RenderRequest renderRequest, OsmLayerAccessor layer) {
        OsmPolygonSymbolizerRenderer osmPolygonSymbolizerRenderer = new OsmPolygonSymbolizerRenderer();
        OsmPolygonPatternSymbolizerRenderer osmPolygonPatternSymbolizerRenderer = new OsmPolygonPatternSymbolizerRenderer();
        OsmPolygonTileSymbolizerRenderer osmPolygonTileSymbolizerRenderer = new OsmPolygonTileSymbolizerRenderer();
        OsmLineSymbolizerRenderer osmLineSymbolizerRenderer = new OsmLineSymbolizerRenderer();
        OsmTextSymbolizerRenderer osmTextSymbolizerRenderer = new OsmTextSymbolizerRenderer();
        GeoCalculator geoCalculator = renderRequest.getGeoCalculator();
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        Point tileIndex = renderRequest.getTileIndex();
        double xOffset = tileIndex.getX() * (double)tileOutputter.getTileSize();
        double yOffset = tileIndex.getY() * (double)tileOutputter.getTileSize();
        double zoom = renderRequest.getZoomInfo().getZoom();
        BoundingBox polygonBBox = geom.getBoundingBox(false);
        Point point = geoCalculator.convertMercatorToLatLon(polygonBBox.getCenter());
        Point xyTilePixel = tileOutputter.getLonLatToPixel(point.getX(), point.getY(), renderRequest.getZoomInfo().getZoom());
        xyTilePixel.x -= xOffset;
        xyTilePixel.y -= yOffset;
        for (OsmRule rawRule : matchingRules) {
            CanvasStash canvasStash;
            OsmRuleAccessor rule = rawRule.getAccessor();
            Graphics2D canvas = renderLayer.getCanvas();
            for (OsmPolygonSymbolizer polygonSymbolizer : rule.getPolygonSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmPolygonSymbolizerRenderer.renderPolygonSymbolizer(polygonSymbolizer.getAccessor(), renderLayer, geom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmPolygonPatternSymbolizer polygonPatternSymbolizer : rule.getPolygonPatternSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmPolygonPatternSymbolizerRenderer.renderPolygonPatternSymbolizer(polygonPatternSymbolizer.getAccessor(), renderLayer, geom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), rule, renderRequest, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmPolygonTileSymbolizer polygonTileSymbolizer : rule.getPolygonTileSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmPolygonTileSymbolizerRenderer.renderPolygonTileSymbolizer(polygonTileSymbolizer.getAccessor(), renderLayer, geom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmLineSymbolizer lineSymbolizer : rule.getLineSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmLineSymbolizerRenderer.renderLineSymbolizer(lineSymbolizer.getAccessor(), renderLayer, geom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, resultSetCache);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmTextSymbolizer textSymbolizer : rule.getTextSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                if (textSymbolizer.getAccessor().getPlacement().equals("interior") || textSymbolizer.getAccessor().getPlacement().equals("point")) {
                    osmTextSymbolizerRenderer.renderTextSymbolizer(textSymbolizer.getAccessor(), renderLayer, xyTilePixel, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule);
                } else if (textSymbolizer.getAccessor().getPlacement().equals("line")) {
                    osmTextSymbolizerRenderer.renderTextSymbolizer(textSymbolizer.getAccessor(), renderLayer, geom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule);
                }
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
        }
    }

    private void paintLineString(RenderImageLayer renderLayer, PostgresLineString mercatorLineString, RenderResultSetCache resultSetCache, long resultSetRow, String geometry, ArrayList<OsmRule> matchingRules, RenderRequest renderRequest, OsmLayerAccessor layer) {
        OsmLineSymbolizerRenderer osmLineSymbolizerRenderer = new OsmLineSymbolizerRenderer();
        OsmLinePatternSymbolizerRenderer osmLinePatternSymbolizerRenderer = new OsmLinePatternSymbolizerRenderer();
        OsmShieldSymbolizerRenderer osmShieldSymbolizerRenderer = new OsmShieldSymbolizerRenderer();
        OsmTextSymbolizerRenderer osmTextSymbolizerRenderer = new OsmTextSymbolizerRenderer();
        OsmMarkersSymbolizerRenderer osmMarkersSymbolizerRenderer = new OsmMarkersSymbolizerRenderer();
        OsmHeightRoadSymbolizerRenderer osmHeightRoadSymbolizerRenderer = new OsmHeightRoadSymbolizerRenderer();
        OsmPolygonSymbolizerRenderer osmPolygonSymbolizerRenderer = new OsmPolygonSymbolizerRenderer();
        OsmPolygonTileSymbolizerRenderer osmPolygonTileSymbolizerRenderer = new OsmPolygonTileSymbolizerRenderer();
        LicenseContainer license = renderRequest.getLicense();
        boolean licenseConstraintHeightAllowed = license.getFromOptionalOrElse(license.safeParseBoolean(license.getOptionalLicenseEntry("feature-height")), true);
        GeoCalculator geoCalculator = renderRequest.getGeoCalculator();
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        Point tileIndex = renderRequest.getTileIndex();
        double xOffset = tileIndex.getX() * (double)tileOutputter.getTileSize();
        double yOffset = tileIndex.getY() * (double)tileOutputter.getTileSize();
        double zoom = renderRequest.getZoomInfo().getZoom();
        block0: for (OsmRule rawRule : matchingRules) {
            PostgresPolygon polygonGeom;
            CanvasStash canvasStash;
            OsmRuleAccessor rule = rawRule.getAccessor();
            Graphics2D canvas = renderLayer.getCanvas();
            for (OsmPolygonSymbolizer polygonSymbolizer : rule.getPolygonSymbolizers()) {
                if (!mercatorLineString.isClosedPolygon() || !polygonSymbolizer.getAccessor().getUseClosedLines().booleanValue()) continue;
                canvasStash = CanvasStash.saveCanvas(canvas);
                polygonGeom = new PostgresPolygon(mercatorLineString);
                osmPolygonSymbolizerRenderer.renderPolygonSymbolizer(polygonSymbolizer.getAccessor(), renderLayer, polygonGeom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmPolygonTileSymbolizer polygonTileSymbolizer : rule.getPolygonTileSymbolizers()) {
                if (!mercatorLineString.isClosedPolygon() || !polygonTileSymbolizer.getAccessor().getUseClosedLines().booleanValue()) continue;
                canvasStash = CanvasStash.saveCanvas(canvas);
                polygonGeom = new PostgresPolygon(mercatorLineString);
                osmPolygonTileSymbolizerRenderer.renderPolygonTileSymbolizer(polygonTileSymbolizer.getAccessor(), renderLayer, polygonGeom, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, renderRequest, layer);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmLineSymbolizer lineSymbolizer : rule.getLineSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmLineSymbolizerRenderer.renderLineSymbolizer(lineSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule, resultSetCache);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmLinePatternSymbolizer linePatternSymbolizer : rule.getLinePatternSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmLinePatternSymbolizerRenderer.renderLinePatternSymbolizer(linePatternSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmTextSymbolizer textSymbolizer : rule.getTextSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmTextSymbolizerRenderer.renderTextSymbolizer(textSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmShieldSymbolizer shieldSymbolizer : rule.getShieldSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmShieldSymbolizerRenderer.renderShieldSymbolizer(shieldSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), resultSetCache, renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmMarkersSymbolizer markersSymbolizer : rule.getMarkersSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmMarkersSymbolizerRenderer.renderMarkersSymbolizer(markersSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmHeightRoadSymbolizer heightRoadSymbolizer : rule.getHeightRoadSymbolizers()) {
                if (!licenseConstraintHeightAllowed) {
                    this.log.warn("paintLineString: license does not allow height rendering");
                    continue block0;
                }
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmHeightRoadSymbolizerRenderer.renderHeight(renderRequest, heightRoadSymbolizer.getAccessor(), renderLayer, mercatorLineString, xOffset, yOffset, zoom, tileOutputter, geoCalculator, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
        }
    }

    private void paintPoint(RenderImageLayer renderLayer, PostgresPoint geom, RenderResultSetCache resultSetCache, long resultSetRow, String geometry, ArrayList<OsmRule> matchingRules, RenderRequest renderRequest, OsmLayerAccessor layer) {
        OsmTextSymbolizerRenderer osmTextSymbolizerRenderer = new OsmTextSymbolizerRenderer();
        OsmShieldSymbolizerRenderer osmShieldSymbolizerRenderer = new OsmShieldSymbolizerRenderer();
        OsmMarkersSymbolizerRenderer osmMarkersSymbolizerRenderer = new OsmMarkersSymbolizerRenderer();
        GeoCalculator geoCalculator = renderRequest.getGeoCalculator();
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        Point tileIndex = renderRequest.getTileIndex();
        double xOffset = tileIndex.getX() * (double)tileOutputter.getTileSize();
        double yOffset = tileIndex.getY() * (double)tileOutputter.getTileSize();
        double zoom = renderRequest.getZoomInfo().getZoom();
        PostgresPoint latLonPoint = geoCalculator.convertMercatorToLatLon(geom);
        Point point = latLonPoint.getPoint();
        Point xyTilePixel = tileOutputter.getLonLatToPixel(point.getX(), point.getY(), renderRequest.getZoomInfo().getZoom());
        xyTilePixel.x -= xOffset;
        xyTilePixel.y -= yOffset;
        for (OsmRule rawRule : matchingRules) {
            CanvasStash canvasStash;
            OsmRuleAccessor rule = rawRule.getAccessor();
            Graphics2D canvas = renderLayer.getCanvas();
            for (OsmShieldSymbolizer shieldSymbolizer : rule.getShieldSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmShieldSymbolizerRenderer.renderShieldSymbolizer(shieldSymbolizer.getAccessor(), renderLayer, xyTilePixel, xOffset, yOffset, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), resultSetCache, renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmMarkersSymbolizer markerSymbolizer : rule.getMarkersSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmMarkersSymbolizerRenderer.renderMarkersSymbolizer(markerSymbolizer.getAccessor(), renderLayer, xyTilePixel, zoom, tileOutputter, geoCalculator, renderRequest.getRenderConfiguration().getSymbolsCache(), renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
            for (OsmTextSymbolizer textSymbolizer : rule.getTextSymbolizers()) {
                canvasStash = CanvasStash.saveCanvas(canvas);
                osmTextSymbolizerRenderer.renderTextSymbolizer(textSymbolizer.getAccessor(), renderLayer, xyTilePixel, zoom, tileOutputter, geoCalculator, resultSetCache, renderRequest, rule);
                CanvasStash.restoreCanvas(canvas, canvasStash);
            }
        }
    }

    private void paintTileDebugInfos(RenderRequest renderRequest, boolean showCoords) {
        this.log.debug("paintTileDebugInfos:");
        Graphics2D canvas = renderRequest.getRenderImage().getLayer("LAYER_BASE").getCanvas();
        CanvasStash canvasStash = CanvasStash.saveCanvas(canvas);
        AbstractMapTileOutput tileOutputter = renderRequest.getTileOutputter();
        long tileSize = tileOutputter.getTileSize();
        canvas.setColor(Color.BLACK);
        canvas.setFont(new Font("Arial", 0, 10));
        canvas.drawRect(0, 0, (int)tileSize, (int)tileSize);
        if (showCoords) {
            int zoom = (int)renderRequest.getZoomInfo().getZoom();
            canvas.drawString("z=" + zoom, 10, 20);
            Point tileIndex = renderRequest.getTileIndex();
            canvas.drawString("x=" + (int)tileIndex.getX() + ", y=" + (int)tileIndex.getY(), 10, 30);
            BoundingBox latLon = renderRequest.getBoundingBoxLatLon();
            canvas.drawString("lt=[" + latLon.getLeft() + ", " + latLon.getTop() + "]", 10, 40);
            canvas.drawString("rb=[" + latLon.getRight() + ", " + latLon.getBottom() + "]", 10, 50);
            canvas.drawString("c=[" + latLon.getCenter().getX() + ", " + latLon.getCenter().getY() + "]", 10, 60);
            canvas.drawLine((int)(tileSize / 2L - 5L), (int)(tileSize / 2L - 5L), (int)(tileSize / 2L + 5L), (int)(tileSize / 2L + 5L));
            canvas.drawLine((int)(tileSize / 2L - 5L), (int)(tileSize / 2L + 5L), (int)(tileSize / 2L + 5L), (int)(tileSize / 2L - 5L));
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String timestamp = formatter.format(new Date());
            canvas.drawString(timestamp, 10, 70);
        }
        CanvasStash.restoreCanvas(canvas, canvasStash);
    }

    public String getEstimatedRemainingTimeZoom(RenderRequest renderRequest) {
        long zoom = (long)renderRequest.getZoomInfo().getZoom();
        RenderRequestJobProgress jobProgressMonitor = renderRequest.getJobProgressMonitor();
        RenderRequestZoomLevelProgress zoomProgressMonitor = jobProgressMonitor.getZoomLevelProgress(zoom);
        long totalZoomTiles = zoomProgressMonitor.getTilesCount();
        long doneZoomTiles = zoomProgressMonitor.getTilesDone();
        long doneAtStartZoomTiles = zoomProgressMonitor.getTilesDoneAtStart();
        long tilesDoneWithoutAtStart = doneZoomTiles - doneAtStartZoomTiles;
        String remainingTime = "unknown";
        if (tilesDoneWithoutAtStart > 0L) {
            double zoomLevelStartTimestampNanos = renderRequest.getZoomLevelStartTimestampNanos();
            double currentTimestamp = System.nanoTime();
            double currentDurationNanos = currentTimestamp - zoomLevelStartTimestampNanos;
            double averageTileDurationInZoomLevelNanos = currentDurationNanos / (double)tilesDoneWithoutAtStart;
            double remainingZoomLevelTiles = totalZoomTiles - doneZoomTiles;
            double remainingTimeNanos = remainingZoomLevelTiles * averageTileDurationInZoomLevelNanos;
            remainingTime = PerformanceMetrics.formatDuration(remainingTimeNanos);
        }
        return remainingTime;
    }

    private void addLicenseWatermark(RenderRequest renderRequest) {
        LicenseWatermarkFilter watermarkFilter = new LicenseWatermarkFilter(renderRequest);
        watermarkFilter.applyFilter(renderRequest.getRenderImage().getBaseLayer());
    }
}

