/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightFakeDepthSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightFakeDepthSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightFakeDepthSymbolizerAccessor heightFakeDepthSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        int y;
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        int xTileIndex;
        boolean renderMockTiles = true;
        int flattenNoise = 0;
        int flattenPointNoise = 0;
        int maxHeight = 10000;
        int minHeight = -12000;
        double sunrayDirectionClockwise = heightFakeDepthSymbolizer.getSunrayDirectionClockwise();
        double sunHeightDegree = heightFakeDepthSymbolizer.getShadowSunHeightDegree();
        double shadowBaseIntensity = heightFakeDepthSymbolizer.getShadowBaseIntensity();
        int shadowFuzzyRadius = heightFakeDepthSymbolizer.getShadowFuzzyRadius();
        int sunrayDampening = heightFakeDepthSymbolizer.getSunrayDampening();
        Color shadowColor = heightFakeDepthSymbolizer.getColor();
        int smoothingRadius = 1;
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        HeightCollectorTile[] heightCollectorTiles = heightTileAccessor.collectSurroundingValues((int)zoom, xTileIndex = (int)renderRequest.getTileIndex().getX(), yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, flattenNoise, flattenPointNoise, tileOutputter);
        if (heightCollectorTiles == null) {
            this.log.error("renderHeight: could not render shadow because the heightCollectorTile was null");
            return;
        }
        int tileSize = tileOutputter.getTileSize();
        float[][] heightMap = new float[tileSize * 3][tileSize * 3];
        int counter = 0;
        float currentMaxHeight = Float.MIN_VALUE;
        for (int yTile = 0; yTile < 3; ++yTile) {
            for (int xTile = 0; xTile < 3; ++xTile) {
                HeightCollectorTile heightCollectorTile = heightCollectorTiles[counter];
                ++counter;
                if (heightCollectorTile != null) {
                    currentMaxHeight = Math.max(heightCollectorTile.getMaxValue(), currentMaxHeight);
                }
                int yTileOffset = tileSize * yTile;
                int xTileOffset = tileSize * xTile;
                for (int y2 = 0; y2 < tileSize; ++y2) {
                    for (int x = 0; x < tileSize; ++x) {
                        heightMap[yTileOffset + y2][xTileOffset + x] = heightCollectorTile != null ? heightCollectorTile.getMaxValue(x, y2) : 0.0f;
                    }
                }
            }
        }
        currentMaxHeight += 10.0f;
        float[][] lightMap = new float[tileSize * 3][tileSize * 3];
        float[][] lightCountMap = new float[tileSize * 3][tileSize * 3];
        float[][] shadowMap = new float[tileSize * 3][tileSize * 3];
        float[][] shadowMapSmoothed = new float[tileSize * 3][tileSize * 3];
        double xLength = Math.sin(Math.toRadians(sunrayDirectionClockwise));
        double yLength = Math.cos(Math.toRadians(sunrayDirectionClockwise));
        double slope = -1.0 * Math.sin(Math.toRadians(sunHeightDegree));
        double meterPerPixel = 80000.0 / (2.0 * zoom);
        boolean backTraceLineIsUnderMaxHeight = true;
        float backTraceHeightStart = 0.0f;
        int backTraceLineStep = 1;
        int backTraceLineX = 0;
        int backTraceLineY = 0;
        while (backTraceLineIsUnderMaxHeight) {
            double xShift = 0.0;
            double yShift = 0.0;
            if (sunrayDirectionClockwise == 0.0 || sunrayDirectionClockwise == 360.0) {
                xShift = 0.0;
                yShift = 1.0;
            } else if (sunrayDirectionClockwise == 90.0) {
                xShift = -1.0;
                yShift = 0.0;
            } else if (sunrayDirectionClockwise == 180.0) {
                xShift = 0.0;
                yShift = -1.0;
            } else if (sunrayDirectionClockwise == 270.0) {
                xShift = 1.0;
                yShift = 0.0;
            } else {
                xShift = (double)backTraceLineStep * -xLength;
                yShift = (double)backTraceLineStep * yLength;
            }
            backTraceLineX = (int)Math.round(xShift);
            backTraceLineY = (int)Math.round(yShift);
            double backTraceLineFloorLengthX = Math.abs(backTraceLineX);
            double backTraceLineFloorLengthY = Math.abs(backTraceLineY);
            double backTraceLineFloorLength = Math.sqrt(Math.pow(backTraceLineFloorLengthX, 2.0) + Math.pow(backTraceLineFloorLengthY, 2.0));
            double backTraceLineHeightPixel = backTraceLineFloorLength * -slope;
            double backTraceLineHeightPixelMeter = backTraceLineHeightPixel * meterPerPixel;
            double backTraceLineHeightMeter = (double)backTraceHeightStart + backTraceLineHeightPixelMeter;
            ++backTraceLineStep;
            if (!(backTraceLineHeightMeter >= (double)currentMaxHeight)) continue;
            break;
        }
        int traceLineOversizeX = Math.abs(backTraceLineX) + 10;
        int traceLineOversizeY = Math.abs(backTraceLineY) + 10;
        int heightMapSize = heightMap.length;
        for (y = -traceLineOversizeY; y < heightMapSize + traceLineOversizeY; ++y) {
            block6: for (int x = -traceLineOversizeX; x < heightMapSize + traceLineOversizeX; ++x) {
                boolean traceLineIsOverMinHeight = true;
                float heightStart = currentMaxHeight;
                int traceLineStep = 1;
                while (traceLineIsOverMinHeight) {
                    float mapHeight;
                    double xShift = 0.0;
                    double yShift = 0.0;
                    if (sunrayDirectionClockwise == 0.0 || sunrayDirectionClockwise == 360.0) {
                        xShift = 0.0;
                        yShift = -1.0;
                    } else if (sunrayDirectionClockwise == 90.0) {
                        xShift = 1.0;
                        yShift = 0.0;
                    } else if (sunrayDirectionClockwise == 180.0) {
                        xShift = 0.0;
                        yShift = 1.0;
                    } else if (sunrayDirectionClockwise == 270.0) {
                        xShift = -1.0;
                        yShift = 0.0;
                    } else {
                        xShift = (double)traceLineStep * xLength;
                        yShift = (double)traceLineStep * yLength;
                    }
                    int traceLineX = (int)Math.round((double)x + xShift);
                    int traceLineY = (int)Math.round((double)y - yShift);
                    double traceLineFloorLengthX = Math.abs(traceLineX - x);
                    double traceLineFloorLengthY = Math.abs(traceLineY - y);
                    double traceLineFloorLength = Math.sqrt(Math.pow(traceLineFloorLengthX, 2.0) + Math.pow(traceLineFloorLengthY, 2.0));
                    double traceLineHeightPixel = traceLineFloorLength * slope;
                    double traceLineHeightPixelMeter = traceLineHeightPixel * meterPerPixel;
                    double traceLineHeightMeter = (double)heightStart + traceLineHeightPixelMeter;
                    ++traceLineStep;
                    if (traceLineX >= heightMapSize + traceLineOversizeX || traceLineX < -traceLineOversizeX || traceLineY >= heightMapSize + traceLineOversizeY || traceLineY < -traceLineOversizeY || traceLineHeightMeter <= (double)minHeight) continue block6;
                    if (traceLineX >= heightMapSize || traceLineX < 0 || traceLineY >= heightMapSize || traceLineY < 0 || !((double)(mapHeight = heightMap[traceLineY][traceLineX]) >= traceLineHeightMeter)) continue;
                    for (double fuzzyY = (double)(-shadowFuzzyRadius); fuzzyY <= (double)shadowFuzzyRadius; fuzzyY += 1.0) {
                        for (double fuzzyX = (double)(-shadowFuzzyRadius); fuzzyX <= (double)shadowFuzzyRadius; fuzzyX += 1.0) {
                            if ((double)traceLineY + fuzzyY < 0.0 || (double)traceLineX + fuzzyX < 0.0 || (double)traceLineY + fuzzyY >= (double)lightMap.length || (double)traceLineX + fuzzyX >= (double)lightMap.length) continue;
                            double distance = Math.sqrt(Math.pow(fuzzyX, 2.0) + Math.pow(fuzzyY, 2.0));
                            float distanceLight = 0.0f;
                            if (distance == 0.0) {
                                distanceLight = 1.0f;
                            } else {
                                double degree = 0.0;
                                if (fuzzyX == 0.0) {
                                    degree = fuzzyY < 0.0 ? 0.0 : 180.0;
                                } else if (fuzzyY == 0.0) {
                                    degree = fuzzyX < 0.0 ? 270.0 : 90.0;
                                } else {
                                    degree = Math.toDegrees(Math.atan(fuzzyY / fuzzyX)) + 90.0;
                                    if (fuzzyX < 0.0) {
                                        degree += 180.0;
                                    }
                                }
                                double compareDegree = Math.abs(degree - sunrayDirectionClockwise);
                                boolean isBefore = compareDegree > 90.0;
                                distance = Math.max(distance, 1.0);
                                distanceLight = (float)((double)0.9f / Math.pow(distance, 1.0));
                                float fuzzyHeight = heightMap[traceLineY + (int)fuzzyY][traceLineX + (int)fuzzyX];
                                if (isBefore ? (double)fuzzyHeight > (double)mapHeight + traceLineHeightPixelMeter / 2.0 : fuzzyHeight < mapHeight) continue;
                            }
                            float[] fArray = lightMap[traceLineY + (int)fuzzyY];
                            int n = traceLineX + (int)fuzzyX;
                            fArray[n] = fArray[n] + distanceLight;
                            float[] fArray2 = lightCountMap[traceLineY + (int)fuzzyY];
                            int n2 = traceLineX + (int)fuzzyX;
                            fArray2[n2] = fArray2[n2] + 1.0f;
                        }
                    }
                }
            }
        }
        for (y = 0 - smoothingRadius; y < tileSize + smoothingRadius; ++y) {
            for (int x = 0 - smoothingRadius; x < tileSize + smoothingRadius; ++x) {
                float lightCountWeighted;
                float lightValue = Math.min(lightMap[tileSize + y][tileSize + x], 1.0f);
                float lightValueWeighted = Math.min(lightValue * (lightCountWeighted = lightCountMap[tileSize + y][tileSize + x] / (float)sunrayDampening), 1.0f);
                float shadowValue = 1.0f - lightValueWeighted;
                float shadowOpacity = (float)((double)(255.0f * shadowValue) * shadowBaseIntensity);
                if (shadowOpacity < 1.0f) {
                    shadowOpacity = 0.0f;
                }
                shadowMap[tileSize + y][tileSize + x] = shadowValue != 0.0f ? shadowOpacity : 0.0f;
            }
        }
        if (smoothingRadius > 0) {
            for (y = 0 - smoothingRadius; y < tileSize + smoothingRadius; ++y) {
                for (int x = 0 - smoothingRadius; x < tileSize + smoothingRadius; ++x) {
                    float smoothedValue;
                    float collectedValue = 0.0f;
                    float collectedValueCounter = 0.0f;
                    for (int smoothY = -smoothingRadius; smoothY <= smoothingRadius; ++smoothY) {
                        for (int smoothX = -smoothingRadius; smoothX <= smoothingRadius; ++smoothX) {
                            if (smoothX == 0 && smoothY == 0) {
                                float surroundCount = (int)Math.pow(smoothingRadius * 2 + 1, 2.0) - 1;
                                collectedValue += surroundCount * shadowMap[tileSize + y][tileSize + x];
                                collectedValueCounter += surroundCount;
                                continue;
                            }
                            collectedValue += shadowMap[tileSize + y + smoothY][tileSize + x + smoothX];
                            collectedValueCounter += 1.0f;
                        }
                    }
                    shadowMapSmoothed[tileSize + y][tileSize + x] = smoothedValue = collectedValue / collectedValueCounter;
                }
            }
        } else {
            shadowMapSmoothed = shadowMap;
        }
        RenderImageLayer fakeDepthShadowLayer = renderRequest.getRenderImage().createLayer("fakeDepthShadow", tileOutputter.getTileSize());
        BufferedImage topImage = fakeDepthShadowLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        for (int y3 = 0; y3 < tileSize; ++y3) {
            for (int x = 0; x < tileSize; ++x) {
                float shadowColorRed = shadowColor.getRed();
                float shadowColorGreen = shadowColor.getGreen();
                float shadowColorBlue = shadowColor.getBlue();
                float shadowOpacity = shadowMapSmoothed[tileSize + y3][tileSize + x];
                topRaster.setPixel(x, y3, new float[]{shadowColorRed, shadowColorGreen, shadowColorBlue, shadowOpacity});
            }
        }
        renderRequest.getRenderImage().mergeBackLayer(fakeDepthShadowLayer);
    }
}

