/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.renderer;

import de.wideportal.maprender.config.xml.osm.accessor.OsmHeightColorSymbolizerAccessor;
import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.util.color.ColorValueRanges;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightColorSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void renderHeight(RenderRequest renderRequest, OsmHeightColorSymbolizerAccessor heightColorSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        int xTileIndex;
        double heightMin = heightColorSymbolizer.getHeightMin();
        double heightMax = heightColorSymbolizer.getHeightMax();
        Color colorMin = heightColorSymbolizer.getColorMin();
        Color colorMax = heightColorSymbolizer.getColorMax();
        boolean renderMockTiles = heightColorSymbolizer.getRenderMockTiles();
        int flattenNoise = heightColorSymbolizer.getFlattenNoise();
        int flattenPointNoise = heightColorSymbolizer.getFlattenPointNoise();
        Optional<String> colorRanges = heightColorSymbolizer.getColorRanges();
        int expensiveBlur = heightColorSymbolizer.getExpensiveBlur();
        ArrayList<Float> skipHeights = this.parseSkipHeights(heightColorSymbolizer.getSkipHeights());
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex = (int)renderRequest.getTileIndex().getX(), yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, flattenNoise, flattenPointNoise, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderHeightHeight: could not render height because the srtmCollectorTile was null");
            return;
        }
        if (expensiveBlur > 0) {
            heightCollectorTile.blur(expensiveBlur);
        }
        RenderImageLayer srtmLayer = renderRequest.getRenderImage().createLayer("srtm", tileOutputter.getTileSize());
        BufferedImage topImage = srtmLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        float[] heightList = new float[]{(float)heightMin, (float)heightMax};
        Color[] colorList = new Color[]{colorMin, colorMax};
        ColorValueRanges colorValueRanges = new ColorValueRanges();
        if (colorRanges.isPresent()) {
            colorValueRanges.buildColorRangesFromString(colorRanges.get());
            heightList = colorValueRanges.getValues();
            colorList = colorValueRanges.getColors();
            heightMin = colorValueRanges.getMinValue();
            heightMax = colorValueRanges.getMaxValue();
        }
        float[] rgbaMin = new float[4];
        float[] rgbaMax = new float[4];
        float[] rgbaTransparent = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float currentMinHeight = 0.0f;
        float currentMaxHeight = 0.0f;
        for (int y = 0; y < heightCollectorTile.getPixelTileSize(); ++y) {
            for (int x = 0; x < heightCollectorTile.getPixelTileSize(); ++x) {
                int i;
                float value = heightCollectorTile.getValue(x, y);
                float slopeDegree = this.getSlopeDegree(heightCollectorTile, renderRequest, tileOutputter, zoom, x, y);
                boolean skipHeightRendering = false;
                for (i = 0; i < skipHeights.size(); ++i) {
                    if (skipHeights.get(i).floatValue() != value) continue;
                    if (value == 0.0f) {
                        if (slopeDegree != 0.0f) continue;
                        skipHeightRendering = true;
                        break;
                    }
                    skipHeightRendering = true;
                    break;
                }
                if (skipHeightRendering) {
                    topRaster.setPixel(x, y, COLOR_TRANSPARENT);
                    continue;
                }
                if ((double)value < heightMin) {
                    rgbaMin = (float[])rgbaTransparent.clone();
                    rgbaMax = (float[])rgbaTransparent.clone();
                    currentMinHeight = heightList[0];
                    currentMaxHeight = heightList[0];
                } else if ((double)value > heightMax) {
                    rgbaMin = (float[])rgbaTransparent.clone();
                    rgbaMax = (float[])rgbaTransparent.clone();
                    currentMinHeight = heightList[heightList.length - 1];
                    currentMaxHeight = heightList[heightList.length - 1];
                } else {
                    for (i = 0; i < heightList.length - 1; ++i) {
                        if (!(value >= heightList[i]) || !(value < heightList[i + 1])) continue;
                        rgbaMin[0] = colorList[i].getRed();
                        rgbaMin[1] = colorList[i].getGreen();
                        rgbaMin[2] = colorList[i].getBlue();
                        rgbaMin[3] = colorList[i].getAlpha();
                        rgbaMax[0] = colorList[i + 1].getRed();
                        rgbaMax[1] = colorList[i + 1].getGreen();
                        rgbaMax[2] = colorList[i + 1].getBlue();
                        rgbaMax[3] = colorList[i + 1].getAlpha();
                        currentMinHeight = heightList[i];
                        currentMaxHeight = heightList[i + 1];
                        break;
                    }
                }
                float redMinMaxDiff = rgbaMax[0] - rgbaMin[0];
                float greenMinMaxDiff = rgbaMax[1] - rgbaMin[1];
                float blueMinMaxDiff = rgbaMax[2] - rgbaMin[2];
                float alphaMinMaxDiff = rgbaMax[3] - rgbaMin[3];
                float[] newRgba = new float[4];
                if (currentMinHeight < currentMaxHeight) {
                    float scaleFactor = this.getScaleFactor(value, currentMinHeight, currentMaxHeight);
                    float newRed = scaleFactor * redMinMaxDiff + rgbaMin[0];
                    float newGreen = scaleFactor * greenMinMaxDiff + rgbaMin[1];
                    float newBlue = scaleFactor * blueMinMaxDiff + rgbaMin[2];
                    float newAlpha = scaleFactor * alphaMinMaxDiff + rgbaMin[3];
                    newRgba[0] = newRed;
                    newRgba[1] = newGreen;
                    newRgba[2] = newBlue;
                    newRgba[3] = newAlpha;
                } else {
                    newRgba = rgbaMin;
                }
                topRaster.setPixel(x, y, newRgba);
            }
        }
        renderRequest.getRenderImage().mergeBackLayer(srtmLayer);
    }

    private float getSlopeDegree(HeightCollectorTile heightCollectorTile, RenderRequest renderRequest, AbstractMapTileOutput tileOutputter, double zoom, int x, int y) {
        double yLonStepSize = heightCollectorTile.getLatLonBBox().getHeight() / (double)heightCollectorTile.getPixelTileSize();
        double currentYLon = renderRequest.getBoundingBoxLatLon().getTop() - (double)y * yLonStepSize;
        float meterPerPixel = (float)tileOutputter.getMeterPerPixel(zoom, currentYLon);
        float heightDiff = this.getAverageHeightDiff(heightCollectorTile, x, y);
        float slopeDegree = (float)Math.toDegrees(Math.atan(heightDiff / meterPerPixel));
        return slopeDegree;
    }

    private float getAverageHeightDiff(HeightCollectorTile collectorTile, int x, int y) {
        float diff_s = collectorTile.getValue(x, y) - collectorTile.getValue(x, y + 1);
        float diff_se = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y + 1);
        float diff_e = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y);
        float abs_diff_s = Math.abs(diff_s);
        float abs_diff_se = Math.abs(diff_se);
        float abs_diff_e = Math.abs(diff_e);
        return (abs_diff_e + abs_diff_s + abs_diff_se) / 3.0f;
    }

    private float getScaleFactor(float value, double min, double max) {
        double range = Math.abs(max - min);
        value = this.trimToBounds(value, (float)min, (float)max);
        value -= (float)min;
        value = (float)((double)value / range);
        return value;
    }

    private float trimToBounds(float value, float min, float max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points) {
        System.out.println("################################################# logPoints ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    value = "start".equals(currentPoint.getOptionalFlag()) ? "0" : ("stop".equals(currentPoint.getOptionalFlag()) ? "1" : "#");
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points, ArrayList<Integer> analysis) {
        System.out.println("################################################# logPoints ");
        int SAME_X = 1;
        int SAME_Y = 2;
        int BACKWARD = 3;
        int FORWARD = 4;
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                Integer currentAnalysis = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    currentAnalysis = analysis.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    if (currentAnalysis == SAME_X) {
                        value = "X";
                    } else if (currentAnalysis == SAME_Y) {
                        value = "Y";
                    } else if (currentAnalysis == BACKWARD) {
                        value = "<";
                    } else if (currentAnalysis == FORWARD) {
                        value = ">";
                    }
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }
}

