/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

import de.wideportal.maprender.geom.Line;
import de.wideportal.maprender.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LineSequence {
    private ArrayList<Line> lines = new ArrayList();

    private LineSequence() {
    }

    public LineSequence(Point[] points) {
        this.parse(Arrays.asList(points));
    }

    public LineSequence(List<Point> points) {
        this.parse(points);
    }

    public void parse(List<Point> points) {
        Point startPoint = null;
        int indexCounter = 0;
        for (Point point : points) {
            if (startPoint == null) {
                startPoint = point;
                continue;
            }
            Line newLine = new Line(startPoint, point);
            newLine.setOptionalLineIndex(indexCounter);
            this.lines.add(newLine);
            startPoint = point;
            ++indexCounter;
        }
    }

    public NextPointOnLineIterator<Point> getIterator(double distance, double offset) {
        return new NextPointOnLineIterator<Point>(this.lines, distance, offset);
    }

    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public Point[] getPoints() {
        if (this.lines.size() == 0) {
            return new Point[0];
        }
        Point[] result = new Point[this.lines.size() + 1];
        result[0] = this.lines.get(0).getStart();
        for (int i = 0; i < this.lines.size(); ++i) {
            result[i + 1] = this.lines.get(i).getStop();
        }
        return result;
    }

    public double getLength() {
        double length = 0.0;
        for (Line line : this.lines) {
            length += line.getLength();
        }
        return length;
    }

    public boolean connected(LineSequence other) {
        double otherStartX = other.getStart().getX();
        double otherStartY = other.getStart().getY();
        double otherStopX = other.getStop().getX();
        double otherStopY = other.getStop().getY();
        double thisStartX = this.getStart().getX();
        double thisStartY = this.getStart().getY();
        double thisStopX = this.getStop().getX();
        double thisStopY = this.getStop().getY();
        if (otherStartX == thisStartX && otherStartY == thisStartY) {
            return true;
        }
        if (otherStopX == thisStopX && otherStopY == thisStopY) {
            return true;
        }
        if (otherStartX == thisStopX && otherStartY == thisStopY) {
            return true;
        }
        return otherStopX == thisStartX && otherStopY == thisStartY;
    }

    public boolean isCyclic() {
        double startX = this.lines.get(0).getStart().getX();
        double startY = this.lines.get(0).getStart().getY();
        double stopX = this.lines.get(this.lines.size() - 1).getStop().getX();
        double stopY = this.lines.get(this.lines.size() - 1).getStop().getY();
        return startX == stopX && startY == stopY;
    }

    public Point getStart() {
        if (this.lines != null && this.lines.size() > 0) {
            return this.lines.get(0).getStart();
        }
        return null;
    }

    public Point getStop() {
        if (this.lines != null && this.lines.size() > 0) {
            return this.lines.get(this.lines.size() - 1).getStop();
        }
        return null;
    }

    public LineSequence shiftLines(double distance, boolean leftOrRight) {
        return this.shiftLines(0, this.lines.size(), distance, leftOrRight);
    }

    public LineSequence shiftLines(int lineIndexStart, int lineIndexStop, double distance, boolean leftOrRight) {
        Line firstLine;
        int i;
        if (distance == 0.0) {
            return this;
        }
        ArrayList<Line> newLines = new ArrayList<Line>();
        for (i = lineIndexStart; i < lineIndexStop; ++i) {
            Line line = this.lines.get(i);
            Line newLine = line.getParallelLine(distance, leftOrRight);
            if (newLine == null) continue;
            newLine.optionalLineIndex = line.optionalLineIndex;
            newLines.add(newLine);
        }
        for (i = 0; i < newLines.size() - 2; ++i) {
            Line secondLine;
            firstLine = (Line)newLines.get(i);
            Point intersection = firstLine.getIntersection(secondLine = (Line)newLines.get(i + 1));
            if (intersection == null) continue;
            firstLine.setStop(intersection.clone());
            secondLine.setStart(intersection.clone());
        }
        block2: for (i = 1; i < newLines.size(); ++i) {
            int jStartIndex;
            firstLine = (Line)newLines.get(i);
            for (int j = jStartIndex = Math.max(0, i - 10); j < i; ++j) {
                Line secondLine = (Line)newLines.get(j);
                Point intersection = firstLine.getIntersectionBetweenStartStop(secondLine);
                if (intersection == null) continue;
                secondLine.setStop(intersection.clone());
                firstLine.setStart(intersection.clone());
                for (int k = i - 1; k > j; --k) {
                    newLines.remove(k);
                }
                continue block2;
            }
        }
        for (i = 1; i < newLines.size(); ++i) {
            Line first = (Line)newLines.get(i - 1);
            Line second = (Line)newLines.get(i);
            Line shortcut = new Line(first.start, second.stop);
            if (!(shortcut.getLength() * 4.0 < first.getLength() + second.getLength())) continue;
            first.setStop(second.stop);
            newLines.remove(i);
        }
        LineSequence newLineSequence = new LineSequence();
        newLineSequence.lines = newLines;
        return newLineSequence;
    }

    public LineSequence clone() {
        ArrayList<Line> clonedLines = new ArrayList<Line>();
        for (int i = 0; i < this.lines.size(); ++i) {
            clonedLines.add(this.lines.get(i).clone());
        }
        LineSequence clone = new LineSequence();
        clone.lines = clonedLines;
        return clone;
    }

    public LineSequence thinOut(int linesToSkip) {
        if (this.lines.size() >= 2) {
            int i;
            LineSequence thinnedClone = new LineSequence();
            ArrayList<Line> thinnedLines = new ArrayList<Line>();
            for (i = 0; i < this.lines.size() - 1; ++i) {
                if (i % linesToSkip != 0) continue;
                thinnedLines.add(this.lines.get(i));
            }
            thinnedLines.add(this.lines.get(this.lines.size() - 1));
            for (i = 0; i < thinnedLines.size() - 1; ++i) {
                Line currentLine = (Line)thinnedLines.get(i);
                Line nextLine = (Line)thinnedLines.get(i + 1);
                currentLine.setStop(nextLine.getStart());
            }
            thinnedClone.lines = thinnedLines;
            return thinnedClone;
        }
        return this.clone();
    }

    public LineSequence invert() {
        LineSequence inverted = new LineSequence();
        ArrayList<Line> invertedLines = new ArrayList<Line>();
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Line currentLine = this.lines.get(i);
            Line invertedLine = new Line(currentLine.getStop().clone(), currentLine.getStart().clone());
            invertedLines.add(invertedLine);
        }
        inverted.lines = invertedLines;
        return inverted;
    }

    public void prepend(LineSequence other) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        newLines.addAll(other.getLines());
        newLines.add(new Line(other.getStop(), this.getStart()));
        newLines.addAll(this.getLines());
        this.lines = newLines;
    }

    public void append(LineSequence other) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        newLines.addAll(this.getLines());
        Line connectLine = new Line(this.getStop(), other.getStart());
        newLines.add(connectLine);
        newLines.addAll(other.getLines());
        this.lines = newLines;
    }

    public void flagStartStopPoints() {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line currentLine = this.lines.get(i);
            if (i == 0) {
                currentLine.getStart().setOptionalFlag("start");
                currentLine.getStop().setOptionalFlag("");
                continue;
            }
            if (i == this.lines.size() - 1) {
                currentLine.getStart().setOptionalFlag("");
                currentLine.getStop().setOptionalFlag("stop");
                continue;
            }
            currentLine.getStart().setOptionalFlag("");
            currentLine.getStop().setOptionalFlag("");
        }
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("LineSequence[");
        for (Line line : this.lines) {
            buffy.append(line);
            buffy.append(",");
        }
        buffy.append("]");
        return buffy.toString();
    }

    public class NextPointOnLineIterator<T>
    implements Iterator<Point> {
        ArrayList<Line> iteratorLines;
        Point currentStartPoint;
        int currentStartLineIndex = 0;
        double distance = 0.0;
        double offset = 0.0;
        double iterationCounter = 0.0;
        Line.Direction direction = Line.Direction.FORWARD;

        private NextPointOnLineIterator() {
        }

        public NextPointOnLineIterator<T> clone() {
            NextPointOnLineIterator<T> clone = new NextPointOnLineIterator<T>();
            clone.iteratorLines = new ArrayList();
            for (Line line : this.iteratorLines) {
                clone.iteratorLines.add(line.clone());
            }
            clone.currentStartLineIndex = this.currentStartLineIndex;
            clone.currentStartPoint = this.currentStartPoint;
            clone.distance = this.distance;
            clone.offset = this.offset;
            clone.iterationCounter = this.iterationCounter;
            clone.direction = this.direction;
            return clone;
        }

        public NextPointOnLineIterator(ArrayList<Line> iteratorLines, double distance, double offset) {
            this.iteratorLines = new ArrayList();
            for (Line line : iteratorLines) {
                this.iteratorLines.add(line.clone());
            }
            if (iteratorLines != null && iteratorLines.size() > 0) {
                this.currentStartLineIndex = 0;
            }
            this.distance = distance;
            this.offset = offset;
        }

        public void setDirection(Line.Direction direction) {
            if (this.direction != direction) {
                this.invertIterator();
            }
            this.direction = direction;
        }

        private void invertIterator() {
            this.iteratorLines = Line.invertLines(this.iteratorLines);
            if (this.currentStartPoint != null) {
                this.currentStartLineIndex = this.iteratorLines.size() - this.currentStartLineIndex - 1;
            }
        }

        public void setStartPoint(Point startPoint) {
            this.currentStartPoint = startPoint;
        }

        public void setStartLineIndex(int startLineIndex) {
            this.currentStartLineIndex = startLineIndex;
        }

        public double getDistance() {
            return this.distance;
        }

        public Point getCurrentPoint() {
            return this.currentStartPoint;
        }

        public int getCurrentLineIndex() {
            return this.currentStartLineIndex;
        }

        public ArrayList<Line> getIteratorLines() {
            return this.iteratorLines;
        }

        public Point getPointFromCurrentPosition(double distance) {
            Point nextPoint;
            Line currentLine = this.iteratorLines.get(this.currentStartLineIndex);
            if (this.currentStartPoint == null) {
                this.currentStartPoint = currentLine.getStart();
            }
            if ((nextPoint = currentLine.getPointAfterLength(this.currentStartPoint, distance, this.direction)) == null) {
                nextPoint = this.findNextPointInNextLineSegment(this.currentStartLineIndex + 1, distance - currentLine.getDistance(this.currentStartPoint, currentLine.getStop()), true);
            }
            return nextPoint;
        }

        @Override
        public boolean hasNext() {
            Line currentLine;
            if (this.currentStartPoint == null) {
                if (this.iteratorLines.size() > 0) {
                    this.currentStartPoint = this.iteratorLines.get(0).getStart();
                } else {
                    return false;
                }
            }
            double currentDistance = this.distance;
            if (this.iterationCounter == 0.0) {
                currentDistance = this.offset;
            }
            if ((currentLine = this.iteratorLines.get(this.currentStartLineIndex)).isNextPointOnLine(this.currentStartPoint, currentDistance)) {
                return true;
            }
            Point nextPoint = this.findNextPointInNextLineSegment(this.currentStartLineIndex + 1, currentDistance, true);
            return nextPoint != null;
        }

        @Override
        public Point next() {
            Point nextPoint;
            Line currentLine = this.iteratorLines.get(this.currentStartLineIndex);
            if (this.currentStartPoint == null) {
                this.currentStartPoint = currentLine.getStart();
            }
            double currentDistance = this.distance;
            if (this.iterationCounter == 0.0) {
                currentDistance = this.offset;
            }
            if ((nextPoint = currentLine.getPointAfterLength(this.currentStartPoint, currentDistance, this.direction)) == null) {
                nextPoint = this.findNextPointInNextLineSegment(this.currentStartLineIndex + 1, currentDistance - currentLine.getDistance(this.currentStartPoint, currentLine.getStop()), false);
            }
            if (nextPoint != null) {
                this.currentStartPoint = nextPoint;
            }
            this.iterationCounter += 1.0;
            return nextPoint;
        }

        public Point next(double nextDistance) {
            Line currentLine = this.iteratorLines.get(this.currentStartLineIndex);
            if (this.currentStartPoint == null) {
                this.currentStartPoint = currentLine.getStart();
            }
            if (this.iterationCounter == 0.0) {
                this.iterationCounter += 1.0;
                return this.currentStartPoint;
            }
            Point nextPoint = currentLine.getPointAfterLength(this.currentStartPoint, nextDistance, this.direction);
            if (nextPoint == null) {
                nextPoint = this.findNextPointInNextLineSegment(this.currentStartLineIndex + 1, nextDistance - currentLine.getDistance(this.currentStartPoint, currentLine.getStop()), false);
            }
            if (nextPoint != null) {
                this.currentStartPoint = nextPoint;
            }
            this.iterationCounter += 1.0;
            return nextPoint;
        }

        public Point findNextPointInNextLineSegment(int nextLineIndex, double restDistance, boolean justPeek) {
            Line nextLine;
            while (true) {
                if (nextLineIndex >= this.iteratorLines.size() || nextLineIndex < 0) {
                    return null;
                }
                nextLine = this.iteratorLines.get(nextLineIndex);
                double lineSegmentLength = nextLine.getLength();
                if (!(lineSegmentLength < restDistance)) break;
                restDistance -= lineSegmentLength;
                ++nextLineIndex;
            }
            Point nextPoint = null;
            nextPoint = nextLine.getPointAfterLength(nextLine.getStart(), restDistance, this.direction);
            if (!justPeek) {
                this.currentStartLineIndex = nextLineIndex;
            }
            return nextPoint;
        }

        public NextPointOnLineIterator<Point> createLetterIterator() {
            NextPointOnLineIterator<Point> newInstance = new NextPointOnLineIterator<Point>();
            newInstance.iteratorLines = new ArrayList();
            for (Line line : this.iteratorLines) {
                newInstance.iteratorLines.add(line.clone());
            }
            newInstance.currentStartPoint = this.currentStartPoint != null ? this.currentStartPoint.clone() : null;
            newInstance.currentStartLineIndex = this.currentStartLineIndex;
            newInstance.distance = 0.0;
            newInstance.offset = 0.0;
            newInstance.iterationCounter = 0.0;
            return newInstance;
        }
    }
}

