/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.geom;

import de.wideportal.maprender.geom.AbstractLineFilter;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.geom.Triangle;

public class LineFilterVisvalingamWhyatt
extends AbstractLineFilter {
    public static final String FILTER_NAME = "visvalingam-whyatt";
    private double areaTolerance;

    public LineFilterVisvalingamWhyatt(double areaTolerance) {
        this.areaTolerance = 0.01 * areaTolerance;
    }

    @Override
    public Point[] filter(Point[] pointList) {
        Point[] tempCollector = new Point[pointList.length];
        int tempCollectorCounter = 0;
        Point lastValidPoint = null;
        Point mediumPoint = null;
        Point endPoint = null;
        for (int i = 0; i < pointList.length; ++i) {
            if (i == 0 || i == pointList.length - 1) {
                tempCollector[tempCollectorCounter] = pointList[i];
                ++tempCollectorCounter;
                lastValidPoint = pointList[i];
                continue;
            }
            mediumPoint = pointList[i];
            endPoint = pointList[i + 1];
            Triangle triangle = new Triangle(lastValidPoint, mediumPoint, endPoint);
            double area = triangle.getArea();
            if (!(area > this.areaTolerance)) continue;
            tempCollector[tempCollectorCounter] = mediumPoint;
            ++tempCollectorCounter;
            lastValidPoint = mediumPoint;
        }
        Point[] result = new Point[tempCollectorCounter];
        System.arraycopy(tempCollector, 0, result, 0, tempCollectorCounter);
        return result;
    }
}

