/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.deprecated;

import de.wideportal.maprender.config.xml.osm.accessor.OsmRuleAccessor;
import de.wideportal.maprender.datasource.osm.PostgresLineString;
import de.wideportal.maprender.deprecated.OsmHeightSymbolizerAccessor;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.LineSequence;
import de.wideportal.maprender.geom.Point;
import de.wideportal.maprender.math.GeoCalculator;
import de.wideportal.maprender.renderer.AbstractSymbolizerRenderer;
import de.wideportal.maprender.request.RenderImageLayer;
import de.wideportal.maprender.request.RenderRequest;
import de.wideportal.maprender.resources.height.HeightCollectorTile;
import de.wideportal.maprender.resources.height.HeightTileAccessor;
import de.wideportal.maprender.resources.output.format.AbstractMapTileOutput;
import de.wideportal.maprender.resources.srtm.SrtmLineHeightContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmHeightSymbolizerRenderer
extends AbstractSymbolizerRenderer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    private void renderHeight(RenderRequest renderRequest, OsmHeightSymbolizerAccessor srtmSymbolizer, RenderImageLayer renderLayer, PostgresLineString mercatorLineString, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
    }

    public void renderHeightProfile(RenderRequest renderRequest, OsmHeightSymbolizerAccessor srtmSymbolizer, RenderImageLayer renderLayer, double xOffset, double yOffset, double zoom, AbstractMapTileOutput tileOutputter, GeoCalculator geoCalculator, OsmRuleAccessor rule) {
        BoundingBox latLonBoundingBox;
        int yTileIndex;
        int xTileIndex;
        Color color = srtmSymbolizer.getColor();
        float sunHeight = 90.0f;
        float shadowImpact = srtmSymbolizer.getShadowImpact().floatValue();
        boolean renderMockTiles = srtmSymbolizer.getRenderMockTiles();
        int flattenNoise = srtmSymbolizer.getFlattenNoise();
        int flattenPointNoise = srtmSymbolizer.getFlattenPointNoise();
        int expensiveBlur = srtmSymbolizer.getExpensiveBlur();
        double heightMin = srtmSymbolizer.getHeightMin();
        double heightMax = srtmSymbolizer.getHeightMax();
        HeightTileAccessor heightTileAccessor = renderRequest.getHeightTileAccessor();
        HeightCollectorTile heightCollectorTile = heightTileAccessor.collectValues((int)zoom, xTileIndex = (int)renderRequest.getTileIndex().getX(), yTileIndex = (int)renderRequest.getTileIndex().getY(), latLonBoundingBox = renderRequest.getBoundingBoxLatLon(), renderRequest, tileOutputter.getTileSize(), renderMockTiles, flattenNoise, flattenPointNoise, tileOutputter);
        if (heightCollectorTile == null) {
            this.log.error("renderHeightShadow: could not render shadow because the srtmCollectorTile was null");
            return;
        }
        if (expensiveBlur > 0) {
            heightCollectorTile.blur(expensiveBlur);
        }
        RenderImageLayer srtmLayer = renderRequest.getRenderImage().createLayer("srtm", tileOutputter.getTileSize());
        BufferedImage topImage = srtmLayer.getImage();
        WritableRaster topRaster = topImage.getRaster();
        float sunHeightShift = 90.0f - sunHeight;
        float[] transparent = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        double yLonStepSize = heightCollectorTile.getLatLonBBox().getHeight() / (double)heightCollectorTile.getPixelTileSize();
        for (int y = 0; y < heightCollectorTile.getPixelTileSize(); ++y) {
            double currentYLon = renderRequest.getBoundingBoxLatLon().getTop() - (double)y * yLonStepSize;
            float meterPerPixel = (float)tileOutputter.getMeterPerPixel(zoom, currentYLon);
            for (int x = 0; x < heightCollectorTile.getPixelTileSize(); ++x) {
                float height = heightCollectorTile.getValue(x, y);
                if ((double)height < heightMin || (double)height > heightMax) {
                    topRaster.setPixel(x, y, transparent);
                    continue;
                }
                float[] topRgba = new float[4];
                topRgba = topRaster.getPixel(x, y, topRgba);
                topRgba[0] = color.getRed();
                topRgba[1] = color.getGreen();
                topRgba[2] = color.getBlue();
                float heightDiff = this.getAverageHeightDiff(heightCollectorTile, x, y);
                float slopeDegree = (float)Math.toDegrees(Math.atan(heightDiff / meterPerPixel));
                float weightedSlopeDegree = 0.0f;
                weightedSlopeDegree = slopeDegree < 0.0f ? slopeDegree * -1.0f : slopeDegree * (1.0f + sunHeightShift / 30.0f);
                float slope0to255 = 256.0f * weightedSlopeDegree / 90.0f;
                float shadowImpactMultiplier = (float)(Math.pow(slope0to255 - 128.0f, 2.0) / 1000000.0 * (double)shadowImpact);
                float slopeScaled = slope0to255 * shadowImpactMultiplier + sunHeightShift;
                topRgba[3] = slopeScaled = this.trimToBounds(slopeScaled, 0.0f, 255.0f);
                topRaster.setPixel(x, y, topRgba);
            }
        }
        renderRequest.getRenderImage().mergeBackLayer(srtmLayer);
    }

    private float getMaxHeightDiff(HeightCollectorTile collectorTile, int x, int y) {
        float diff_s = collectorTile.getValue(x, y) - collectorTile.getValue(x, y + 1);
        float diff_se = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y + 1);
        float diff_e = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y);
        float abs_diff_s = Math.abs(diff_s);
        float abs_diff_se = Math.abs(diff_se);
        float abs_diff_e = Math.abs(diff_e);
        if (abs_diff_s >= abs_diff_se && abs_diff_s >= abs_diff_e) {
            return diff_s;
        }
        if (abs_diff_se >= abs_diff_s && abs_diff_se >= abs_diff_e) {
            return diff_se;
        }
        if (abs_diff_e >= abs_diff_s && abs_diff_e >= abs_diff_se) {
            return diff_e;
        }
        return 0.0f;
    }

    private float getAverageHeightDiff(HeightCollectorTile collectorTile, int x, int y) {
        float diff_s = collectorTile.getValue(x, y) - collectorTile.getValue(x, y + 1);
        float diff_se = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y + 1);
        float diff_e = collectorTile.getValue(x, y) - collectorTile.getValue(x + 1, y);
        float abs_diff_s = Math.abs(diff_s);
        float abs_diff_se = Math.abs(diff_se);
        float abs_diff_e = Math.abs(diff_e);
        return (abs_diff_e + abs_diff_s + abs_diff_se) / 3.0f;
    }

    private float getSmoothedHeightDiff(HeightCollectorTile collectorTile, String sunPlacement, int x, int y) {
        int bottomSmoothIndex;
        int topSmoothIndex;
        int rightSmoothIndex;
        int radius = 1;
        if ("W".equalsIgnoreCase(sunPlacement) || "E".equalsIgnoreCase(sunPlacement) || "N".equalsIgnoreCase(sunPlacement) || "S".equalsIgnoreCase(sunPlacement)) {
            int smallestSubTileSize = Math.min(collectorTile.getSubTileSizeX(), collectorTile.getSubTileSizeY());
            radius = Math.max(1, smallestSubTileSize + 1);
        } else if ("NW".equalsIgnoreCase(sunPlacement) || "SW".equalsIgnoreCase(sunPlacement) || "NE".equalsIgnoreCase(sunPlacement) || "SE".equalsIgnoreCase(sunPlacement)) {
            int biggestSubTileSize = Math.max(collectorTile.getSubTileSizeX(), collectorTile.getSubTileSizeY());
            radius = Math.max(1, biggestSubTileSize + 1);
        }
        int leftSmoothIndex = x - radius;
        if (leftSmoothIndex < -50) {
            leftSmoothIndex = -50;
        }
        if ((rightSmoothIndex = x + radius) > collectorTile.getPixelTileSize() + 50) {
            rightSmoothIndex = collectorTile.getPixelTileSize() + 50;
        }
        if ((topSmoothIndex = y - radius) < -50) {
            topSmoothIndex = -50;
        }
        if ((bottomSmoothIndex = y + radius) > collectorTile.getPixelTileSize() + 50) {
            bottomSmoothIndex = collectorTile.getPixelTileSize() + 50;
        }
        float value = 0.0f;
        if ("W".equalsIgnoreCase(sunPlacement)) {
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (int i = leftSmoothIndex; i < rightSmoothIndex - 1; ++i) {
                totalValue += collectorTile.getValue(i, y) - collectorTile.getValue(i + 1, y);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("E".equalsIgnoreCase(sunPlacement)) {
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (int i = rightSmoothIndex; i > leftSmoothIndex + 1; --i) {
                totalValue += collectorTile.getValue(i, y) - collectorTile.getValue(i - 1, y);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("N".equalsIgnoreCase(sunPlacement)) {
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (int i = topSmoothIndex; i < bottomSmoothIndex - 1; ++i) {
                totalValue += collectorTile.getValue(x, i) - collectorTile.getValue(x, i + 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("S".equalsIgnoreCase(sunPlacement)) {
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (int i = bottomSmoothIndex; i > topSmoothIndex + 1; --i) {
                totalValue += collectorTile.getValue(x, i) - collectorTile.getValue(x, i - 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("NW".equalsIgnoreCase(sunPlacement)) {
            int yNew;
            int xNew;
            int i;
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (i = 0; i < radius && (xNew = x - i) >= -50 && (yNew = y - i) >= -50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew + 1, yNew + 1);
                counter += 1.0f;
            }
            for (i = 0; i < radius && (xNew = x + i) <= collectorTile.getPixelTileSize() + 50 && (yNew = y + i) <= collectorTile.getPixelTileSize() + 50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew + 1, yNew + 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("NE".equalsIgnoreCase(sunPlacement)) {
            int yNew;
            int xNew;
            int i;
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (i = 0; i < radius && (xNew = x + i) >= -50 && (yNew = y - i) >= -50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew - 1, yNew + 1);
                counter += 1.0f;
            }
            for (i = 0; i < radius && (xNew = x - i) <= collectorTile.getPixelTileSize() + 50 && (yNew = y + i) <= collectorTile.getPixelTileSize() + 50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew - 1, yNew + 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("SW".equalsIgnoreCase(sunPlacement)) {
            int yNew;
            int xNew;
            int i;
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (i = 0; i < radius && (xNew = x - i) >= -50 && (yNew = y + i) >= -50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew + 1, yNew - 1);
                counter += 1.0f;
            }
            for (i = 0; i < radius && (xNew = x + i) <= collectorTile.getPixelTileSize() + 50 && (yNew = y - i) <= collectorTile.getPixelTileSize() + 50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew + 1, yNew - 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        } else if ("SE".equalsIgnoreCase(sunPlacement)) {
            int yNew;
            int xNew;
            int i;
            float counter = 0.0f;
            float totalValue = 0.0f;
            for (i = 0; i < radius && (xNew = x + i) >= -50 && (yNew = y + i) >= -50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew - 1, yNew - 1);
                counter += 1.0f;
            }
            for (i = 0; i < radius && (xNew = x - i) <= collectorTile.getPixelTileSize() + 50 && (yNew = y - i) <= collectorTile.getPixelTileSize() + 50; ++i) {
                totalValue += collectorTile.getValue(xNew, yNew) - collectorTile.getValue(xNew - 1, yNew - 1);
                counter += 1.0f;
            }
            value = totalValue / counter;
        }
        return value;
    }

    private float getScaleFactor(float value, double min, double max) {
        double range = Math.abs(max - min);
        value = this.trimToBounds(value, (float)min, (float)max);
        value -= (float)min;
        value = (float)((double)value / range);
        return value;
    }

    private float trimToBounds(float value, float min, float max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private BasicStroke getBasicStroke(float width) {
        int lineCap = 1;
        int lineJoin = 1;
        BasicStroke basicStroke = new BasicStroke(width, lineCap, lineJoin);
        return basicStroke;
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, SrtmLineHeightContainer linesContainer) {
        ArrayList<LineSequence> lines = linesContainer.getHeightLines();
        ArrayList<Point> linePoints = new ArrayList<Point>();
        for (LineSequence line : lines) {
            Point[] points = line.getPoints();
            linePoints.addAll(Arrays.stream(points).collect(Collectors.toList()));
        }
        this.printPointArray(xMin, xMax, yMin, yMax, linePoints);
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points) {
        System.out.println("################################################# logPoints ");
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    value = "start".equals(currentPoint.getOptionalFlag()) ? "0" : ("stop".equals(currentPoint.getOptionalFlag()) ? "1" : "#");
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    private void printPointArray(int xMin, int xMax, int yMin, int yMax, ArrayList<Point> points, ArrayList<Integer> analysis) {
        System.out.println("################################################# logPoints ");
        int SAME_X = 1;
        int SAME_Y = 2;
        int BACKWARD = 3;
        int FORWARD = 4;
        for (int y = yMin; y < yMax; ++y) {
            StringBuffer rowBuffy = new StringBuffer();
            for (int x = xMin; x < xMax; ++x) {
                Point currentPoint = null;
                Integer currentAnalysis = null;
                for (int i = 0; i < points.size(); ++i) {
                    if (points.get(i).getX() != (double)x || points.get(i).getY() != (double)y) continue;
                    currentPoint = points.get(i);
                    currentAnalysis = analysis.get(i);
                    break;
                }
                String value = "-";
                if (currentPoint != null) {
                    if (currentAnalysis == SAME_X) {
                        value = "X";
                    } else if (currentAnalysis == SAME_Y) {
                        value = "Y";
                    } else if (currentAnalysis == BACKWARD) {
                        value = "<";
                    } else if (currentAnalysis == FORWARD) {
                        value = ">";
                    }
                }
                String lengthFilledValue = String.format("%1$1s", value);
                rowBuffy.append(lengthFilledValue);
            }
            System.out.println("######################### " + rowBuffy.toString());
        }
    }

    private Color getRandomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }
}

