/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.datasource.osm;

import de.wideportal.maprender.datasource.IDatasourceGeometry;
import de.wideportal.maprender.geom.BoundingBox;
import de.wideportal.maprender.geom.Point;
import java.util.ArrayList;

public class PostgresLineString
implements IDatasourceGeometry {
    public static final String GEOMETRY_PREFIX = "LINESTRING";
    private String source;
    private Point[] points = null;

    private PostgresLineString() {
    }

    public PostgresLineString(String geometryString) {
        this.source = geometryString;
        this.parseGeometryString(geometryString);
    }

    public PostgresLineString(String source, Point[] points) {
        this.source = source;
        this.points = points;
    }

    public static boolean isFittingGeometry(String geometryString) {
        return geometryString != null && geometryString.startsWith("LINESTRING(");
    }

    public boolean isClosedPolygon() {
        if (this.points.length >= 2) {
            Point startPoint = this.points[0];
            Point stopPoint = this.points[this.points.length - 1];
            if (startPoint.getX() == stopPoint.getX() && startPoint.getY() == stopPoint.getY()) {
                return true;
            }
        }
        return false;
    }

    private void parseGeometryString(String geometryString) {
        geometryString = geometryString.replaceAll("/", ".");
        geometryString = geometryString.replaceAll("!", ".");
        geometryString = geometryString.replaceAll("([0-9])\\-([\\-0-9])", "$1,$2");
        String prefixToCut = "LINESTRING(";
        geometryString = geometryString.substring(prefixToCut.length(), geometryString.length() - 1);
        String[] pointsList = geometryString.split(",");
        this.points = new Point[pointsList.length];
        for (int i = 0; i < pointsList.length; ++i) {
            Point mercatorPoint;
            String[] webMercatorPoints = pointsList[i].split(" ");
            this.points[i] = mercatorPoint = new Point(Double.parseDouble(webMercatorPoints[0]), Double.parseDouble(webMercatorPoints[1]));
        }
    }

    public Point[] getPoints() {
        return this.points;
    }

    public Point[] getPointsInBoundingBoxMercator(BoundingBox boundingBox) {
        ArrayList<Point> pointsInBoundingBox = new ArrayList<Point>();
        for (Point point : this.points) {
            if (!(point.x >= boundingBox.left) || !(point.x <= boundingBox.right) || !(point.y <= boundingBox.top) || !(point.y >= boundingBox.bottom)) continue;
            pointsInBoundingBox.add(point);
        }
        return pointsInBoundingBox.toArray(new Point[pointsInBoundingBox.size()]);
    }

    public String getSource() {
        return this.source;
    }

    public PostgresLineString clone() {
        PostgresLineString clone = new PostgresLineString();
        clone.source = this.source;
        clone.points = new Point[this.points.length];
        System.arraycopy(this.points, 0, clone.points, 0, this.points.length);
        return clone;
    }

    public String toString() {
        return "PostgresLineString[#points=" + this.points.length + ", source=" + this.source + "]";
    }
}

