/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.imagefilter;

import de.wideportal.maprender.config.xml.osm.imagefilter.AbstractOsmStyleImageFilter;
import de.wideportal.maprender.config.xml.osm.imagefilter.HslColor;
import de.wideportal.maprender.request.RenderImageLayer;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmStyleImageFilterScaleHSLA
extends AbstractOsmStyleImageFilter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private float hueMin = 0.0f;
    private float hueMax = 1.0f;
    private float saturationMin = 0.0f;
    private float saturationMax = 1.0f;
    private float lightnessMin = 0.0f;
    private float lightnessMax = 1.0f;
    private float alphaMin = 0.0f;
    private float alphaMax = 1.0f;

    public OsmStyleImageFilterScaleHSLA(String configuration) {
        this.parseConfiguration(configuration);
    }

    public void parseConfiguration(String configuration) {
        String[] parts = configuration.split(",");
        if (parts.length > 8) {
            this.log.error("parseConfiguration: config contained more than 8 entries which is most likely an error: " + configuration);
        }
        this.hueMin = Float.parseFloat(parts[0]);
        this.hueMax = Float.parseFloat(parts[1]);
        this.saturationMin = Float.parseFloat(parts[2]);
        this.saturationMax = Float.parseFloat(parts[3]);
        this.lightnessMin = Float.parseFloat(parts[4]);
        this.lightnessMax = Float.parseFloat(parts[5]);
        this.alphaMin = Float.parseFloat(parts[6]);
        this.alphaMax = Float.parseFloat(parts[7]);
    }

    @Override
    public void applyFilter(RenderImageLayer renderImageLayer) {
        BufferedImage image = renderImageLayer.getImage();
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                float[] rgba = new float[4];
                rgba = raster.getPixel(x, y, rgba);
                float[] hsla = HslColor.fromRGBA0255(rgba);
                hsla[0] = this.scaleValue(hsla[0], this.hueMin, this.hueMax, 360.0f);
                hsla[1] = this.scaleValue(hsla[1], this.saturationMin, this.saturationMax, 100.0f);
                hsla[2] = this.scaleValue(hsla[2], this.lightnessMin, this.lightnessMax, 100.0f);
                hsla[3] = this.scaleValue(hsla[3], this.alphaMin, this.alphaMax, 255.0f);
                float[] newRGBA = HslColor.toRGBA0255(hsla);
                raster.setPixel(x, y, newRGBA);
            }
        }
    }

    private float scaleValue(float value, float scaleMin, float scaleMax, float maxValue) {
        float scaledValue = scaleMin + (value /= maxValue) * (scaleMax - scaleMin);
        if (scaledValue < 0.0f) {
            scaledValue = 0.0f;
        } else if (scaledValue > 1.0f) {
            scaledValue = 1.0f;
        }
        return scaledValue *= maxValue;
    }

    public float getHueMin() {
        return this.hueMin;
    }

    public void setHueMin(float hueMin) {
        this.hueMin = hueMin;
    }

    public float getHueMax() {
        return this.hueMax;
    }

    public void setHueMax(float hueMax) {
        this.hueMax = hueMax;
    }

    public float getSaturationMin() {
        return this.saturationMin;
    }

    public void setSaturationMin(float saturationMin) {
        this.saturationMin = saturationMin;
    }

    public float getSaturationMax() {
        return this.saturationMax;
    }

    public void setSaturationMax(float saturationMax) {
        this.saturationMax = saturationMax;
    }

    public float getLightnessMin() {
        return this.lightnessMin;
    }

    public void setLightnessMin(float lightnessMin) {
        this.lightnessMin = lightnessMin;
    }

    public float getLightnessMax() {
        return this.lightnessMax;
    }

    public void setLightnessMax(float lightnessMax) {
        this.lightnessMax = lightnessMax;
    }

    public float getAlphaMin() {
        return this.alphaMin;
    }

    public void setAlphaMin(float alphaMin) {
        this.alphaMin = alphaMin;
    }

    public float getAlphaMax() {
        return this.alphaMax;
    }

    public void setAlphaMax(float alphaMax) {
        this.alphaMax = alphaMax;
    }
}

