/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightColorSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightFakeDepthSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightLinesSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightProfileSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightRoadSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmHeightSurroundReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmKmlSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLinePatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmLineSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmMarkersSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonPatternSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmPolygonTileSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.OsmShieldSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmStyle;
import de.wideportal.maprender.config.xml.osm.OsmTextSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmTileSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilter;
import de.wideportal.maprender.config.xml.osm.filter.OsmRuleFilterResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OsmRuleAccessor
extends BaseAccessor {
    public static final float DEFAULT_OPACITY = 1.0f;
    private Optional<Double> cachedMinScaleDenominator = null;
    private Optional<Double> cachedMaxScaleDenominator = null;
    private Float cachedParentOpacity = null;
    private OsmRule osmRule;

    public OsmRuleAccessor(OsmRule osmRule) {
        this.osmRule = osmRule;
    }

    public OsmRule getOsmRule() {
        return this.osmRule;
    }

    public Optional<Double> getMinScaleDenominator() {
        if (this.cachedMinScaleDenominator == null) {
            this.cachedMinScaleDenominator = this.safeParseDouble(this.osmRule.getMinScaleDenominator());
        }
        return this.cachedMinScaleDenominator;
    }

    public Optional<Double> getMaxScaleDenominator() {
        if (this.cachedMaxScaleDenominator == null) {
            this.cachedMaxScaleDenominator = this.safeParseDouble(this.osmRule.getMaxScaleDenominator());
        }
        return this.cachedMaxScaleDenominator;
    }

    public Optional<String> getFilter() {
        return Optional.ofNullable(this.osmRule.getFilter());
    }

    public OsmRuleFilter getRuleFilter() {
        return this.osmRule.getRuleFilter();
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmRule.getIdentifier());
    }

    public OsmStyle getParent() {
        return this.osmRule.getParent();
    }

    public Float getParentOpacity() {
        if (this.cachedParentOpacity == null) {
            this.cachedParentOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmRule.getParent().getOpacity()), 1.0f);
        }
        return this.cachedParentOpacity;
    }

    public List<OsmShieldSymbolizer> getShieldSymbolizers() {
        List<OsmShieldSymbolizer> shieldSymbolizers = this.osmRule.getShieldSymbolizers();
        if (shieldSymbolizers == null) {
            shieldSymbolizers = new ArrayList<OsmShieldSymbolizer>();
            this.osmRule.setShieldSymbolizers(shieldSymbolizers);
        }
        return shieldSymbolizers;
    }

    public List<OsmLineSymbolizer> getLineSymbolizers() {
        List<OsmLineSymbolizer> lineSymbolizers = this.osmRule.getLineSymbolizers();
        if (lineSymbolizers == null) {
            lineSymbolizers = new ArrayList<OsmLineSymbolizer>();
            this.osmRule.setLineSymbolizers(lineSymbolizers);
        }
        return lineSymbolizers;
    }

    public List<OsmTextSymbolizer> getTextSymbolizers() {
        List<OsmTextSymbolizer> textSymbolizers = this.osmRule.getTextSymbolizers();
        if (textSymbolizers == null) {
            textSymbolizers = new ArrayList<OsmTextSymbolizer>();
            this.osmRule.setTextSymbolizers(textSymbolizers);
        }
        return textSymbolizers;
    }

    public List<OsmMarkersSymbolizer> getMarkersSymbolizers() {
        List<OsmMarkersSymbolizer> markersSymbolizers = this.osmRule.getMarkersSymbolizers();
        if (markersSymbolizers == null) {
            markersSymbolizers = new ArrayList<OsmMarkersSymbolizer>();
            this.osmRule.setMarkersSymbolizers(markersSymbolizers);
        }
        return markersSymbolizers;
    }

    public List<OsmPolygonSymbolizer> getPolygonSymbolizers() {
        List<OsmPolygonSymbolizer> polygonSymbolizers = this.osmRule.getPolygonSymbolizers();
        if (polygonSymbolizers == null) {
            polygonSymbolizers = new ArrayList<OsmPolygonSymbolizer>();
            this.osmRule.setPolygonSymbolizers(polygonSymbolizers);
        }
        return polygonSymbolizers;
    }

    public List<OsmHeightRoadSymbolizer> getHeightRoadSymbolizers() {
        List<OsmHeightRoadSymbolizer> heightRoadSymbolizers = this.osmRule.getHeightRoadSymbolizers();
        if (heightRoadSymbolizers == null) {
            heightRoadSymbolizers = new ArrayList<OsmHeightRoadSymbolizer>();
            this.osmRule.setHeightRoadSymbolizers(heightRoadSymbolizers);
        }
        return heightRoadSymbolizers;
    }

    public List<OsmHeightColorSymbolizer> getHeightColorSymbolizers() {
        List<OsmHeightColorSymbolizer> heightColorSymbolizers = this.osmRule.getHeightColorSymbolizers();
        if (heightColorSymbolizers == null) {
            heightColorSymbolizers = new ArrayList<OsmHeightColorSymbolizer>();
            this.osmRule.setHeightColorSymbolizers(heightColorSymbolizers);
        }
        return heightColorSymbolizers;
    }

    public List<OsmHeightLinesSymbolizer> getHeightLinesSymbolizers() {
        List<OsmHeightLinesSymbolizer> heightLinesSymbolizers = this.osmRule.getHeightLinesSymbolizers();
        if (heightLinesSymbolizers == null) {
            heightLinesSymbolizers = new ArrayList<OsmHeightLinesSymbolizer>();
            this.osmRule.setHeightLinesSymbolizers(heightLinesSymbolizers);
        }
        return heightLinesSymbolizers;
    }

    public List<OsmHeightReliefSymbolizer> getHeightReliefSymbolizers() {
        List<OsmHeightReliefSymbolizer> heightReliefSymbolizers = this.osmRule.getHeightReliefSymbolizers();
        if (heightReliefSymbolizers == null) {
            heightReliefSymbolizers = new ArrayList<OsmHeightReliefSymbolizer>();
            this.osmRule.setHeightReliefSymbolizers(heightReliefSymbolizers);
        }
        return heightReliefSymbolizers;
    }

    public List<OsmHeightSurroundReliefSymbolizer> getHeightSurroundReliefSymbolizers() {
        List<OsmHeightSurroundReliefSymbolizer> heightSurroundReliefSymbolizers = this.osmRule.getHeightSurroundReliefSymbolizers();
        if (heightSurroundReliefSymbolizers == null) {
            heightSurroundReliefSymbolizers = new ArrayList<OsmHeightSurroundReliefSymbolizer>();
            this.osmRule.setHeightSurroundReliefSymbolizers(heightSurroundReliefSymbolizers);
        }
        return heightSurroundReliefSymbolizers;
    }

    public List<OsmHeightFakeDepthSymbolizer> getHeightFakeDepthSymbolizers() {
        List<OsmHeightFakeDepthSymbolizer> heightFakeDepthSymbolizers = this.osmRule.getHeightFakeDepthSymbolizers();
        if (heightFakeDepthSymbolizers == null) {
            heightFakeDepthSymbolizers = new ArrayList<OsmHeightFakeDepthSymbolizer>();
            this.osmRule.setHeightFakeDepthSymbolizers(heightFakeDepthSymbolizers);
        }
        return heightFakeDepthSymbolizers;
    }

    public List<OsmHeightProfileSymbolizer> getHeightProfileSymbolizers() {
        List<OsmHeightProfileSymbolizer> heightProfileSymbolizers = this.osmRule.getHeightProfileSymbolizers();
        if (heightProfileSymbolizers == null) {
            heightProfileSymbolizers = new ArrayList<OsmHeightProfileSymbolizer>();
            this.osmRule.setHeightProfileSymbolizers(heightProfileSymbolizers);
        }
        return heightProfileSymbolizers;
    }

    public List<OsmTileSymbolizer> getTileSymbolizers() {
        List<OsmTileSymbolizer> tileSymbolizers = this.osmRule.getTileSymbolizers();
        if (tileSymbolizers == null) {
            tileSymbolizers = new ArrayList<OsmTileSymbolizer>();
            this.osmRule.setTileSymbolizers(tileSymbolizers);
        }
        return tileSymbolizers;
    }

    public List<OsmKmlSymbolizer> getKmlSymbolizers() {
        List<OsmKmlSymbolizer> kmlSymbolizers = this.osmRule.getKmlSymbolizers();
        if (kmlSymbolizers == null) {
            kmlSymbolizers = new ArrayList<OsmKmlSymbolizer>();
            this.osmRule.setKmlSymbolizers(kmlSymbolizers);
        }
        return kmlSymbolizers;
    }

    public List<OsmPolygonPatternSymbolizer> getPolygonPatternSymbolizers() {
        List<OsmPolygonPatternSymbolizer> polygonPatternSymbolizer = this.osmRule.getPolygonPatternSymbolizer();
        if (polygonPatternSymbolizer == null) {
            polygonPatternSymbolizer = new ArrayList<OsmPolygonPatternSymbolizer>();
            this.osmRule.setPolygonPatternSymbolizer(polygonPatternSymbolizer);
        }
        return polygonPatternSymbolizer;
    }

    public List<OsmPolygonTileSymbolizer> getPolygonTileSymbolizers() {
        List<OsmPolygonTileSymbolizer> polygonTileSymbolizer = this.osmRule.getPolygonTileSymbolizer();
        if (polygonTileSymbolizer == null) {
            polygonTileSymbolizer = new ArrayList<OsmPolygonTileSymbolizer>();
            this.osmRule.setPolygonTileSymbolizer(polygonTileSymbolizer);
        }
        return polygonTileSymbolizer;
    }

    public List<OsmLinePatternSymbolizer> getLinePatternSymbolizers() {
        List<OsmLinePatternSymbolizer> linePatternSymbolizer = this.osmRule.getLinePatternSymbolizer();
        if (linePatternSymbolizer == null) {
            linePatternSymbolizer = new ArrayList<OsmLinePatternSymbolizer>();
            this.osmRule.setLinePatternSymbolizer(linePatternSymbolizer);
        }
        return linePatternSymbolizer;
    }

    public Optional<OsmRuleFilterResult> getRuleFilterResult() {
        return this.osmRule.getRuleFilterResult();
    }

    public String toString() {
        return "OsmRuleAccessor[" + this.osmRule + "]";
    }
}

