/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmLineSymbolizer;
import de.wideportal.maprender.config.xml.osm.OsmRule;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.geom.AbstractLineFilter;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmLineSymbolizerAccessor
extends BaseAccessor {
    public static final String DEFAULT_LINE_JOIN = "miter";
    public static final String DEFAULT_LINE_CAP = "butt";
    public static final Color DEFAULT_STROKE = Color.BLACK;
    public static final float DEFAULT_OPACITY = 1.0f;
    public static final float DEFAULT_DASH_OFFSET = 0.0f;
    public static final double DEFAULT_SIMPLIFY = 1.0;
    public static final String DEFAULT_SIMPLIFY_ALGORITHM = "visvalingam-whyatt";
    private Float cachedStrokeWidth = null;
    private String cachedStrokeLinejoin = null;
    private String cachedStrokeLinecap = null;
    private Color cachedStroke = null;
    private Float cachedStrokeOpacity = null;
    private Optional<float[]> cachedStrokeDasharray = null;
    private Float cachedStrokeDashoffset = null;
    private Double cachedSimplify = null;
    private OsmLineSymbolizer osmLineSymbolizer;

    public OsmLineSymbolizerAccessor(OsmLineSymbolizer osmLineSymbolizer) {
        this.osmLineSymbolizer = osmLineSymbolizer;
    }

    public OsmLineSymbolizer getOsmLineSymbolizer() {
        return this.osmLineSymbolizer;
    }

    public Double getSimplify() {
        if (this.cachedSimplify == null) {
            this.cachedSimplify = this.getFromOptionalOrElse(this.safeParseDouble(this.osmLineSymbolizer.getSimplify()), 1.0);
        }
        return this.cachedSimplify;
    }

    public AbstractLineFilter getSimplifyAlgorithmFreshlyInstanced() {
        String algorithm = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmLineSymbolizer.getSimplifyAlgorithm()), DEFAULT_SIMPLIFY_ALGORITHM);
        return AbstractLineFilter.getLineFilter(Optional.of(algorithm), this.getSimplify());
    }

    public Float getStrokeWidth() {
        if (this.cachedStrokeWidth == null) {
            this.cachedStrokeWidth = this.getFromOptionalOrElse(this.safeParseFloat(this.osmLineSymbolizer.getStrokeWidth()), 1.0f);
        }
        return this.cachedStrokeWidth;
    }

    public String getStrokeLinejoin() {
        if (this.cachedStrokeLinejoin == null) {
            this.cachedStrokeLinejoin = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmLineSymbolizer.getStrokeLinejoin()), DEFAULT_LINE_JOIN);
        }
        return this.cachedStrokeLinejoin;
    }

    public String getStrokeLinecap() {
        if (this.cachedStrokeLinecap == null) {
            this.cachedStrokeLinecap = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmLineSymbolizer.getStrokeLinecap()), DEFAULT_LINE_CAP);
        }
        return this.cachedStrokeLinecap;
    }

    public Color getStroke() {
        if (this.cachedStroke == null) {
            Optional<String> optionalStroke = this.safeGetNonEmptyString(this.osmLineSymbolizer.getStroke());
            this.cachedStroke = optionalStroke.isPresent() ? ColorUtil.getColorFromString(optionalStroke.get()) : DEFAULT_STROKE;
        }
        return this.cachedStroke;
    }

    public Optional<String> getStrokeCData() {
        String stroke;
        Optional<String> optionalStroke = this.safeGetNonEmptyString(this.osmLineSymbolizer.getStroke());
        if (optionalStroke.isPresent() && (stroke = optionalStroke.get()).toUpperCase().contains("CDATA")) {
            return optionalStroke;
        }
        return Optional.empty();
    }

    public Float getStrokeOpacity() {
        if (this.cachedStrokeOpacity == null) {
            this.cachedStrokeOpacity = this.getFromOptionalOrElse(this.safeParseFloat(this.osmLineSymbolizer.getStrokeOpacity()), 1.0f);
        }
        return this.cachedStrokeOpacity;
    }

    public Optional<float[]> getStrokeDasharray() {
        if (this.cachedStrokeDasharray == null) {
            Optional<String> optionalDashArray = this.safeGetNonEmptyString(this.osmLineSymbolizer.getStrokeDasharray());
            if (optionalDashArray.isPresent()) {
                String dashPatternString = optionalDashArray.get();
                String[] dashPatternParts = dashPatternString.split(",");
                float[] dashPattern = new float[dashPatternParts.length];
                for (int i = 0; i < dashPatternParts.length; ++i) {
                    dashPattern[i] = Float.parseFloat(dashPatternParts[i].trim());
                }
                this.cachedStrokeDasharray = Optional.of(dashPattern);
            } else {
                this.cachedStrokeDasharray = Optional.empty();
            }
        }
        return this.cachedStrokeDasharray;
    }

    private String getStrokeDashArrayAsString(Optional<float[]> optionalStrokeDashArray) {
        if (optionalStrokeDashArray.isPresent()) {
            float[] dashArray = optionalStrokeDashArray.get();
            Object result = "[";
            for (float value : dashArray) {
                result = (String)result + value + " ";
            }
            result = (String)result + "]";
            return result;
        }
        return "";
    }

    public Float getStrokeDashoffset() {
        if (this.cachedStrokeDashoffset == null) {
            this.cachedStrokeDashoffset = this.getFromOptionalOrElse(this.safeParseFloat(this.osmLineSymbolizer.getStrokeDashoffset()), 0.0f);
        }
        return this.cachedStrokeDashoffset;
    }

    public OsmRule getParent() {
        return this.osmLineSymbolizer.getParent();
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmLineSymbolizer.getIdentifier());
    }

    public String toString() {
        return "OsmLineSymbolizerAccessor[" + this.osmLineSymbolizer.toString() + "]";
    }
}

